/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.hostprofile.impl.hostcustomizations;

import com.vmware.vim.binding.vim.TaskInfo;
import com.vmware.vim.binding.vim.profile.DeferredPolicyOptionParameter;
import com.vmware.vim.binding.vim.profile.host.AnswerFile;
import com.vmware.vim.binding.vim.profile.host.ExecuteResult;
import com.vmware.vim.binding.vim.profile.host.ProfileManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.tasks.TaskMonitor;
import com.vmware.vsphere.client.hostprofile.data.DeferredSettingsValidationResult;
import com.vmware.vsphere.client.hostprofile.data.HostApplyConfigData;
import com.vmware.vsphere.client.hostprofile.data.HostApplyConfigSpecData;
import com.vmware.vsphere.client.hostprofile.data.h5.HostCustomizationIntermediateValidationResult;
import com.vmware.vsphere.client.hostprofile.impl.I18nUtil;
import com.vmware.vsphere.client.hostprofile.impl.hostcustomizations.HostCustomizationsBatchService;
import com.vmware.vsphere.client.hostprofile.impl.hostcustomizations.HostCustomizationsService;
import com.vmware.vsphere.client.hostprofile.impl.hostcustomizations.data.DeferredPolicyOptionData;
import com.vmware.vsphere.client.hostprofile.util.HostProfileUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HostApplyConfigService {
    private static final Log logger = LogFactory.getLog(HostApplyConfigService.class);
    private final HostCustomizationsService hostCustomizationsService;
    private final TaskMonitor taskMonitor;
    private final HostCustomizationsBatchService hostCustomizationsBatchService;

    public HostApplyConfigService(TaskMonitor taskMonitor, HostCustomizationsService hostCustomizationsService, HostCustomizationsBatchService hostCustomizationsBatchService) {
        this.taskMonitor = taskMonitor;
        this.hostCustomizationsService = hostCustomizationsService;
        this.hostCustomizationsBatchService = hostCustomizationsBatchService;
    }

    public HostCustomizationIntermediateValidationResult validateHostApplyConfigData(ManagedObjectReference[] hosts, Map<ManagedObjectReference, DeferredPolicyOptionParameter[]> deferredPolicyOptionParameterMap) throws Exception {
        HostCustomizationIntermediateValidationResult result = new HostCustomizationIntermediateValidationResult();
        if (hosts == null || hosts.length == 0) {
            return result;
        }
        ProfileManager profileManager = this.hostCustomizationsService.getProfileManager(hosts);
        HostApplyConfigSpecData applyConfigSpecData = this.createHostApplyConfigSpecData(profileManager, hosts, deferredPolicyOptionParameterMap);
        List faults = applyConfigSpecData.faults;
        if (faults.size() > 0) {
            result.genericErrors = faults;
        }
        Collection applyHostConfigSpecs = applyConfigSpecData.hostApplyConfigMap.values();
        HashMap<String, HostApplyConfigData> cachedResults = new HashMap<String, HostApplyConfigData>();
        HashMap<ManagedObjectReference, DeferredSettingsValidationResult> validationResults = new HashMap<ManagedObjectReference, DeferredSettingsValidationResult>();
        boolean hasErrors = false;
        for (ProfileManager.ApplyHostConfigSpec applyHostConfigSpec : applyHostConfigSpecs) {
            DeferredSettingsValidationResult validationResult = new DeferredSettingsValidationResult((ExecuteResult)applyHostConfigSpec);
            if (!ExecuteResult.Status.success.toString().equals(validationResult.status)) {
                hasErrors = true;
            }
            validationResults.put(applyHostConfigSpec.getHost(), validationResult);
            HostApplyConfigData hostApplyConfig = HostProfileUtils.createHostApplyConfigData((ProfileManager.ApplyHostConfigSpec)applyHostConfigSpec);
            cachedResults.put(ManagedObjectUtil.morefToString((ManagedObjectReference)applyHostConfigSpec.getHost()), hostApplyConfig);
        }
        result.hostToValidationResult = validationResults;
        if (!hasErrors) {
            result.cachedResults = cachedResults.values().toArray(new HostApplyConfigData[cachedResults.size()]);
        }
        return result;
    }

    public HostApplyConfigSpecData readHostApplyConfigData(ManagedObjectReference[] hosts, Object[] rows) {
        HostApplyConfigSpecData applyConfigSpecs = new HostApplyConfigSpecData();
        applyConfigSpecs.faults = new ArrayList();
        applyConfigSpecs.hostApplyConfigMap = new HashMap();
        try {
            ProfileManager profileManger = this.hostCustomizationsService.getProfileManager(hosts);
            Map<ManagedObjectReference, DeferredPolicyOptionParameter[]> userInputMap = this.getDeferredPolicyOptionParameterMap(profileManger, hosts, rows, applyConfigSpecs.faults);
            if (applyConfigSpecs.faults.size() > 0) {
                logger.error((Object)"Can't read host apply config specs, the return host customizations have errors.");
                return applyConfigSpecs;
            }
            return this.createHostApplyConfigSpecData(profileManger, hosts, userInputMap);
        }
        catch (Exception e) {
            applyConfigSpecs.faults.add(MixedUtil.getMethodFault((Throwable)e));
            return applyConfigSpecs;
        }
    }

    private HostApplyConfigSpecData createHostApplyConfigSpecData(ProfileManager profileManager, ManagedObjectReference[] hosts, Map<ManagedObjectReference, DeferredPolicyOptionParameter[]> userInputMap) {
        ProfileManager.ApplyHostConfigSpec[] applyHostConfigSpecs;
        HostApplyConfigSpecData applyConfigSpecs = new HostApplyConfigSpecData();
        applyConfigSpecs.faults = new ArrayList();
        applyConfigSpecs.hostApplyConfigMap = new HashMap();
        for (ProfileManager.ApplyHostConfigSpec applyHostConfigSpec : applyHostConfigSpecs = this.generateHostApplyConfigSpecs(profileManager, hosts, userInputMap, applyConfigSpecs.faults)) {
            applyConfigSpecs.hostApplyConfigMap.put(applyHostConfigSpec.getHost(), applyHostConfigSpec);
        }
        return applyConfigSpecs;
    }

    private ProfileManager.ApplyHostConfigSpec[] generateHostApplyConfigSpecs(ProfileManager profileManager, ManagedObjectReference[] hosts, Map<ManagedObjectReference, DeferredPolicyOptionParameter[]> userInputMap, List<Exception> faults) {
        Object[] applyHostConfigSpecs = new ProfileManager.ApplyHostConfigSpec[]{};
        if (ArrayUtils.isEmpty((Object[])hosts)) {
            return applyHostConfigSpecs;
        }
        ProfileManager.StructuredCustomizations[] hostCustomizationSpecs = this.getStructuredCustomizations(hosts, userInputMap);
        try {
            ManagedObjectReference preCheckRemediateTask = profileManager.generateHostConfigTaskSpec(hostCustomizationSpecs);
            TaskInfo taskInfo = this.taskMonitor.monitorTask(preCheckRemediateTask);
            if (taskInfo.error != null) {
                logger.error((Object)"Pre-check remediate task finished with error.", (Throwable)taskInfo.error);
                MethodFault methodFault = MixedUtil.getMethodFault((Throwable)taskInfo.error);
                faults.add((Exception)methodFault);
            }
            if (taskInfo.result != null) {
                applyHostConfigSpecs = (ProfileManager.ApplyHostConfigSpec[])taskInfo.result;
            }
        }
        catch (Exception e) {
            logger.error((Object)"Can't generate generateHostConfigTaskSpec", (Throwable)e);
            MethodFault methodFault = MixedUtil.getMethodFault((Throwable)e);
            faults.add((Exception)methodFault);
            return applyHostConfigSpecs;
        }
        if (ArrayUtils.isEmpty((Object[])applyHostConfigSpecs)) {
            logger.error((Object)"Return generateHostConfigTaskSpec result is empty");
            String errMsg = I18nUtil.getLocalizedString("deferredSettings.errorReadHostApplyConfig");
            MethodFault methodFault = MixedUtil.getMethodFault((Throwable)new Exception(errMsg));
            faults.add((Exception)methodFault);
        }
        return applyHostConfigSpecs;
    }

    private Map<ManagedObjectReference, DeferredPolicyOptionParameter[]> getDeferredPolicyOptionParameterMap(ProfileManager profileManger, ManagedObjectReference[] hosts, Object[] rows, List<Exception> faults) throws Exception {
        Map<ManagedObjectReference, DeferredPolicyOptionParameter[]> userInputMap;
        if (rows != null) {
            Map<ManagedObjectReference, String> hostEntityNameMap = this.hostCustomizationsService.createHostEntityNameMap(hosts);
            userInputMap = this.hostCustomizationsService.createDeferredPolicyOptionParameterMap(rows, hostEntityNameMap);
        } else {
            DeferredPolicyOptionData deferredPolicyData = this.hostCustomizationsBatchService.getDeferredHostSettingsForHosts(profileManger, hosts);
            userInputMap = deferredPolicyData.getUserInputMap();
            faults.addAll(deferredPolicyData.getFaults());
        }
        return userInputMap;
    }

    private ProfileManager.StructuredCustomizations[] getStructuredCustomizations(ManagedObjectReference[] hosts, Map<ManagedObjectReference, DeferredPolicyOptionParameter[]> userInputMap) {
        ProfileManager.StructuredCustomizations[] hostCustomizationSpecs = new ProfileManager.StructuredCustomizations[hosts.length];
        for (int i = 0; i < hosts.length; ++i) {
            ManagedObjectReference hostRef = hosts[i];
            ProfileManager.StructuredCustomizations hostCustomizationSpec = new ProfileManager.StructuredCustomizations();
            hostCustomizationSpec.setEntity(hostRef);
            this.addCustomizations(userInputMap, hostRef, hostCustomizationSpec);
            hostCustomizationSpecs[i] = hostCustomizationSpec;
        }
        return hostCustomizationSpecs;
    }

    private void addCustomizations(Map<ManagedObjectReference, DeferredPolicyOptionParameter[]> userInputMap, ManagedObjectReference hostRef, ProfileManager.StructuredCustomizations hostCustomizationSpec) {
        if (userInputMap == null) {
            return;
        }
        Object[] deferredParams = userInputMap.get(hostRef);
        if (!ArrayUtils.isEmpty((Object[])deferredParams)) {
            AnswerFile customizations = new AnswerFile();
            customizations.setUserInput((DeferredPolicyOptionParameter[])deferredParams);
            customizations.setCreatedTime(Calendar.getInstance());
            customizations.setModifiedTime(Calendar.getInstance());
            hostCustomizationSpec.setCustomizations(customizations);
        }
    }
}

