/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.hostprofile.impl.hostcustomizations;

import com.vmware.vim.binding.vim.profile.DeferredPolicyOptionParameter;
import com.vmware.vim.binding.vim.profile.PolicyMetadata;
import com.vmware.vim.binding.vim.profile.ProfileCategoryMetadata;
import com.vmware.vim.binding.vim.profile.ProfileComponentMetadata;
import com.vmware.vim.binding.vim.profile.ProfileMetadata;
import com.vmware.vim.binding.vim.profile.ProfilePropertyPath;
import com.vmware.vim.binding.vim.profile.host.ExecuteResult;
import com.vmware.vim.binding.vim.profile.host.HostApplyProfile;
import com.vmware.vim.binding.vim.profile.host.HostProfile;
import com.vmware.vim.binding.vim.profile.host.ProfileManager;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vim.binding.vmodl.LocalizableMessage;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vise.data.common.DynamicObject;
import com.vmware.vise.data.common.PropertyValidationNode;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.metadata.PropertyNodeDescriptor;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.commons.i18n.LocalizationUtil;
import com.vmware.vsphere.client.hostprofile.data.DeferredSettingsValidationResult;
import com.vmware.vsphere.client.hostprofile.data.ProfileWrapper;
import com.vmware.vsphere.client.hostprofile.data.h5.HostCustomizationIntermediateValidationResult;
import com.vmware.vsphere.client.hostprofile.data.h5.HostCustomizationSetting;
import com.vmware.vsphere.client.hostprofile.impl.I18nUtil;
import com.vmware.vsphere.client.hostprofile.impl.PostProcessUtil;
import com.vmware.vsphere.client.hostprofile.impl.hostcustomizations.DeferredHostSettingsService;
import com.vmware.vsphere.client.hostprofile.impl.hostcustomizations.HostCustomizationsSettingsService;
import com.vmware.vsphere.client.hostprofile.impl.hostcustomizations.HostCustomizationsUtil;
import com.vmware.vsphere.client.hostprofile.util.HostProfileUtils;
import com.vmware.vsphere.client.hostprofile.util.ProfilePathUtil;
import com.vmware.vsphere.client.hostprofile.util.Unwrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HostCustomizationsService {
    private static final Log logger = LogFactory.getLog(HostCustomizationsService.class);
    private static final String VALIDATION_ROOT_KEY = "validationRoot";
    private static final String VALUE = "value";
    private final DeferredHostSettingsService deferredHostSettingsService;
    private final HostCustomizationsSettingsService hostCustomizationsSettingsService;
    private final QueryExecutor queryExecutor;

    public HostCustomizationsService(QueryExecutor queryExecutor, DeferredHostSettingsService deferredHostSettingsService, HostCustomizationsSettingsService hostCustomizationsSettingsService) {
        this.queryExecutor = queryExecutor;
        this.deferredHostSettingsService = deferredHostSettingsService;
        this.hostCustomizationsSettingsService = hostCustomizationsSettingsService;
    }

    HostApplyProfile getHostApplyProfile(ManagedObjectReference profileRef, boolean isNewlyAssociatedProfile, ProfileWrapper hostApplyProfileWrapper, PolicyMetadata[] policyMetadata) throws Exception {
        if (hostApplyProfileWrapper != null) {
            HostApplyProfile applyProfile = Unwrapper.unwrap((ProfileWrapper)hostApplyProfileWrapper);
            PostProcessUtil.postProcessProfile(applyProfile, policyMetadata);
            return applyProfile;
        }
        if (isNewlyAssociatedProfile) {
            HostProfile profile = (HostProfile)ManagedObjectUtil.getManagedObject((ManagedObjectReference)profileRef);
            HostApplyProfile applyProfile = ((HostProfile.ConfigInfo)profile.getConfig()).applyProfile;
            return applyProfile;
        }
        return null;
    }

    public Map<ManagedObjectReference, String> createHostEntityNameMap(ManagedObjectReference[] hosts) throws Exception {
        HashMap<ManagedObjectReference, String> map = new HashMap<ManagedObjectReference, String>();
        if (ArrayUtils.isEmpty((Object[])hosts)) {
            return map;
        }
        PropertyValue[] hostNames = this.getEntitiesName(hosts);
        if (hostNames == null) {
            return map;
        }
        for (PropertyValue name : hostNames) {
            map.put((ManagedObjectReference)name.resourceObject, (String)name.value);
        }
        return map;
    }

    public ProfileManager.HostProfileMetadata getHostProfilePolicyMetadata(ManagedObjectReference profileRef) throws Exception {
        return HostProfileUtils.getHostProfileMetadata((ManagedObjectReference)profileRef, (ProfileManager.MetadataTypes[])new ProfileManager.MetadataTypes[]{ProfileManager.MetadataTypes.policy});
    }

    PropertyValue[] getEntitiesName(ManagedObjectReference[] entities) throws Exception {
        if (entities == null || entities.length == 0) {
            return null;
        }
        try {
            return this.queryExecutor.getProperties((Object[])entities, new String[]{"name"});
        }
        catch (Exception e) {
            logger.error((Object)"The host name could not be retrieved", (Throwable)e);
            throw e;
        }
    }

    String getEntityName(PropertyValue[] names, ManagedObjectReference entity) {
        if (names == null || entity == null) {
            return null;
        }
        for (PropertyValue name : names) {
            if (!entity.equals(name.resourceObject) || !(name.value instanceof String)) continue;
            return (String)name.value;
        }
        return null;
    }

    public ProfileManager getProfileManager(ManagedObjectReference[] hosts) throws Exception {
        ProfileManager profileManager = null;
        for (ManagedObjectReference host : hosts) {
            try {
                profileManager = HostProfileUtils.getProfileManager((String)host.getServerGuid());
                break;
            }
            catch (Exception e) {
                logger.warn((Object)"Can't get profile manager", (Throwable)e);
            }
        }
        if (profileManager == null) {
            String errMsg = I18nUtil.getLocalizedString("error.readHostConfigurations");
            throw new Exception(errMsg);
        }
        return profileManager;
    }

    public boolean isParallelOperationsEnabled(ManagedObjectReference entity) throws Exception {
        try {
            return (Boolean)this.queryExecutor.getProperty((Object)entity, "isParallelOperationsEnabled");
        }
        catch (Exception e) {
            logger.error((Object)"Can't retrieve 'isParallelOperationsEnabled' property", (Throwable)e);
            throw e;
        }
    }

    public boolean isBulkAnswerFileEnabled(ManagedObjectReference entity) throws Exception {
        try {
            return (Boolean)this.queryExecutor.getProperty((Object)entity, "isBulkAnswerFileEnabled");
        }
        catch (Exception e) {
            logger.error((Object)"Can't retrieve 'isBulkAnswerFileEnabled' property", (Throwable)e);
            throw e;
        }
    }

    public HostCustomizationIntermediateValidationResult createValidationResult(ProfileManager.AnswerFileValidationResultMap[] results) {
        ArrayList<MethodFault> errors = new ArrayList<MethodFault>();
        HashMap<ManagedObjectReference, DeferredSettingsValidationResult> validationResults = new HashMap<ManagedObjectReference, DeferredSettingsValidationResult>();
        for (ProfileManager.AnswerFileValidationResultMap answerFileValidationResult : results) {
            if (answerFileValidationResult == null) continue;
            if (answerFileValidationResult.fault != null) {
                errors.add(MixedUtil.getMethodFault((Throwable)answerFileValidationResult.fault));
                continue;
            }
            if (answerFileValidationResult.getValidationResult() == null) continue;
            DeferredSettingsValidationResult validationResult = new DeferredSettingsValidationResult(answerFileValidationResult.getValidationResult());
            validationResults.put(answerFileValidationResult.getHost(), validationResult);
        }
        HostCustomizationIntermediateValidationResult result = new HostCustomizationIntermediateValidationResult();
        if (!errors.isEmpty()) {
            result.genericErrors = errors;
        }
        if (validationResults.isEmpty()) {
            result.cachedResults = new HashMap();
        }
        result.hostToValidationResult = validationResults;
        return result;
    }

    public Map<String, PropertyValidationNode> processValidationResults(DeferredSettingsValidationResult validationResult, String hostName, DeferredPolicyOptionParameter[] deferredHostSettings) {
        HashMap<String, PropertyValidationNode> validationMessages = new HashMap<String, PropertyValidationNode>();
        if (validationResult == null || ExecuteResult.Status.success.toString().equals(validationResult.status)) {
            return validationMessages;
        }
        if (ExecuteResult.Status.needInput.toString().equals(validationResult.status)) {
            String errorMessage = I18nUtil.getLocalizedString("deferredSettings.errors.generalError");
            this.addValidationMessage(validationMessages, VALIDATION_ROOT_KEY, null, this.getContextValidationMessage(hostName, errorMessage));
            return validationMessages;
        }
        if (validationResult.errors == null) {
            return validationMessages;
        }
        for (DeferredSettingsValidationResult.ValidationError error : validationResult.errors) {
            ProfilePropertyPath errorPath = error.path;
            String property = null;
            String policyId = null;
            if (errorPath != null) {
                DeferredPolicyOptionParameter failedParameter = this.findFailedParameter(errorPath, deferredHostSettings);
                policyId = errorPath.policyId;
                if (failedParameter != null && failedParameter.parameter.length > 0) {
                    property = errorPath.parameterId != null ? errorPath.parameterId : failedParameter.parameter[0].getKey();
                }
            }
            LocalizableMessage localizableMessage = error.message;
            String errorMessage = LocalizationUtil.getLocalizedMessage((String)localizableMessage.getKey(), (KeyAnyValue[])localizableMessage.getArg());
            if (property == null || policyId == null) {
                logger.warn((Object)("Could not find failed property for policy: " + (errorPath != null ? errorPath.policyId : null)));
                this.addValidationMessage(validationMessages, VALIDATION_ROOT_KEY, null, this.getContextValidationMessage(hostName, errorMessage));
                continue;
            }
            String primaryKey = HostCustomizationsUtil.buildRowPrimaryKey(hostName, property, policyId, errorPath.profilePath);
            String fullPropertyPath = String.format("[%s].%s", primaryKey, VALUE);
            this.addValidationMessage(validationMessages, fullPropertyPath, primaryKey, errorMessage);
        }
        return validationMessages;
    }

    private void addValidationMessage(Map<String, PropertyValidationNode> validationMessages, String validationPath, String primaryKey, String validationMessage) {
        PropertyValidationNode validationNode = validationMessages.get(validationPath);
        if (validationNode == null) {
            validationNode = new PropertyValidationNode();
            if (primaryKey != null) {
                validationNode.propertyName = VALUE;
                validationNode.key = primaryKey;
            }
            validationNode.validationMessages = new String[]{validationMessage};
            validationMessages.put(validationPath, validationNode);
        } else {
            String[] errors = new String[validationNode.validationMessages.length + 1];
            System.arraycopy(validationNode.validationMessages, 0, errors, 0, validationNode.validationMessages.length);
            errors[errors.length - 1] = validationMessage;
        }
    }

    String getContextValidationMessage(String hostName, String message) {
        return I18nUtil.getLocalizedString("error.validateDeferredSettings", hostName, message);
    }

    private DeferredPolicyOptionParameter findFailedParameter(ProfilePropertyPath errorPath, DeferredPolicyOptionParameter[] deferredHostSettings) {
        if (errorPath == null || deferredHostSettings == null) {
            return null;
        }
        for (DeferredPolicyOptionParameter hostSetting : deferredHostSettings) {
            if (!hostSetting.inputPath.policyId.equals(errorPath.policyId)) continue;
            return hostSetting;
        }
        return null;
    }

    public Collection<DynamicObject> extractDeferredHostSettings(String hostName, PolicyMetadata[] policiesMetadata, Map<String, String> relevantProfilePaths, DeferredPolicyOptionParameter[] newDeferredSettings, DeferredPolicyOptionParameter[] oldDeferredSettings) {
        return this.deferredHostSettingsService.extractDeferredHostSettings(hostName, policiesMetadata, relevantProfilePaths, newDeferredSettings, oldDeferredSettings);
    }

    public List<HostCustomizationSetting> createHostCustomizationSettingsData(PolicyMetadata[] policiesMetadata, Map<String, String> relevantProfilePaths, Map<ManagedObjectReference, DeferredPolicyOptionParameter[]> userInputMap, Map<ManagedObjectReference, DeferredPolicyOptionParameter[]> userInputMapBeforeImport, Map<ManagedObjectReference, String> hostEntityNameMap) {
        return this.hostCustomizationsSettingsService.createHostCustomizationSettingsData(policiesMetadata, relevantProfilePaths, userInputMap, userInputMapBeforeImport, hostEntityNameMap);
    }

    public void extractDeferredSettingsMetadata(ArrayList<PropertyNodeDescriptor> resultList, PolicyMetadata[] policiesMetadata, Map<String, String> relevantProfilePaths, DeferredPolicyOptionParameter[] params) {
        this.deferredHostSettingsService.extractDeferredSettingsMetadata(resultList, policiesMetadata, relevantProfilePaths, params);
    }

    public Map<ManagedObjectReference, DeferredPolicyOptionParameter[]> createDeferredPolicyOptionParameterMap(Object[] rows, Map<ManagedObjectReference, String> hostNames) {
        HashMap<ManagedObjectReference, DeferredPolicyOptionParameter[]> deferredPolicyOptions = new HashMap<ManagedObjectReference, DeferredPolicyOptionParameter[]>();
        for (Map.Entry<ManagedObjectReference, String> entity : hostNames.entrySet()) {
            DeferredPolicyOptionParameter[] deferredSettings = this.convertDeferredSettings(rows, entity.getValue());
            if (deferredSettings == null) continue;
            deferredPolicyOptions.put(entity.getKey(), deferredSettings);
        }
        return deferredPolicyOptions;
    }

    private DeferredPolicyOptionParameter[] convertDeferredSettings(Object[] rowsData, String hostName) {
        if (rowsData == null) {
            return null;
        }
        if (rowsData instanceof HostCustomizationSetting[]) {
            return this.hostCustomizationsSettingsService.createDeferredPolicyOptionParameter((HostCustomizationSetting[])rowsData, hostName);
        }
        return this.deferredHostSettingsService.createDeferredPolicyOptionParameter(rowsData, hostName);
    }

    public Map<String, String> buildRelevantProfilePaths(ManagedObjectReference profileRef, ProfileManager.HostProfileMetadata hostProfileMeta, ProfileWrapper profileWrapper) {
        if (profileWrapper == null) {
            try {
                profileWrapper = ProfilePathUtil.buildProfileWrapper((ManagedObjectReference)profileRef, (ProfileMetadata[])hostProfileMeta.profileMetadata, (PolicyMetadata[])hostProfileMeta.policyMetadata, (ProfileCategoryMetadata[])hostProfileMeta.profileCategoryMetadata, (ProfileComponentMetadata[])hostProfileMeta.profileComponentMetadata);
            }
            catch (Throwable e) {
                logger.warn((Object)"Profile wrapper cannot be built", e);
            }
        }
        ConcurrentHashMap<String, String> relevantProfilePaths = new ConcurrentHashMap<String, String>();
        ProfilePathUtil.extractProfileParamsPaths((ProfileWrapper)profileWrapper, relevantProfilePaths);
        return relevantProfilePaths;
    }

    public Map<ManagedObjectReference, ProfileManager.HostProfileMetadata> getHostProfilesMetadata(ManagedObjectReference[] profileRefs, ProfileWrapper hostApplyProfileWrapper) throws Exception {
        Map hostProfilesMeta = hostApplyProfileWrapper == null ? HostProfileUtils.getHostProfilesMetadata((ManagedObjectReference[])profileRefs, (ProfileManager.MetadataTypes[])new ProfileManager.MetadataTypes[]{ProfileManager.MetadataTypes.profile, ProfileManager.MetadataTypes.policy, ProfileManager.MetadataTypes.category, ProfileManager.MetadataTypes.component}) : HostProfileUtils.getHostProfilesMetadata((ManagedObjectReference[])profileRefs, (ProfileManager.MetadataTypes[])new ProfileManager.MetadataTypes[]{ProfileManager.MetadataTypes.policy});
        return hostProfilesMeta;
    }
}

