/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.folder.impl;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.model.PropertyProvider;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.Folder;
import com.vmware.vim.binding.vim.ManagedEntity;
import com.vmware.vim.binding.vim.alarm.AlarmState;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vsphere.client.folder.EntityAlarmData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public final class FolderAlarmsPropertyProvider {
    private static final String TRIGGERED_ALARMS_PROPERTY = "triggeredAlarmState";
    private static final String NAME_PROPERTY = "name";
    private static final String FOLDER_TYPE = Folder.class.getSimpleName();
    private final QueryService queryService;

    public FolderAlarmsPropertyProvider(QueryServiceFactory queryServiceFactory) {
        this.queryService = queryServiceFactory.getQueryService();
    }

    @PropertyProvider(value="Folder/entitiesWithMostAlarms")
    public Collection<EntityAlarmData[]> entitiesWithMostAlarms(Collection<ManagedObjectReference> objects) {
        if (objects == null || objects.size() != 1) {
            throw new IllegalArgumentException("entitiesWithMostAlarms property can be computed only for single folder!");
        }
        ManagedObjectReference folderRef = (ManagedObjectReference)CollectionUtils.get(objects, (int)0);
        int maxCount = 10;
        boolean allAlarms = true;
        ResultSet resultSet = this.queryService.select(new String[]{TRIGGERED_ALARMS_PROPERTY}).from(new String[]{FOLDER_TYPE}).where("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)folderRef).fetch();
        HashMap<ManagedObjectReference, EntityAlarmData> alarmMap = new HashMap<ManagedObjectReference, EntityAlarmData>();
        for (ResourceItem ri : resultSet.getItems()) {
            AlarmState[] alarmStates = (AlarmState[])ri.get(TRIGGERED_ALARMS_PROPERTY);
            for (AlarmState alarmState : alarmStates) {
                if (!allAlarms && alarmState.acknowledged.booleanValue()) continue;
                ManagedObjectReference entity = alarmState.entity;
                EntityAlarmData aData = (EntityAlarmData)alarmMap.get(entity);
                ManagedEntity.Status status = alarmState.getOverallStatus();
                if (aData == null) {
                    aData = new EntityAlarmData(entity);
                    alarmMap.put(entity, aData);
                }
                if (status == ManagedEntity.Status.red) {
                    ++aData.alerts;
                    continue;
                }
                ++aData.warnings;
            }
        }
        Object[] values = alarmMap.values().toArray(new EntityAlarmData[alarmMap.size()]);
        Arrays.sort(values);
        if (values.length < maxCount) {
            maxCount = values.length;
        }
        List<Object> entityAlarmList = Arrays.asList(values).subList(0, maxCount);
        ArrayList<ManagedObjectReference> entityList = new ArrayList<ManagedObjectReference>(maxCount);
        for (EntityAlarmData entityAlarmData : entityAlarmList) {
            entityList.add(entityAlarmData.entity);
        }
        if (entityAlarmList.size() > 0) {
            ResultSet nameResult = this.queryService.select(new String[]{NAME_PROPERTY}).from(new String[]{((ManagedObjectReference)entityList.iterator().next()).getType()}).where("@modelKey", PropertyPredicate.ComparisonOperator.IN, entityList).fetch();
            for (ResourceItem ri : nameResult.getItems()) {
                EntityAlarmData aData = (EntityAlarmData)alarmMap.get(ri.getKey());
                aData.name = (String)ri.get(NAME_PROPERTY);
            }
        }
        EntityAlarmData[] entityAlarmArray = entityAlarmList.toArray(new EntityAlarmData[entityAlarmList.size()]);
        return Collections.singleton(entityAlarmArray);
    }
}

