/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.folder.impl;

import com.vmware.vim.binding.vim.DiagnosticManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vsphere.client.folder.AsciiFileContentSpec;
import com.vmware.vsphere.client.folder.FolderUtils;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VCenterLogProvider
implements PropertyProviderBean {
    private static final Log _logger = LogFactory.getLog(VCenterLogProvider.class);
    private static final String ERROR_INVALID_LOG_REQUEST = "error.invalidLogRequest";

    @type(value="Folder,HostSystem")
    public DiagnosticManager.LogDescriptor[] getLogDescriptors(ManagedObjectReference folderRef) throws Exception {
        return FolderUtils.getDiagnosticManager(folderRef).queryDescriptions(null);
    }

    @type(value="Folder,HostSystem")
    public String[] getLogFileContent(ManagedObjectReference folderRef, AsciiFileContentSpec spec) throws Exception {
        String fileKey = spec.fileKey;
        int lineOffset = spec.lineOffset;
        int lineCount = spec.lineCount;
        if (fileKey == null || lineOffset <= 0 || lineCount <= 0) {
            _logger.error((Object)("Invalid file content request: " + spec));
            throw new IllegalArgumentException(FolderUtils.getLocalizedString(ERROR_INVALID_LOG_REQUEST));
        }
        DiagnosticManager dm = FolderUtils.getDiagnosticManager(folderRef);
        DiagnosticManager.LogHeader header = null;
        ArrayList<String> lines = new ArrayList<String>(lineCount);
        do {
            header = dm.browse(null, fileKey, Integer.valueOf(lineOffset), Integer.valueOf(lineCount));
            if (lineOffset != header.lineStart) break;
            lineOffset = header.lineEnd + 1;
            lines.addAll(Arrays.asList(header.lineText));
        } while (header.lineText.length > 0 && (lineCount -= header.lineText.length) > 0);
        return lines.toArray(new String[lines.size()]);
    }

    @type(value="Folder,HostSystem")
    public int getLogFileLinesCount(ManagedObjectReference folderRef, String fileKey) throws Exception {
        if (fileKey == null) {
            _logger.error((Object)("Invalid key file name: " + fileKey));
            String errorText = FolderUtils.getLocalizedString(ERROR_INVALID_LOG_REQUEST);
            throw new IllegalArgumentException(errorText);
        }
        DiagnosticManager dm = FolderUtils.getDiagnosticManager(folderRef);
        DiagnosticManager.LogHeader header = dm.browse(null, fileKey, Integer.valueOf(Integer.MAX_VALUE), null);
        return header.lineStart;
    }
}

