/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.folder.impl;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import org.apache.commons.lang3.StringUtils;

public class VCenterNameProvider
implements PropertyProviderBean {
    private static final String RESOURCE_BUNDLE_NAME = "VCenterNameProvider";

    @type(value="VmwareDistributedVirtualSwitch,DistributedVirtualSwitch,Folder,Datacenter,ComputeResource,HostSystem,VirtualMachine,VirtualApp,ClusterComputeResource,ResourcePool,Network,DistributedVirtualPortgroup,Datastore,StoragePod,sps:SpsStorageProfile,SpsStorageProfile,OpaqueNetwork")
    public String getVCenterName(ManagedObjectReference objectRef) throws Exception {
        if (objectRef == null || StringUtils.isEmpty((CharSequence)objectRef.getServerGuid())) {
            throw new MethodFault(this.getLocalizedString("error.nullObject"));
        }
        VcService service = VimSessionUtil.getService((String)objectRef.getServerGuid());
        if (service == null) {
            throw new MethodFault(this.getLocalizedString("error.nullService"));
        }
        String vcName = VcServiceUtil.getServiceName((String)objectRef.getServerGuid());
        if (StringUtils.isEmpty((CharSequence)vcName)) {
            return service.getServiceUrl();
        }
        return vcName;
    }

    private String getLocalizedString(String key) {
        return ResourceUtil.getString((String)RESOURCE_BUNDLE_NAME, (String)key, (ClassLoader)this.getClass().getClassLoader());
    }
}

