/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.host.hardware.ciminfo.model;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public enum HealthStatus {
    HEALTH_STATUS_OK("5", "normal"),
    HEALTH_STATUS_WARNING("10", "warning"),
    HEALTH_STATUS_UNKNOWN("0", "unknown"),
    HEALTH_STATUS_ALERT("15", "alert"),
    HEALTH_STATUS_NOT_DEFINED("", "");

    private static final Log _logger;
    private static final int MIN_ALERT_LEVEL = 15;
    private String value;
    private String statusKey;

    private HealthStatus(String value, String statusKey) {
        this.value = value;
        this.statusKey = statusKey;
    }

    public String getStatusKey() {
        return this.statusKey;
    }

    public boolean isNormal() {
        return this != HEALTH_STATUS_WARNING && this != HEALTH_STATUS_ALERT;
    }

    public String getValue() {
        return this.value;
    }

    public static HealthStatus getHealthStatus(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return HEALTH_STATUS_NOT_DEFINED;
        }
        for (HealthStatus status : HealthStatus.values()) {
            if (!status.value.equals(value)) continue;
            return status;
        }
        try {
            int reading = Integer.parseInt(value);
            if (reading >= 15) {
                return HEALTH_STATUS_ALERT;
            }
        }
        catch (NumberFormatException e) {
            _logger.warn((Object)("Unknown health status: " + value));
        }
        return HEALTH_STATUS_UNKNOWN;
    }

    static {
        _logger = LogFactory.getLog(HealthStatus.class);
    }
}

