/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network;

import com.vmware.vim.binding.vim.host.HostProxySwitch;
import com.vmware.vim.binding.vim.host.VirtualSwitch;
import com.vmware.vsphere.client.modules.api.network.HostNetworkCapability;

public class HostPortUtil {
    public static int calculateAvailablePortsCountByNetworkInfo(HostNetworkCapability hostNetworkCapability, VirtualSwitch[] virtualSwitches, HostProxySwitch[] proxySwitches) {
        if (hostNetworkCapability == null || hostNetworkCapability.proxySwitchAutoScaleSupported) {
            return -1;
        }
        int portNumbersReserved = 0;
        if (proxySwitches != null) {
            for (HostProxySwitch hostProxySwitch : proxySwitches) {
                portNumbersReserved += hostProxySwitch.numPorts;
            }
        }
        if (virtualSwitches != null) {
            for (HostProxySwitch hostProxySwitch : virtualSwitches) {
                if (hostProxySwitch.spec == null) continue;
                portNumbersReserved += hostProxySwitch.spec.numPorts;
            }
        }
        return hostNetworkCapability.vssMaxPortLimit - portNumbersReserved > 0 ? hostNetworkCapability.vssMaxPortLimit - portNumbersReserved : 0;
    }
}

