/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network;

import com.vmware.vim.binding.vim.NumericRange;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class NumericRangeUtil {
    private static final String RANGE_DELIMITER = ", ";
    private static final String FROM_STRING_RANGE_DELIMITER = "[,\\n\\r]+";
    private static final String RANGE_DIVIDER = "-";

    public static String asString(NumericRange[] ranges) {
        if (ranges == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (NumericRange range : ranges) {
            if (range.start == range.end) {
                result.append(Integer.toString(range.start));
            } else {
                result.append(range.start + RANGE_DIVIDER + range.end);
            }
            result.append(RANGE_DELIMITER);
        }
        if (result.length() >= RANGE_DELIMITER.length()) {
            result.setLength(result.length() - RANGE_DELIMITER.length());
        }
        return result.toString();
    }

    public static NumericRange[] fromString(String ranges, int min, int max) {
        String[] rangeArray;
        if (ranges == null) {
            return null;
        }
        ArrayList<NumericRange> numericRanges = new ArrayList<NumericRange>();
        String[] stringArray = rangeArray = ranges == null ? null : StringUtils.stripAll((String[])ranges.split(FROM_STRING_RANGE_DELIMITER));
        if (rangeArray.length == 1 && rangeArray[0] == "") {
            return null;
        }
        for (String range : rangeArray) {
            NumericRange numericRange = NumericRangeUtil.singleRangeFromString(range, min, max);
            if (numericRange == null) {
                return null;
            }
            numericRanges.add(numericRange);
        }
        return NumericRangeUtil.validateNoOverlapping(numericRanges) != false ? numericRanges.toArray(new NumericRange[numericRanges.size()]) : null;
    }

    public static NumericRange[] fromString(String ranges) {
        return NumericRangeUtil.fromString(ranges, 0, 4094);
    }

    private static NumericRange singleRangeFromString(String range, int min, int max) {
        String[] boundaryArray;
        if (StringUtils.isEmpty((String)range) || StringUtils.countMatches((String)range, (String)RANGE_DIVIDER) > 1) {
            return null;
        }
        String[] stringArray = boundaryArray = range == null ? null : StringUtils.stripAll((String[])range.split(RANGE_DIVIDER));
        if (boundaryArray.length == 0 || boundaryArray.length > 2) {
            return null;
        }
        NumericRange numericRange = new NumericRange();
        try {
            numericRange.start = Integer.parseInt(boundaryArray[0]);
        }
        catch (NumberFormatException e) {
            return null;
        }
        if (numericRange.start < min || numericRange.start > max) {
            return null;
        }
        if (boundaryArray.length == 2) {
            try {
                numericRange.end = Integer.parseInt(boundaryArray[1]);
            }
            catch (NumberFormatException e) {
                return null;
            }
            if (numericRange.end < min || numericRange.end > max || numericRange.end < numericRange.start) {
                return null;
            }
        } else {
            numericRange.end = numericRange.start;
        }
        return numericRange;
    }

    private static Boolean validateNoOverlapping(List<NumericRange> ranges) {
        if (ranges == null) {
            return false;
        }
        for (int i = 0; i < ranges.size() - 1; ++i) {
            for (int j = i + 1; j < ranges.size(); ++j) {
                if (ranges.get((int)i).start > ranges.get((int)j).end || ranges.get((int)j).start > ranges.get((int)i).end) continue;
                return false;
            }
        }
        return true;
    }
}

