/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvportgroup.model;

import com.vmware.cis.data.model.NestedQueryBinding;
import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.cis.data.model.Relationship;
import com.vmware.vim.binding.vim.IntPolicy;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPortgroup;
import com.vmware.vim.binding.vim.dvs.VmVnicNetworkResourcePool;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vsphere.client.common.model.BaseSummaryData;
import com.vmware.vsphere.client.h5.network.dvportgroup.DvPortgroupVlanConfig;
import com.vmware.vsphere.client.h5.network.dvportgroup.model.DvPortgroupSwitchSummaryData;
import com.vmware.vsphere.client.modules.api.util.ModulesApiUtil;
import java.util.ArrayList;

@QueryBinding(value="DistributedVirtualPortgroup")
public final class DvPortgroupSummaryData
extends BaseSummaryData {
    @Property(value="DistributedVirtualPortgroup/config")
    protected DistributedVirtualPortgroup.ConfigInfo config;
    @Property(value="DistributedVirtualPortgroup/isUplinkPortgroup")
    public Boolean isUplink;
    @NestedQueryBinding
    @Relationship(value={"DistributedVirtualPortgroup/config/distributedVirtualSwitch"})
    public DvPortgroupSwitchSummaryData dvsSummaryData;
    @Property(value="DistributedVirtualPortgroup/summary/ipPoolName")
    public String ipPoolName;
    @Property(value="DistributedVirtualPortgroup/allNormalVMOrPrimaryFTVM/length")
    public int numVms;
    @Property(value="DistributedVirtualPortgroup/host/length")
    public int numHosts;
    @Property(value="DistributedVirtualPortgroup/config/vmVnicNetworkResourcePoolKey")
    public String resourcePoolKey;
    @Property(value="DistributedVirtualPortgroup/networkResourceManagementVersion")
    public int niocVersion;
    @Property(value="DistributedVirtualPortgroup/nsxManagerUrl")
    public String nsxManagerUrl;
    @Property(value="DistributedVirtualPortgroup/isNsxPortgroup")
    public Boolean isNsxPortgroup;
    @Property(value="DistributedVirtualPortgroup/dvsNetworkOffloadsEnabled")
    public Boolean isDvsNetworkOffloadEnabled;

    public ManagedObjectReference getDvsRef() {
        return (ManagedObjectReference)this.dvsSummaryData.provider;
    }

    public String getDvsIconId() {
        return this.dvsSummaryData.switchIconId;
    }

    public ManagedObjectReference getNrpRef() {
        if (!this.showNrp() || this.dvsSummaryData.dvsResourcePools == null || this.resourcePoolKey == null) {
            return null;
        }
        for (VmVnicNetworkResourcePool nrp : this.dvsSummaryData.dvsResourcePools) {
            if (nrp == null || !this.resourcePoolKey.equals(nrp.key)) continue;
            ManagedObjectReference switchMor = (ManagedObjectReference)this.dvsSummaryData.provider;
            String switchIdentifier = String.format("%s_%s", switchMor.getServerGuid(), switchMor.getValue());
            return new ManagedObjectReference("NetworkResourcePool", switchIdentifier, this.resourcePoolKey);
        }
        return null;
    }

    @Override
    public BaseSummaryData.LabelValue[] getSummaryItems() {
        if (this.config == null) {
            return new BaseSummaryData.LabelValue[0];
        }
        boolean isPortAllocationAllowed = this.isPortAllocationAllowed(this.config.getType());
        ArrayList<BaseSummaryData.LabelValue> listLabels = new ArrayList<BaseSummaryData.LabelValue>();
        listLabels.add(new BaseSummaryData.LabelValue("DvPortgroupSummaryView.pgType", this.getPortgroupType(this.config.getType())));
        if (isPortAllocationAllowed) {
            listLabels.add(new BaseSummaryData.LabelValue("DvPortgroupSummaryView.pgAlloc", this.getPortAllocationType(this.config.getAutoExpand())));
        }
        boolean isNsxPortgroup = this.isNsxPortgroup(this.config.backingType);
        if (this.config.defaultPortConfig != null && this.config.defaultPortConfig instanceof VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy) {
            VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy portConfigPolicy = (VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy)this.config.defaultPortConfig;
            IntPolicy vni = portConfigPolicy.getVNI();
            if (isNsxPortgroup && vni != null && vni.value != null && vni.value > 0) {
                listLabels.add(new BaseSummaryData.LabelValue("DvPortgroupSummaryView.VNI", vni.value));
            } else {
                DvPortgroupVlanConfig vlanConfig = new DvPortgroupVlanConfig(portConfigPolicy.getVlan(), this.dvsSummaryData != null ? this.dvsSummaryData.pvlanConfigs : null);
                String vlanTypeNameKey = vlanConfig.getVlanTypeNameKey();
                String vlanTypeValue = vlanConfig.getVlanTypeValueLocalized();
                listLabels.add(new BaseSummaryData.LabelValue(vlanTypeNameKey, vlanTypeValue));
            }
        }
        if (isNsxPortgroup) {
            if (this.config.segmentId != null) {
                listLabels.add(new BaseSummaryData.LabelValue("DvPortgroupSummaryView.segmentId", this.config.segmentId));
            } else {
                listLabels.add(new BaseSummaryData.LabelValue("DvPortgroupSummaryView.logicalSwitchId", this.config.logicalSwitchUuid));
            }
            String transportZoneName = this.config.transportZoneName != null ? this.config.transportZoneName : ModulesApiUtil.getString("networking.na");
            listLabels.add(new BaseSummaryData.LabelValue("DvPortgroupSummaryView.transportZone", transportZoneName));
            if (this.nsxManagerUrl != null) {
                listLabels.add(new BaseSummaryData.LabelValue("DvPortgroupDetailsView.nsxManager", this.nsxManagerUrl));
            }
        }
        listLabels.add(new BaseSummaryData.LabelValue("DvPortgroupDetailsView.switch", this.dvsSummaryData.switchName));
        if (!this.isUplink.booleanValue()) {
            listLabels.add(new BaseSummaryData.LabelValue("DvPortgroupDetailsView.ipPool", this.ipPoolName));
        }
        if (this.showNrp()) {
            listLabels.add(new BaseSummaryData.LabelValue("DvPortgroupDetailsView.nrp", this.nrpName()));
        }
        listLabels.add(new BaseSummaryData.LabelValue("DvPortgroupDetailsView.hosts", this.numHosts));
        listLabels.add(new BaseSummaryData.LabelValue("DvPortgroupDetailsView.vms", this.numVms));
        return listLabels.toArray(new BaseSummaryData.LabelValue[listLabels.size()]);
    }

    private boolean showNrp() {
        boolean dvsNetworkOffloadEnabled = this.isDvsNetworkOffloadEnabled != null && this.isDvsNetworkOffloadEnabled != false;
        return !dvsNetworkOffloadEnabled && this.niocVersion >= 3;
    }

    private String nrpName() {
        if (this.showNrp() && this.dvsSummaryData.dvsResourcePools != null && this.resourcePoolKey != null) {
            for (VmVnicNetworkResourcePool nrp : this.dvsSummaryData.dvsResourcePools) {
                if (nrp == null || !this.resourcePoolKey.equals(nrp.key)) continue;
                return nrp.name;
            }
        }
        return null;
    }

    private String getPortgroupType(String type) {
        DistributedVirtualPortgroup.PortgroupType pgType = Enum.valueOf(DistributedVirtualPortgroup.PortgroupType.class, type);
        switch (pgType) {
            case lateBinding: {
                return ModulesApiUtil.getString("dvpg.type.lateBinding");
            }
            case earlyBinding: {
                return ModulesApiUtil.getString("dvpg.type.earlyBinding");
            }
            case ephemeral: {
                return ModulesApiUtil.getString("dvpg.type.ephemeral");
            }
        }
        return null;
    }

    private String getPortAllocationType(boolean isAutoExpand) {
        return isAutoExpand ? ModulesApiUtil.getString("dvpg.pgAlloc.autoExpand.true") : ModulesApiUtil.getString("dvpg.pgAlloc.autoExpand.false");
    }

    private boolean isPortAllocationAllowed(String type) {
        boolean isStaticPortBinding = type.equalsIgnoreCase(DistributedVirtualPortgroup.PortgroupType.earlyBinding.toString());
        return isStaticPortBinding && this.isUplink == false;
    }

    private boolean isNsxPortgroup(String backingType) {
        return DistributedVirtualPortgroup.BackingType.nsx.toString().equals(backingType);
    }
}

