/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.host.vnic.model;

import com.vmware.cis.data.api.binding.IdentifiableQueryBinding;
import com.vmware.cis.data.model.NestedQueryBinding;
import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.vim.binding.vim.host.NetStackInstance;
import com.vmware.vim.binding.vim.host.RuntimeInfo;
import com.vmware.vim.binding.vim.host.VirtualNicManager;
import com.vmware.vim.binding.vim.host.VirtualNicManagerInfo;
import com.vmware.vise.core.model.annotation.Dto;
import com.vmware.vsphere.client.h5.network.host.vnic.model.HostVnicFeatures;
import org.apache.commons.lang3.ArrayUtils;

@QueryBinding(value="HostSystem")
@Dto
public class HostVnicServicesData
extends IdentifiableQueryBinding {
    @Property(value="HostSystem/config/virtualNicManagerInfo")
    public transient VirtualNicManagerInfo vnicManagerInfo;
    @Property(value="HostSystem/runtime/networkRuntimeInfo/netStackInstanceRuntimeInfo")
    public transient RuntimeInfo.NetStackInstanceRuntimeInfo[] netStackInstanceRuntimeInfos;
    @NestedQueryBinding
    public HostVnicFeatures hostVnicFeatures;

    public boolean getIsProvisioningTrafficEnabledForDefaultStack() {
        return this.isTrafficEnabled(NetStackInstance.SystemStackKey.vSphereProvisioning);
    }

    public boolean getIsVmotionTrafficEnabledForDefaultStack() {
        return this.isTrafficEnabled(NetStackInstance.SystemStackKey.vmotion);
    }

    public boolean getIsVsphereBackupNfcTrafficSupported() {
        return this.isTrafficSupported(VirtualNicManager.NicType.vSphereBackupNFC);
    }

    public boolean getIsNvmeTcpTrafficSupported() {
        return this.isTrafficSupported(VirtualNicManager.NicType.nvmeTcp);
    }

    public boolean getIsNvmeRdmaTrafficSupported() {
        return this.isTrafficSupported(VirtualNicManager.NicType.nvmeRdma);
    }

    private boolean isTrafficEnabled(NetStackInstance.SystemStackKey systemStackKey) {
        if (this.hostVnicFeatures.isTcpIpStackSupported && !ArrayUtils.isEmpty((Object[])this.netStackInstanceRuntimeInfos)) {
            for (RuntimeInfo.NetStackInstanceRuntimeInfo netStackInstanceRuntimeInfo : this.netStackInstanceRuntimeInfos) {
                if (netStackInstanceRuntimeInfo == null || netStackInstanceRuntimeInfo.getNetStackInstanceKey() == null || !netStackInstanceRuntimeInfo.getNetStackInstanceKey().equals(systemStackKey.name())) continue;
                return ArrayUtils.isEmpty((Object[])netStackInstanceRuntimeInfo.vmknicKeys);
            }
        }
        return true;
    }

    private boolean isTrafficSupported(VirtualNicManager.NicType nicType) {
        if (this.vnicManagerInfo == null || this.vnicManagerInfo.netConfig == null) {
            return false;
        }
        for (VirtualNicManager.NetConfig netConfig : this.vnicManagerInfo.netConfig) {
            if (!netConfig.nicType.equals(nicType.name())) continue;
            return true;
        }
        return false;
    }
}

