/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.storage.data.datastore;

import com.vmware.vim.binding.vim.host.VmfsVolume;
import com.vmware.vise.util.FormatUtil;
import java.util.ArrayList;

public class VmfsBlockSizeOptionItem {
    public int value;
    public String formattedValue;
    public VmfsConfigOptionGranularityItem[] granularityOptions;

    public static VmfsBlockSizeOptionItem[] getBlockSizeOptions(VmfsVolume.ConfigOption[] options) {
        ArrayList<VmfsBlockSizeOptionItem> items = new ArrayList<VmfsBlockSizeOptionItem>(options.length);
        for (VmfsVolume.ConfigOption option : options) {
            VmfsBlockSizeOptionItem blockSizeOption = new VmfsBlockSizeOptionItem();
            blockSizeOption.value = option.blockSizeOption;
            blockSizeOption.formattedValue = FormatUtil.getStorageFormatted((Long)Long.valueOf(option.blockSizeOption), (long)1024L, (long)0x100000L);
            int[] granularity = option.getUnmapGranularityOption();
            if (granularity != null && granularity.length > 0) {
                blockSizeOption.granularityOptions = new VmfsConfigOptionGranularityItem[granularity.length];
                for (int i = 0; i < granularity.length; ++i) {
                    int value = granularity[i];
                    VmfsConfigOptionGranularityItem granularityItem = new VmfsConfigOptionGranularityItem();
                    granularityItem.formattedValue = FormatUtil.getStorageFormatted((Long)Long.valueOf(value), (long)1024L, (long)0x100000L);
                    granularityItem.value = value;
                    blockSizeOption.granularityOptions[i] = granularityItem;
                }
            }
            items.add(blockSizeOption);
        }
        return items.toArray(new VmfsBlockSizeOptionItem[items.size()]);
    }

    public static class VmfsConfigOptionGranularityItem {
        public String formattedValue;
        public int value;
    }
}

