/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.storage.util;

import com.vmware.vim.binding.vim.host.BlockHba;
import com.vmware.vim.binding.vim.host.HostBusAdapter;
import com.vmware.vim.binding.vim.host.PlugStoreTopology;
import com.vmware.vim.binding.vim.host.ScsiLun;
import com.vmware.vim.binding.vim.host.TargetTransport;
import com.vmware.vsphere.client.storage.adapters.StoragePathData;

public class StoragePathDataBuilder {
    private StoragePathData _pathData = new StoragePathData();

    public StoragePathDataBuilder() {
        this._pathData.path = new PlugStoreTopology.Path();
    }

    public StoragePathDataBuilder setLunNumber(Integer lunNumber) {
        this._pathData.path.lunNumber = lunNumber;
        return this;
    }

    public StoragePathDataBuilder setChannelNumber(Integer channelNumber) {
        this._pathData.path.channelNumber = channelNumber;
        return this;
    }

    public StoragePathDataBuilder setTargetNumber(Integer targetNumber) {
        this._pathData.path.targetNumber = targetNumber;
        return this;
    }

    public StoragePathDataBuilder setHba(HostBusAdapter hba) {
        this._pathData.pathHba = hba;
        return this;
    }

    public StoragePathDataBuilder setBlockHba(String deviceName) {
        this._pathData.pathHba = new BlockHba();
        this._pathData.pathHba.device = deviceName;
        return this;
    }

    public StoragePathDataBuilder setNullPath() {
        this._pathData.path = null;
        return this;
    }

    public StoragePathDataBuilder setName(String pathName) {
        this._pathData.path.name = pathName;
        return this;
    }

    public StoragePathDataBuilder setIsWorkingPath(Boolean isWorkingPath) {
        this._pathData.isWorkingPath = isWorkingPath;
        return this;
    }

    public StoragePathDataBuilder setPathState(String pathState) {
        this._pathData.pathState = pathState;
        return this;
    }

    public StoragePathDataBuilder setPathTargetTransport(TargetTransport transport) {
        this._pathData.pathTarget = new PlugStoreTopology.Target();
        this._pathData.pathTarget.transport = transport;
        return this;
    }

    public StoragePathDataBuilder setPathLun(String canonicalName) {
        this._pathData.pathLun = new ScsiLun();
        this._pathData.pathLun.canonicalName = canonicalName;
        return this;
    }

    public StoragePathData build() {
        return this._pathData;
    }
}

