/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.vm.model;

import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.cis.data.model.Relationship;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.encryption.CryptoKeyId;
import com.vmware.vim.binding.vim.encryption.KmipClusterInfo;
import com.vmware.vim.binding.vim.vm.GuestInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.util.FormatUtil;
import com.vmware.vise.util.Pair;
import com.vmware.vsphere.client.common.model.BaseSummaryData;
import com.vmware.vsphere.client.common.model.ResourceIconData;
import com.vmware.vsphere.client.modules.api.util.ModulesApiUtil;
import com.vmware.vsphere.client.vm.tools.util.VmToolsUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@QueryBinding(value="VirtualMachine")
public final class VmSummaryData
extends BaseSummaryData
implements ResourceIconData {
    private static final Log _logger = LogFactory.getLog(VmSummaryData.class);
    private static final String WINDOWS_GUEST = "windowsGuest";
    private static final String LINUX_GUEST = "linuxGuest";
    private static final String WINDOWS_ICON = "vm-ui-icon-guestOsWindows";
    private static final String LINUX_ICON = "vm-ui-icon-guestOsLinux";
    @Property(value="VirtualMachine/name")
    public String name;
    @Property(value="VirtualMachine/guest/hostName")
    private String dnsNameInternal;
    @Property(value="VirtualMachine/vmIpAddressList")
    private String[] ipAddressesInternal;
    @Property(value="VirtualMachine/runtime/powerState")
    public VirtualMachine.PowerState powerState;
    @Property(value="VirtualMachine/guest/guestFullName")
    private String guestFullNameFromGuestInfo;
    @Property(value="VirtualMachine/config/guestFullName")
    private String guestFullNameFromConfigInfo;
    @Property(value="VirtualMachine/config/flags/vbsEnabled")
    private boolean vbsEnabledFromConfigInfo;
    @Property(value="VirtualMachine/effectiveGuestOsFamily")
    public String guestOsFamilyKey;
    @Property(value="VirtualMachine/config/version")
    private String hwVersion;
    @Relationship(value={"VirtualMachine/runtime/host"})
    @Property(value="VirtualMachine/name")
    private String hostName;
    @Property(value="VirtualMachine/toolsRunningStatus")
    private String toolsRunningStatus;
    @Property(value="VirtualMachine/detailedToolsVersionStatus")
    private String detailedToolsVersionStatus;
    @Property(value="VirtualMachine/toolsVersionStatus")
    private String toolsVersionStatus;
    @Property(value="VirtualMachine/guest/toolsVersion")
    private String toolsVersion;
    @Property(value="VirtualMachine/guest/toolsInstallType")
    private String toolsInstallType;
    @Property(value="VirtualMachine/summary/quickStats/guestMemoryUsage")
    public long memoryUsageMb;
    @Property(value="VirtualMachine/summary/quickStats/overallCpuUsage")
    public int cpuUsageMhz;
    @Property(value="VirtualMachine/summary/storage/committed")
    public long storageUsageB;
    @Property(value="VirtualMachine/config/template")
    public boolean isTemplate;
    @Property(value="VirtualMachine/runtime/dasVmProtection/dasProtected")
    public boolean dasProtected;
    @Property(value="VirtualMachine/runtime/faultToleranceState")
    public VirtualMachine.FaultToleranceState faultToleranceState;
    @Property(value="VirtualMachine/vmEvcEnabled")
    public boolean vmEvcEnabled;
    @Property(value="VirtualMachine/config/keyId")
    public CryptoKeyId cryptoKeyId;
    @Property(value="VirtualMachine/encryptionProviderManagementType")
    public String encryptionProviderManagementType;
    @Property(value="VirtualMachine/runtime/connectionState")
    private VirtualMachine.ConnectionState connectionState;
    @Property(value="VirtualMachine/runtime/cryptoState")
    private String cryptoState;
    @Property(value="VirtualMachine/vsanFaultDomainName")
    private String vsanFaultDomain;
    @Property(value="VirtualMachine/checkedOutFromVmTemplate")
    private Map<String, ManagedObjectReference> checkedOutFromVmTemplate;
    @Property(value="VirtualMachine/managedByLibrary")
    private Map<String, Object> managedByLibrary;
    @Property(value="VirtualMachine/isClusterVM")
    public boolean isClusterVM;
    private VmToolsUtil toolsUtil = new VmToolsUtil();

    private String[] getIpAddress() {
        if (this.ipAddressesInternal == null || this.ipAddressesInternal.length == 0 || this.ipAddressesInternal[0] == null) {
            return new String[0];
        }
        return this.ipAddressesInternal;
    }

    private String getDnsName() {
        if (this.dnsNameInternal == null || this.dnsNameInternal.length() == 0) {
            return "";
        }
        return this.dnsNameInternal;
    }

    private String getGuestFullName() {
        StringBuilder guestFullName = new StringBuilder();
        if (this.guestFullNameFromGuestInfo != null && this.guestFullNameFromGuestInfo.length() > 0) {
            guestFullName.append(this.guestFullNameFromGuestInfo);
        } else {
            guestFullName.append(this.guestFullNameFromConfigInfo);
        }
        if (this.vbsEnabledFromConfigInfo) {
            guestFullName.append(String.format(" - VBS %s", this.vbsEnabledFromConfigInfo));
        }
        return guestFullName.toString();
    }

    private String getHwVersion() {
        if (this.hwVersion == null) {
            return "";
        }
        return ModulesApiUtil.getString("VmHardware.HWVersion.long." + this.hwVersion);
    }

    @Override
    public BaseSummaryData.LabelValue[] getSummaryItems() {
        ArrayList<BaseSummaryData.LabelValue> summaryItems = new ArrayList<BaseSummaryData.LabelValue>();
        summaryItems.add(new BaseSummaryData.LabelValue("summaryView.guestFullName", this.getGuestFullName()));
        summaryItems.add(new BaseSummaryData.LabelValue("summaryView.vmVersion", this.getHwVersion()));
        summaryItems.add(new BaseSummaryData.LabelValue("summaryView.tools", this.getToolsInfo()));
        summaryItems.add(new BaseSummaryData.LabelValue("summaryView.encryption", this.getEncryptionInfo()));
        summaryItems.add(new BaseSummaryData.LabelValue("summaryView.dnsNameLabel", this.getDnsName()));
        summaryItems.add(new BaseSummaryData.LabelValue("summaryView.ipAddressLabel", this.getIpAddress()));
        summaryItems.add(new BaseSummaryData.LabelValue("summaryView.hostLabel", this.hostName));
        if (StringUtils.isNotEmpty((CharSequence)this.vsanFaultDomain)) {
            BaseSummaryData.LabelValue faultDomainItem = new BaseSummaryData.LabelValue("summaryView.faultDomain", this.vsanFaultDomain);
            summaryItems.add(faultDomainItem);
        }
        if (!this.isTemplate && this.checkedOutFromVmTemplate != null) {
            String templateName = this.checkedOutFromVmTemplate.keySet().iterator().next();
            ManagedObjectReference templateRef = this.checkedOutFromVmTemplate.get(templateName);
            summaryItems.add(new BaseSummaryData.LabelValue("summaryView.checkedOutFromVmTemplate", new Pair((Object)templateName, (Object)templateRef)));
        }
        if (this.isTemplate && this.managedByLibrary != null) {
            String libraryName = (String)this.managedByLibrary.get("libraryName");
            HashMap<String, Object> routeArgs = new HashMap<String, Object>();
            routeArgs.put("objectId", this.managedByLibrary.get("libraryUri"));
            routeArgs.put("lvSelectedItemId", this.managedByLibrary.get("libraryItemUri"));
            routeArgs.put("extensionId", "vsphere.core.library.relatedTemplatesPerTypeTab");
            summaryItems.add(new BaseSummaryData.LabelValue("summaryView.managedByLibrary", new Pair((Object)libraryName, routeArgs)));
        }
        return summaryItems.toArray(new BaseSummaryData.LabelValue[0]);
    }

    private Pair<String, BaseSummaryData.LabelValue[]> getToolsInfo() {
        ArrayList<BaseSummaryData.LabelValue> additionalInfo = new ArrayList<BaseSummaryData.LabelValue>();
        String toolsStateLabel = this.formatToolsStateLabel(this.toolsVersionStatus);
        String toolsStateInfo = this.getToolsStateInfo(this.toolsVersionStatus);
        String separator = StringUtils.isEmpty((CharSequence)toolsStateLabel) || StringUtils.isEmpty((CharSequence)toolsStateInfo) ? "" : "</br>";
        String versionStatusLabel = String.format("%s%s%s", toolsStateLabel, separator, toolsStateInfo);
        if (this.showInToolsPanel()) {
            additionalInfo.add(new BaseSummaryData.LabelValue("summaryView.tools.runningStatusLabel", ModulesApiUtil.getString(this.toolsRunningStatus + ".text")));
            additionalInfo.add(new BaseSummaryData.LabelValue("summaryView.tools.versionLabel", this.toolsVersion + " " + this.getXyzVersion()));
            additionalInfo.add(new BaseSummaryData.LabelValue("summaryView.tools.versionStatusLabel", versionStatusLabel));
            String installType = StringUtils.isNotEmpty((CharSequence)this.toolsInstallType) ? ModulesApiUtil.getString("guestToolsInstallType." + this.toolsInstallType) : ModulesApiUtil.getString("guestToolsNA");
            additionalInfo.add(new BaseSummaryData.LabelValue("summaryView.tools.installTypeLabel", installType));
        } else {
            additionalInfo.add(new BaseSummaryData.LabelValue("summaryView.tools.versionStatusLabel", versionStatusLabel));
        }
        return new Pair((Object)this.toolsUtil.getVersionStatus(this.toolsRunningStatus, this.detailedToolsVersionStatus), (Object)additionalInfo.toArray(new BaseSummaryData.LabelValue[additionalInfo.size()]));
    }

    private Pair<String, String> getEncryptionInfo() {
        if (!this.isCryptoKeyEmpty(this.cryptoKeyId)) {
            if (KmipClusterInfo.KmsManagementType.trustAuthority.toString().equals(this.encryptionProviderManagementType)) {
                return new Pair((Object)String.format("summaryView.encryption.%s", this.encryptionProviderManagementType), (Object)"vm-ui-icon-vmEncryptedWithTrustedKey");
            }
            if (this.encryptionProviderManagementType != null) {
                return new Pair((Object)String.format("summaryView.encryption.%s", this.encryptionProviderManagementType), (Object)"vm-ui-icon-vmEncrypted");
            }
            return new Pair((Object)String.format("summaryView.encryption.encrypted", new Object[0]), (Object)"vm-ui-icon-vmEncrypted");
        }
        return new Pair((Object)"summaryView.encryption.none", (Object)"");
    }

    private String getXyzVersion() {
        try {
            String ver = this.toolsVersion;
            int n = Integer.parseInt(ver);
            String retVal = VmSummaryData.formatXyzVersion(n);
            return retVal;
        }
        catch (Exception e) {
            _logger.debug((Object)("Error while parsing '" + this.toolsVersion + "'"), (Throwable)e);
            return "";
        }
    }

    private static String formatXyzVersion(int version) {
        if (version == -1 || version == Integer.MAX_VALUE || version <= 0) {
            return "";
        }
        int major = version / 1024;
        int minor = version % 1024 / 32;
        int base = version % 1024 % 32;
        String format = "(%1$d.%2$d.%3$d)";
        String retVal = String.format(format, major, minor, base);
        return retVal;
    }

    private boolean showInToolsPanel() {
        if (StringUtils.isEmpty((CharSequence)this.toolsVersionStatus)) {
            return false;
        }
        return !GuestInfo.ToolsVersionStatus.guestToolsNotInstalled.toString().equals(this.toolsVersionStatus);
    }

    private String formatToolsStateLabel(String toolsStatus) {
        if (StringUtils.isEmpty((CharSequence)toolsStatus)) {
            return "";
        }
        return ModulesApiUtil.getString(toolsStatus + ".text");
    }

    private String getToolsStateInfo(String toolsStatus) {
        if (StringUtils.isEmpty((CharSequence)toolsStatus)) {
            return "";
        }
        return ModulesApiUtil.getString(toolsStatus + ".info");
    }

    private boolean isCryptoKeyEmpty(CryptoKeyId key) {
        return key == null || key.keyId == null || key.keyId.isEmpty();
    }

    @Override
    public ResourceIconData.ResourceIcon[] getResourceIcons() {
        String storageUsed = FormatUtil.getStorageFormatted((Long)this.storageUsageB, (long)1L, (long)-1L);
        String cpuUsed = FormatUtil.getFrequencyFormatted((Number)this.cpuUsageMhz, (int)2, (long)1000000L, (long)-1L, (boolean)true);
        String memoryUsed = FormatUtil.getStorageFormatted((Long)this.memoryUsageMb, (long)0x100000L, (long)-1L);
        if (this.isTemplate) {
            return new ResourceIconData.ResourceIcon[]{new ResourceIconData.ResourceIcon("summary.storageUsage", storageUsed, "vsphere-icon-storage-summary")};
        }
        return new ResourceIconData.ResourceIcon[]{new ResourceIconData.ResourceIcon("summary.cpuUsage", cpuUsed, "vsphere-icon-cpu-summary"), new ResourceIconData.ResourceIcon("summary.memoryUsage", memoryUsed, "vsphere-icon-memory-summary"), new ResourceIconData.ResourceIcon("summary.storageUsage", storageUsed, "vsphere-icon-storage-summary")};
    }

    public BaseSummaryData.Badge[] getBadges() {
        String pState;
        ArrayList<BaseSummaryData.Badge> result = new ArrayList<BaseSummaryData.Badge>();
        if (WINDOWS_GUEST.equals(this.guestOsFamilyKey)) {
            result.add(new BaseSummaryData.Badge(WINDOWS_ICON, "VmOptionsView.General.GosFamily.Windows", false));
        } else if (LINUX_GUEST.equals(this.guestOsFamilyKey)) {
            result.add(new BaseSummaryData.Badge(LINUX_ICON, "VmOptionsView.General.GosFamily.Linux", false));
        }
        if (this.vmEvcEnabled) {
            result.add(new BaseSummaryData.Badge("icon-vSphere-evcEnabled24", "vmEvc.view.evcEnabledLabel", false));
        }
        String ftState = this.faultToleranceState != null ? this.faultToleranceState.toString() : "";
        String string = pState = this.powerState != null ? this.powerState.toString() : "";
        if ((ftState.equals("running") || ftState.equals("enabled")) && pState.equals("poweredOn")) {
            result.add(new BaseSummaryData.Badge("icon-vSphere-ftEnabled", "summaryView.badge.ft", false));
        }
        if (this.dasProtected) {
            result.add(new BaseSummaryData.Badge("icon-vSphere-highAvailability24", "summaryView.badge.ha", false));
        }
        if (!this.isCryptoKeyEmpty(this.cryptoKeyId)) {
            if (KmipClusterInfo.KmsManagementType.trustAuthority.toString().equals(this.encryptionProviderManagementType)) {
                result.add(new BaseSummaryData.Badge("vm-ui-icon-vmEncryptedWithTrustedKey", "VmCryptConfig.vmHomeEncryptedWithTrustedProvider", false));
            } else {
                result.add(new BaseSummaryData.Badge("vm-ui-icon-vmEncrypted", "VmCryptConfig.vmHomeEncrypted", false));
            }
        }
        return result.toArray(new BaseSummaryData.Badge[result.size()]);
    }

    public String getGuestOSIconClass() {
        if (WINDOWS_GUEST.equals(this.guestOsFamilyKey)) {
            return WINDOWS_ICON;
        }
        if (LINUX_GUEST.equals(this.guestOsFamilyKey)) {
            return LINUX_ICON;
        }
        return "";
    }

    public boolean getIsVmLocked() {
        return VirtualMachine.ConnectionState.invalid.equals((Object)this.connectionState) && VirtualMachine.CryptoState.locked.name().equals(this.cryptoState);
    }

    public boolean getIsCheckedOut() {
        return !this.isTemplate && this.checkedOutFromVmTemplate != null;
    }
}

