/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.hostprofile.data.h5.remediate.util;

import com.vmware.vim.binding.vmodl.LocalizableMessage;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.fault.SystemError;
import com.vmware.vise.data.common.DynamicObject;
import com.vmware.vise.data.common.NameValuePair;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.hostprofile.data.ExecuteResultWrapper;
import com.vmware.vsphere.client.hostprofile.data.HostApplyConfigData;
import com.vmware.vsphere.client.hostprofile.data.HostRequirements;
import com.vmware.vsphere.client.hostprofile.data.RemediateHostConfigData;
import com.vmware.vsphere.client.hostprofile.data.RemediationSpec;
import com.vmware.vsphere.client.hostprofile.data.h5.HostCustomizationSetting;
import com.vmware.vsphere.client.hostprofile.data.h5.remediate.tree.RemediateNode;
import com.vmware.vsphere.client.hostprofile.data.h5.remediate.util.RemediateConstants;
import com.vmware.vsphere.client.hostprofile.data.h5.remediate.util.RemediateItem;
import com.vmware.vsphere.client.hostprofile.data.h5.remediate.util.RemediateItemBuilder;
import com.vmware.vsphere.client.modules.api.util.ModulesApiUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PrecheckRemediateHelper {
    public List<RemediateNode> createNodeTree(RemediateHostConfigData preCheckValidationResults) {
        ArrayList<RemediateNode> nodes = new ArrayList<RemediateNode>();
        RemediateItemBuilder builder = new RemediateItemBuilder();
        RemediateNode parentRemediateNode = this.getParentNodeByStatus(preCheckValidationResults);
        nodes.add(parentRemediateNode);
        nodes.addAll(builder.getChildren(parentRemediateNode.getId(), preCheckValidationResults));
        return nodes;
    }

    public RemediationSpec getRemediationSpec(ManagedObjectReference associatedProfile, ArrayList<HostCustomizationSetting> hostCustomizations, RemediateHostConfigData preCheckValidationResults, ManagedObjectReference hostRef) {
        RemediationSpec spec = new RemediationSpec();
        spec.profileReference = associatedProfile;
        spec.hostsExecutionResults = this.getExecutionResultsAsMap(hostRef, preCheckValidationResults);
        spec.hostRequirements = this.getHostRequierments(preCheckValidationResults, hostRef);
        spec.rebootHosts = true;
        spec.deferredHostSettings = this.getDefferedHostSettings(hostCustomizations);
        return spec;
    }

    public RemediateItem createRemediateItem(String key, String descriptionIcon) {
        return new RemediateItem(ModulesApiUtil.getString(key), descriptionIcon);
    }

    public RemediateItem getRemediateDetails(RemediateHostConfigData preCheckValidationResults) {
        RemediateConstants.State state = this.getRemediateState(preCheckValidationResults);
        Map<RemediateConstants.State, RemediateItem> remediateStateMap = this.createRemediateStateMap();
        RemediateItem remediateItem = remediateStateMap.get((Object)state);
        return remediateItem;
    }

    public String getRemediateStatus(RemediateHostConfigData preCheckValidationResults) {
        HostApplyConfigData hostApplyConfigData = preCheckValidationResults.hostApplyConfigData;
        String remediateStatus = "";
        if (hostApplyConfigData != null && hostApplyConfigData.executeResultWrapper != null) {
            ExecuteResultWrapper executeResultWrapper = (ExecuteResultWrapper)hostApplyConfigData.executeResultWrapper;
            remediateStatus = executeResultWrapper.getExecuteResult().getStatus();
        }
        return remediateStatus;
    }

    public String[] getErrors(RemediateHostConfigData preCheckValidationResults) {
        ArrayList<String> errors = new ArrayList<String>();
        HostApplyConfigData hostApplyConfigData = preCheckValidationResults.hostApplyConfigData;
        if (hostApplyConfigData != null && hostApplyConfigData.error != null) {
            LocalizableMessage[] localizedFaultMessages;
            errors.add(hostApplyConfigData.error.getLocalizedMessage());
            if (hostApplyConfigData.error.getCause() instanceof SystemError && (localizedFaultMessages = ((SystemError)hostApplyConfigData.error.getCause()).getFaultMessage()) != null) {
                LocalizableMessage[] localizableMessageArray = localizedFaultMessages;
                int n = localizableMessageArray.length;
                for (int i = 0; i < n; ++i) {
                    LocalizableMessage message = localizableMessageArray[i];
                    errors.add(message.getMessage());
                }
            }
        }
        if (hostApplyConfigData != null && hostApplyConfigData.executeResultErrors != null) {
            for (String error : hostApplyConfigData.executeResultErrors) {
                errors.add(error);
            }
        }
        return errors.toArray(new String[0]);
    }

    public String[] getTasks(RemediateHostConfigData preCheckValidationResults) {
        HostApplyConfigData hostApplyConfigData = preCheckValidationResults.hostApplyConfigData;
        return hostApplyConfigData != null ? hostApplyConfigData.remediationTasks : new String[]{};
    }

    public List<RemediateNode> createChildren(int parentId, String[] messages) {
        ArrayList<RemediateNode> children = new ArrayList<RemediateNode>();
        int childId = parentId + 1;
        for (String message : messages) {
            RemediateNode tempRemediateNode = new RemediateNode(parentId, childId++);
            tempRemediateNode.setDescription(message);
            children.add(tempRemediateNode);
        }
        return children;
    }

    private boolean doesHostNeedToBeRebooted(RemediateHostConfigData preCheckValidationResults) {
        HostApplyConfigData hostApplyConfigData = preCheckValidationResults.hostApplyConfigData;
        boolean result = false;
        if (hostApplyConfigData != null && hostApplyConfigData.remediationRequirements != null) {
            for (String requirement : hostApplyConfigData.remediationRequirements) {
                if (!requirement.equals("rebootRequired")) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    private boolean isPutInMaintenanceModeRequired(RemediateHostConfigData preCheckValidationResults) {
        HostApplyConfigData hostApplyConfigData = preCheckValidationResults.hostApplyConfigData;
        boolean result = false;
        if (hostApplyConfigData != null && hostApplyConfigData.remediationRequirements != null) {
            for (String requirement : hostApplyConfigData.remediationRequirements) {
                if (!requirement.equals("maintenanceModeRequired")) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    private boolean doesHostNeedToBeEnteredInMaintenanceMode(RemediateHostConfigData preCheckValidationResults) {
        HostApplyConfigData hostApplyConfigData = preCheckValidationResults.hostApplyConfigData;
        boolean result = false;
        boolean inMaintenanceMode = preCheckValidationResults.inMaintenanceMode;
        boolean isHostInClusterFullyAutomatedDrs = this.isHostInClusterWithFullyAutomatedDrs(preCheckValidationResults);
        if (hostApplyConfigData != null && hostApplyConfigData.remediationRequirements != null && !isHostInClusterFullyAutomatedDrs && !inMaintenanceMode) {
            for (String requirement : hostApplyConfigData.remediationRequirements) {
                if (!requirement.equals("maintenanceModeRequired") && !requirement.equals("rebootRequired")) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    private RemediateConstants.State getRemediateState(RemediateHostConfigData preCheckValidationResults) {
        boolean doesHostNeedToEnterInMm = this.doesHostNeedToBeEnteredInMaintenanceMode(preCheckValidationResults);
        boolean doesHostNeedToBeRebooted = this.doesHostNeedToBeRebooted(preCheckValidationResults);
        boolean hostInMaintenanceMode = preCheckValidationResults.inMaintenanceMode;
        boolean isHostInClusterWithFullyAutomatedDrs = this.isHostInClusterWithFullyAutomatedDrs(preCheckValidationResults);
        if (preCheckValidationResults.hostApplyConfigData == null) {
            return RemediateConstants.State.HOST_CAN_NOT_BE_REMEDIATED_THERE_IS_NO_DATA;
        }
        if (preCheckValidationResults.hostApplyConfigData.error != null) {
            return RemediateConstants.State.HOST_CAN_NOT_BE_REMEDIATED_THERE_IS_ERROR;
        }
        if (doesHostNeedToEnterInMm) {
            if (doesHostNeedToBeRebooted) {
                return RemediateConstants.State.HOST_CAN_NOT_BE_REMEDIATED_MM_AND_REBOOT_REQUIRED;
            }
            return RemediateConstants.State.HOST_CAN_NOT_BE_REMEDIATED_REQUIRES_MM;
        }
        if (doesHostNeedToBeRebooted) {
            if (isHostInClusterWithFullyAutomatedDrs && !hostInMaintenanceMode) {
                return RemediateConstants.State.HOST_WILL_BE_PUT_IN_MM_AND_REQUIRES_REBOOT;
            }
            return RemediateConstants.State.HOST_REQUIRES_REBOOT;
        }
        if (isHostInClusterWithFullyAutomatedDrs && !hostInMaintenanceMode && this.isPutInMaintenanceModeRequired(preCheckValidationResults)) {
            return RemediateConstants.State.HOST_WILL_BE_PUT_IN_MM;
        }
        return RemediateConstants.State.HOST_CAN_BE_REMEDIATED;
    }

    private Map<RemediateConstants.State, RemediateItem> createRemediateStateMap() {
        HashMap<RemediateConstants.State, RemediateItem> remediateStateMap = new HashMap<RemediateConstants.State, RemediateItem>();
        remediateStateMap.put(RemediateConstants.State.HOST_CAN_NOT_BE_REMEDIATED_MM_AND_REBOOT_REQUIRED, this.createRemediateItem("remediateHostWizard.readyToCompletePage.hostRequriesRebootAndMM", "vx-icon-error"));
        remediateStateMap.put(RemediateConstants.State.HOST_CAN_NOT_BE_REMEDIATED_REQUIRES_MM, this.createRemediateItem("remediateHostWizard.readyToCompletePage.hostRequriesMM", "vx-icon-error"));
        remediateStateMap.put(RemediateConstants.State.HOST_WILL_BE_PUT_IN_MM_AND_REQUIRES_REBOOT, this.createRemediateItem("hostInDrsClusterRequriesRebootAndMM", "vx-icon-error"));
        remediateStateMap.put(RemediateConstants.State.HOST_REQUIRES_REBOOT, this.createRemediateItem("remediateHostWizard.readyToCompletePage.hostHasRebootRequirment", "vx-icon-warn"));
        remediateStateMap.put(RemediateConstants.State.HOST_WILL_BE_PUT_IN_MM, this.createRemediateItem("remediateHostWizard.readyToCompletePage.hostInDrsClusterMM", "vx-icon-warn"));
        remediateStateMap.put(RemediateConstants.State.HOST_CAN_BE_REMEDIATED, this.createRemediateItem("remediateHostWizard.readyToCompletePage.hostWithoutRequirmets", "vx-icon-compliant"));
        remediateStateMap.put(RemediateConstants.State.HOST_CAN_NOT_BE_REMEDIATED_THERE_IS_NO_DATA, this.createRemediateItem("remediateHostWizard.readyToCompletePage.errorNoData", "vx-icon-error"));
        remediateStateMap.put(RemediateConstants.State.HOST_CAN_NOT_BE_REMEDIATED_THERE_IS_ERROR, this.createRemediateItem("remediateHostWizard.readyToCompletePage.error", "vx-icon-error"));
        return remediateStateMap;
    }

    private boolean isHostInClusterWithFullyAutomatedDrs(RemediateHostConfigData preCheckValidationResults) {
        boolean fullyAutomated = false;
        if (preCheckValidationResults.defaultDrsBehavior != null && preCheckValidationResults.clusterDrsEnabled != null) {
            boolean clusterDrsEnabled = preCheckValidationResults.clusterDrsEnabled;
            boolean fullyAutomatedDrsCluster = "fullyAutomated".equals(preCheckValidationResults.defaultDrsBehavior.name());
            if (clusterDrsEnabled && fullyAutomatedDrsCluster) {
                fullyAutomated = true;
            }
        }
        return fullyAutomated;
    }

    private DynamicObject[] getDefferedHostSettings(ArrayList<HostCustomizationSetting> hostCustomizations) {
        DynamicObject[] defferedSetttings = new DynamicObject[hostCustomizations.size()];
        int index = 0;
        for (HostCustomizationSetting setting : hostCustomizations) {
            DynamicObject tempDynamicObject = new DynamicObject();
            tempDynamicObject.properties = this.getHostCustomizationsAsNameValue(setting);
            defferedSetttings[index++] = tempDynamicObject;
        }
        return defferedSetttings;
    }

    private NameValuePair[] getHostCustomizationsAsNameValue(HostCustomizationSetting hostCustomizationSetting) {
        ArrayList<NameValuePair> hostCustomizationsArray = new ArrayList<NameValuePair>();
        hostCustomizationsArray.add(new NameValuePair("name", (Object)hostCustomizationSetting.name));
        hostCustomizationsArray.add(new NameValuePair("value", (Object)hostCustomizationSetting.value));
        hostCustomizationsArray.add(new NameValuePair("valueType", (Object)hostCustomizationSetting.valueType));
        hostCustomizationsArray.add(new NameValuePair("hostName", (Object)hostCustomizationSetting.hostName));
        hostCustomizationsArray.add(new NameValuePair("description", (Object)hostCustomizationSetting.description));
        hostCustomizationsArray.add(new NameValuePair("requiredValue", (Object)hostCustomizationSetting.requiredValue));
        hostCustomizationsArray.add(new NameValuePair("isRequired", (Object)hostCustomizationSetting.isRequired));
        hostCustomizationsArray.add(new NameValuePair("inputPath", (Object)hostCustomizationSetting.inputPath));
        hostCustomizationsArray.add(new NameValuePair("parameter", (Object)hostCustomizationSetting.parameter));
        return hostCustomizationsArray.toArray(new NameValuePair[0]);
    }

    private HostRequirements[] getHostRequierments(RemediateHostConfigData preCheckValidationResults, ManagedObjectReference hostRef) {
        HostApplyConfigData hostApplyConfigData = preCheckValidationResults.hostApplyConfigData;
        if (hostApplyConfigData != null && hostApplyConfigData.remediationRequirements != null && hostRef != null) {
            String[] remediationRequirements = hostApplyConfigData.remediationRequirements;
            HostRequirements[] hostRequirements = new HostRequirements[1];
            HostRequirements requirement = new HostRequirements();
            requirement.hostRef = hostRef;
            requirement.remediationRequirements = remediationRequirements;
            hostRequirements[0] = requirement;
            return hostRequirements;
        }
        return null;
    }

    private Map<String, ExecuteResultWrapper> getExecutionResultsAsMap(ManagedObjectReference hostRef, RemediateHostConfigData preCheckValidationResults) {
        HashMap<String, ExecuteResultWrapper> executionMap = new HashMap<String, ExecuteResultWrapper>();
        String hostReferenceAsString = ManagedObjectUtil.morefToString((ManagedObjectReference)hostRef);
        HostApplyConfigData hostApplyConfigData = preCheckValidationResults.hostApplyConfigData;
        if (preCheckValidationResults != null && hostApplyConfigData != null && hostApplyConfigData.executeResultWrapper != null) {
            executionMap.put(hostReferenceAsString, (ExecuteResultWrapper)hostApplyConfigData.executeResultWrapper);
        }
        return executionMap;
    }

    private RemediateNode getParentNodeByStatus(RemediateHostConfigData remediateHostConfigData) {
        RemediateNode parentNode = new RemediateNode(null, 0);
        parentNode.setHostIcon(remediateHostConfigData.hostPrimaryIconId);
        parentNode.setHostName(remediateHostConfigData.hostName);
        RemediateItem remediateDetails = this.getRemediateDetails(remediateHostConfigData);
        parentNode.setDescription(remediateDetails.getDescription());
        parentNode.setDescriptionIcon(remediateDetails.getDescriptionIcon());
        return parentNode;
    }
}

