/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.hostprofile.util;

import com.vmware.vim.binding.vim.profile.ApplyProfile;
import com.vmware.vsphere.client.hostprofile.util.PreProcessUtil;
import java.util.LinkedList;
import org.apache.commons.lang3.StringUtils;

public final class ProfilePathStack {
    private static final String DELIMETER = ".";
    private LinkedList<Path> _list = new LinkedList();

    private ProfilePathStack() {
    }

    static ProfilePathStack getInstance() {
        return new ProfilePathStack();
    }

    public ProfilePathStack pushArray(ApplyProfile profile, String fieldName) {
        return this.pushInternal(profile, fieldName, TYPE.ARRAY);
    }

    public ProfilePathStack pushProperty(ApplyProfile profile, String fieldName) {
        return this.pushInternal(profile, fieldName, TYPE.PROPERTY);
    }

    public ProfilePathStack pushProfile(ApplyProfile profile, String fieldName) {
        return this.pushInternal(profile, fieldName, TYPE.PROFILE);
    }

    private ProfilePathStack pushInternal(ApplyProfile profile, String fieldName, TYPE type2) {
        if (type2 == null) {
            throw new IllegalArgumentException("type is null");
        }
        assert (this._list != null);
        this._list.push(new Path(profile, fieldName, type2));
        return this;
    }

    public ApplyProfile peek() {
        assert (this._list != null);
        Path path = this._list.peek();
        if (path != null) {
            return path._profile;
        }
        return null;
    }

    public void pop() {
        assert (this._list != null);
        this._list.pop();
    }

    public String getPath() {
        assert (this._list != null);
        StringBuilder builder = new StringBuilder();
        for (int i = this._list.size() - 1; i >= 0; --i) {
            builder.append(this._list.get(i).build());
            if (i <= 0) continue;
            builder.append(DELIMETER);
        }
        return builder.toString();
    }

    private class Path {
        private ApplyProfile _profile;
        private String _fieldName;
        private TYPE _type;

        private Path(ApplyProfile profile, String fieldName, TYPE type2) {
            this._profile = profile;
            this._fieldName = fieldName;
            this._type = type2;
        }

        public String toString() {
            return String.format("%s : %s", this._fieldName, this._profile.getProfileTypeName());
        }

        private String build() {
            switch (this._type) {
                case PROFILE: {
                    return this._fieldName;
                }
                case ARRAY: {
                    return this.buildArray();
                }
                case PROPERTY: {
                    return this.buildProperty();
                }
            }
            assert (false);
            return "";
        }

        private String buildArray() {
            String key = PreProcessUtil.getStringPropertyValue(this._profile, "key");
            if (StringUtils.isEmpty((CharSequence)key)) {
                return this._fieldName;
            }
            return String.format("%s[\"%s\"]", this._fieldName, key);
        }

        private String buildProperty() {
            String key = PreProcessUtil.getStringPropertyValue(this._profile, "key");
            if (StringUtils.isEmpty((CharSequence)key)) {
                return this._profile.profileTypeName;
            }
            return String.format("%s[\"%s\"]", this._profile.profileTypeName, key);
        }
    }

    private static enum TYPE {
        PROFILE,
        ARRAY,
        PROPERTY;

    }
}

