/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.eam.impl;

import com.vmware.eam.util.EamConnection;
import com.vmware.eam.util.EamUtil;
import com.vmware.vim.binding.eam.EsxAgentManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.ResultUtil;
import com.vmware.vsphere.client.common.data.DataProviderAdapterBase;
import com.vmware.vsphere.client.vcextension.common.SearchUtil;
import com.vmware.vsphere.client.vcextension.common.VcExtensionConnection;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@type(value="eam:Agency")
public class AgencyEchoService
extends DataProviderAdapterBase {
    private static final Log _logger = LogFactory.getLog(AgencyEchoService.class);
    private static final String TYPE_AGENCY = "eam:Agency";

    protected ResultSet processQuery(ObjectIdentityConstraint constraint, QuerySpec query) {
        if (!TYPE_AGENCY.equals(constraint.targetType)) {
            return ResultUtil.newEmptyResultSet();
        }
        if (!(constraint.target instanceof ManagedObjectReference)) {
            _logger.error((Object)"Object identity constraint with target type 'eam:Agency' must contain a target object of type ManagedObjectReference");
            return ResultUtil.newEmptyResultSet();
        }
        ManagedObjectReference agencyRef = (ManagedObjectReference)constraint.target;
        assert (StringUtils.isNotEmpty((CharSequence)agencyRef.getServerGuid()));
        try {
            if (this.agencyExists(agencyRef)) {
                ResultSet result = SearchUtil.createResultSet((int)1);
                if (!SearchUtil.isObjectCountQuery((QuerySpec)query)) {
                    result.items = new ResultItem[]{new ResultItem()};
                    result.items[0].resourceObject = agencyRef;
                }
                return result;
            }
            return ResultUtil.newEmptyResultSet();
        }
        catch (Exception eamException) {
            _logger.error((Object)"Exception occured while communicating with the ESX Agent Manager", (Throwable)eamException);
            String message = EamUtil.getLocalizedString("error.unableToContactEam", new String[0]);
            return ResultUtil.newErrorResultSet((Exception[])new Exception[]{new Exception(message, eamException)});
        }
    }

    protected ResultSet processQuery(CompositeConstraint constraint, QuerySpec query) {
        if (constraint.conjoiner != Conjoiner.OR && constraint.nestedConstraints.length > 1) {
            return ResultUtil.newEmptyResultSet();
        }
        return super.getUnionOfSubConstraintResults(constraint, query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean agencyExists(ManagedObjectReference agencyRef) throws Exception {
        EamConnection eamConnection = null;
        try {
            ManagedObjectReference[] agencies;
            eamConnection = EamConnection.newInstance(agencyRef.getServerGuid());
            EsxAgentManager eam = eamConnection.getEsxAgentManager();
            for (ManagedObjectReference eamAgencyRef : agencies = eam.queryAgency()) {
                if (!eamAgencyRef.getValue().equals(agencyRef.getValue())) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            EamConnection.tryClose((VcExtensionConnection)eamConnection);
        }
    }
}

