/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vcextension.impl;

import com.vmware.vim.binding.vim.Extension;
import com.vmware.vim.binding.vim.Folder;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.QueryUtil;
import com.vmware.vise.data.query.util.ResultUtil;
import com.vmware.vise.data.uri.resolve.DefaultUriSchemeUtil;
import com.vmware.vise.vim.GlobalObjectUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.common.data.DataProviderAdapterBase;
import com.vmware.vsphere.client.vcextension.common.ExtensionUriSpec;
import com.vmware.vsphere.client.vcextension.common.SearchUtil;
import com.vmware.vsphere.client.vcextension.common.VcExtensionManagerProxy;
import com.vmware.vsphere.client.vcextension.util.VcExtensionUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@type(value="VcExtension")
public class VcExtensionSearchProvider
extends DataProviderAdapterBase {
    private static final Log _logger = LogFactory.getLog(VcExtensionSearchProvider.class);
    private static final String EXTENSION_RELATIONSHIP = "extends";
    private static final String TYPE_FOLDER = "Folder";
    private final DataService _dataService;
    private final VcExtensionManagerProxy _extensionManager;

    public VcExtensionSearchProvider(DataService dataService, VcExtensionManagerProxy extensionManagerProxy) {
        this._dataService = dataService;
        this._extensionManager = extensionManagerProxy;
    }

    protected ResultSet processQuery(ObjectIdentityConstraint constraint, QuerySpec parentQuery) throws Exception {
        if (!constraint.target.getClass().equals(URI.class)) {
            return ResultUtil.newEmptyResultSet();
        }
        URI uri = (URI)constraint.target;
        if (!this.isVcExtensionURI(uri)) {
            return ResultUtil.newEmptyResultSet();
        }
        try {
            ExtensionUriSpec extensionUri = new ExtensionUriSpec(uri);
            Extension extension = VcExtensionUtil.getExtension(extensionUri, this._extensionManager);
            if (extension == null) {
                return ResultUtil.newEmptyResultSet();
            }
            ResultItem echo = new ResultItem();
            echo.resourceObject = uri;
            if (!ArrayUtils.isEmpty((Object[])parentQuery.resourceSpec.propertySpecs)) {
                Set requestedProperties = SearchUtil.propertySet((PropertySpec[])parentQuery.resourceSpec.propertySpecs);
                ArrayList<PropertyValue> createdProperties = new ArrayList<PropertyValue>();
                List<PropertyValue> intrinsicProperties = VcExtensionSearchProvider.getExtensionInstrinsicProperties(extension, requestedProperties);
                createdProperties.addAll(intrinsicProperties);
                SearchUtil.setResource(createdProperties, (Object)extensionUri.getUri());
                echo.properties = createdProperties.toArray(new PropertyValue[createdProperties.size()]);
            }
            ResultSet result = new ResultSet();
            result.items = new ResultItem[]{echo};
            return result;
        }
        catch (Exception ex) {
            _logger.debug((Object)("Object targeted by identity constraint no longer exists: " + uri));
            return ResultUtil.newEmptyResultSet();
        }
    }

    protected ResultSet processQuery(RelationalConstraint constraint, QuerySpec query) throws Exception {
        Set<PropertyConstraint> propertyConstraints = Collections.emptySet();
        return this.processRelationalConstraintQuery(constraint, query, propertyConstraints);
    }

    protected ResultSet processQuery(CompositeConstraint constraint, QuerySpec parentQuery) throws Exception {
        if (constraint.conjoiner == Conjoiner.OR) {
            return super.getUnionOfSubConstraintResults(constraint, parentQuery);
        }
        if (constraint.conjoiner == Conjoiner.AND) {
            Map<Class<? extends Constraint>, List<Constraint>> constraintsByType = this.splitConstraintsByType(constraint);
            for (Class<? extends Constraint> constraintType : constraintsByType.keySet()) {
                if (constraintType.equals(RelationalConstraint.class) || constraintType.equals(PropertyConstraint.class) || constraintType.equals(CompositeConstraint.class)) continue;
                _logger.warn((Object)("Unhandled nested constraint in AND composite: " + constraintType.getCanonicalName()));
                return ResultUtil.newEmptyResultSet();
            }
            if (!constraintsByType.containsKey(RelationalConstraint.class) || constraintsByType.get(RelationalConstraint.class) == null || constraintsByType.get(RelationalConstraint.class).size() != 1) {
                _logger.warn((Object)"Unhandled composite: Must contain exactly one relational constraint.");
                return ResultUtil.newEmptyResultSet();
            }
            RelationalConstraint relatedObjectConstraint = (RelationalConstraint)constraintsByType.get(RelationalConstraint.class).get(0);
            Set propertyConstraints = SearchUtil.getSubConstraints((Constraint)constraint, PropertyConstraint.class, (String)"VcExtension", (Conjoiner)Conjoiner.OR, (boolean)true);
            return this.processRelationalConstraintQuery(relatedObjectConstraint, parentQuery, propertyConstraints);
        }
        _logger.warn((Object)("Unhandled composite constraint conjoiner " + constraint.conjoiner));
        return ResultUtil.newEmptyResultSet();
    }

    private ResultSet processRelationalConstraintQuery(RelationalConstraint constraint, QuerySpec query, Set<PropertyConstraint> propertyConstraints) throws Exception {
        if (!EXTENSION_RELATIONSHIP.equals(constraint.relation) || !"VcExtension".equals(constraint.targetType)) {
            return ResultUtil.newEmptyResultSet();
        }
        Constraint relatedObject = constraint.constraintOnRelatedObject;
        if (relatedObject == null) {
            _logger.warn((Object)"Unsupported query: Missing constraint on related object.");
            return ResultUtil.newEmptyResultSet();
        }
        if (relatedObject instanceof PropertyConstraint) {
            if (!this.isRootFolderConstraint((PropertyConstraint)relatedObject)) {
                _logger.warn((Object)"Unsupported query: Related object not a root folder.");
                return ResultUtil.newEmptyResultSet();
            }
            return this.getAllExtensions(query.resultSpec, SearchUtil.propertySet((QuerySpec)query), propertyConstraints);
        }
        if (relatedObject instanceof ObjectIdentityConstraint) {
            ObjectIdentityConstraint oic = (ObjectIdentityConstraint)relatedObject;
            if (GlobalObjectUtil.getVSphereClientInstance().equals(oic.target)) {
                return this.getAllExtensions(query.resultSpec, SearchUtil.propertySet((QuerySpec)query), propertyConstraints);
            }
            return this.getExtensionsForServer(oic, query.resultSpec, SearchUtil.propertySet((PropertySpec[])query.resourceSpec.propertySpecs), propertyConstraints);
        }
        return ResultUtil.newEmptyResultSet();
    }

    private Map<Class<? extends Constraint>, List<Constraint>> splitConstraintsByType(CompositeConstraint composite) {
        Validate.notNull((Object)composite);
        HashMap<Class<? extends Constraint>, List<Constraint>> result = new HashMap<Class<? extends Constraint>, List<Constraint>>();
        for (Constraint constraint : composite.nestedConstraints) {
            Class<?> constraintType = constraint.getClass();
            if (!result.containsKey(constraintType)) {
                result.put(constraintType, new ArrayList());
            }
            ((List)result.get(constraintType)).add(constraint);
        }
        return result;
    }

    private ResultSet getExtensionsForServer(ObjectIdentityConstraint vcConstraint, ResultSpec resultSpec, Set<String> properties, Set<PropertyConstraint> propertyConstraints) {
        assert (vcConstraint != null && resultSpec != null && properties != null);
        if (!(vcConstraint.target instanceof ManagedObjectReference)) {
            return ResultUtil.newEmptyResultSet();
        }
        ManagedObjectReference moRef = (ManagedObjectReference)vcConstraint.target;
        if (!ManagedObjectUtil.isOfType((ManagedObjectReference)moRef, Folder.class)) {
            _logger.error((Object)("The type '" + vcConstraint.targetType + "' can only have the relationship '" + EXTENSION_RELATIONSHIP + "' to entities of type '" + Folder.class.getName() + "'"));
            return ResultUtil.newEmptyResultSet();
        }
        ResultBuilder resultBuilder = new ResultBuilder(resultSpec, properties, propertyConstraints);
        resultBuilder.extensionsByServerGuid = this._extensionManager.getAllExtensionsForServers(new HashSet<String>(Arrays.asList(moRef.getServerGuid())));
        if (!SearchUtil.isObjectCountQuery((ResultSpec)resultSpec) && properties.contains("vCenterName") && !resultBuilder.extensionsByServerGuid.isEmpty()) {
            String[] vcProperties = this.getVcProperties(properties);
            QuerySpec query = QueryUtil.buildQuerySpec((Constraint)vcConstraint, (String[])vcProperties);
            try {
                ResultSet resultSet = QueryUtil.getData((DataService)this._dataService, (QuerySpec)query);
                resultBuilder.vcPropertiesByServerGuid = this.createManagedObjectPropertySets(resultSet);
            }
            catch (Exception queryException) {
                _logger.error((Object)"Exception trying to retrieve all vCenter Servers", (Throwable)queryException);
            }
        }
        return resultBuilder.build();
    }

    private ResultSet getAllExtensions(ResultSpec resultSpec, Set<String> propertySet, Set<PropertyConstraint> propertyConstraints) {
        ResultSet resultSet;
        PropertyConstraint vcServerConstraint = QueryUtil.createPropertyConstraint((String)TYPE_FOLDER, (String)"isRootFolder", (Comparator)Comparator.EQUALS, (Object)Boolean.TRUE);
        String[] vcProperties = new String[]{};
        if (!SearchUtil.isObjectCountQuery((ResultSpec)resultSpec) || propertyConstraints.isEmpty()) {
            vcProperties = this.getVcProperties(propertySet);
        }
        QuerySpec query = QueryUtil.buildQuerySpec((Constraint)vcServerConstraint, (String[])vcProperties);
        try {
            resultSet = QueryUtil.getData((DataService)this._dataService, (QuerySpec)query);
        }
        catch (Exception queryException) {
            _logger.error((Object)"Exception trying to retrieve all vCenter Servers", (Throwable)queryException);
            return ResultUtil.newErrorResultSet((Exception[])new Exception[]{queryException});
        }
        ResultBuilder resultBuilder = new ResultBuilder(resultSpec, propertySet, propertyConstraints);
        assert (resultSet != null);
        resultBuilder.vcPropertiesByServerGuid = this.createManagedObjectPropertySets(resultSet);
        Set<String> serverGuids = resultBuilder.vcPropertiesByServerGuid.keySet();
        resultBuilder.extensionsByServerGuid = this._extensionManager.getAllExtensionsForServers(serverGuids);
        return resultBuilder.build();
    }

    private static List<PropertyValue> getExtensionInstrinsicProperties(Extension extension, Set<String> properties) {
        PropertyValue property;
        if (properties.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<PropertyValue> result = new ArrayList<PropertyValue>();
        if (properties.contains("name")) {
            property = ResultUtil.newProperty((String)"name", (Object)extension.description.label);
            result.add(property);
        }
        if (properties.contains("vendor")) {
            property = ResultUtil.newProperty((String)"vendor", (Object)extension.company);
            result.add(property);
        }
        if (properties.contains("version")) {
            property = ResultUtil.newProperty((String)"version", (Object)extension.version);
            result.add(property);
        }
        return result;
    }

    private String[] getVcProperties(Set<String> propertySet) {
        ArrayList<String> builder = new ArrayList<String>();
        if (propertySet.contains("vCenterName")) {
            builder.add("vCenterName");
        }
        return builder.toArray(new String[builder.size()]);
    }

    private Map<String, ManagedObjectPropertySet> createManagedObjectPropertySets(ResultSet resultSet) {
        if (resultSet == null || ArrayUtils.isEmpty((Object[])resultSet.items)) {
            return Collections.emptyMap();
        }
        HashMap<String, ManagedObjectPropertySet> result = new HashMap<String, ManagedObjectPropertySet>(resultSet.totalMatchedObjectCount);
        for (ResultItem resultItem : resultSet.items) {
            Map<String, Object> properties;
            assert (resultItem.resourceObject instanceof ManagedObjectReference);
            ManagedObjectReference moRef = (ManagedObjectReference)resultItem.resourceObject;
            if (ArrayUtils.isEmpty((Object[])resultItem.properties)) {
                properties = Collections.emptyMap();
            } else {
                properties = new HashMap();
                for (PropertyValue property : resultItem.properties) {
                    if (!StringUtils.isNotEmpty((CharSequence)property.propertyName)) continue;
                    properties.put(property.propertyName, property.value);
                }
            }
            ManagedObjectPropertySet propertySet = new ManagedObjectPropertySet(moRef, properties);
            result.put(moRef.getServerGuid(), propertySet);
        }
        return result;
    }

    private boolean isRootFolderConstraint(PropertyConstraint constraint) {
        return constraint != null && TYPE_FOLDER.equals(constraint.targetType) && "isRootFolder".equals(constraint.propertyName) && constraint.comparableValue instanceof String && Boolean.TRUE.equals(Boolean.parseBoolean((String)constraint.comparableValue));
    }

    private boolean isVcExtensionURI(URI uri) {
        if (!uri.toString().startsWith("urn:vri:")) {
            _logger.debug((Object)("URI does not use the expected 'urn:vri' scheme: " + uri.toString()));
            return false;
        }
        String targetType = DefaultUriSchemeUtil.getType((URI)uri);
        if (!"VcExtension".equals(targetType)) {
            _logger.warn((Object)("URI identifies an unsupported resource type: " + targetType));
            return false;
        }
        return true;
    }

    private static class ResultBuilder {
        final ResultSpec resultSpec;
        final Set<String> requestedProperties;
        Map<String, ManagedObjectPropertySet> vcPropertiesByServerGuid = Collections.emptyMap();
        Map<String, List<Extension>> extensionsByServerGuid = Collections.emptyMap();
        final Map<String, List<PropertyConstraint>> propertyConstraintsByTargetType;

        ResultBuilder(ResultSpec resultSpec, Set<String> requestedProperties, Set<PropertyConstraint> propertyConstraints) {
            assert (resultSpec != null && requestedProperties != null && propertyConstraints != null);
            this.resultSpec = resultSpec;
            this.requestedProperties = requestedProperties;
            this.propertyConstraintsByTargetType = this.splitPropertyConstraintByTargetType(propertyConstraints);
        }

        Map<String, List<PropertyConstraint>> splitPropertyConstraintByTargetType(Set<PropertyConstraint> propertyConstraints) {
            assert (propertyConstraints != null);
            if (propertyConstraints.isEmpty()) {
                return Collections.emptyMap();
            }
            HashMap<String, List<PropertyConstraint>> result = new HashMap<String, List<PropertyConstraint>>();
            for (PropertyConstraint constraint : propertyConstraints) {
                if (!result.containsKey(constraint.targetType)) {
                    result.put(constraint.targetType, new ArrayList());
                }
                ((List)result.get(constraint.targetType)).add(constraint);
            }
            return result;
        }

        ResultSet build() {
            int extensionCount = 0;
            ArrayList<ResultItem> resultItems = new ArrayList<ResultItem>();
            for (Map.Entry<String, List<Extension>> serverExtensions : this.extensionsByServerGuid.entrySet()) {
                Collection solutionManagerExtensions = serverExtensions.getValue().stream().filter(ext -> ext != null && ext.getShownInSolutionManager() != false).collect(Collectors.toSet());
                if (SearchUtil.isObjectCountQuery((ResultSpec)this.resultSpec) && this.propertyConstraintsByTargetType.isEmpty()) {
                    extensionCount += solutionManagerExtensions.size();
                    continue;
                }
                String serverGuid = serverExtensions.getKey();
                for (Extension extension : solutionManagerExtensions) {
                    ArrayList<PropertyValue> extensionProperties;
                    List<PropertyValue> vcProperties = this.getVcProperties(serverGuid);
                    ArrayList<PropertyValue> filterableExtensionProperties = extensionProperties = new ArrayList<PropertyValue>();
                    extensionProperties.addAll(VcExtensionSearchProvider.getExtensionInstrinsicProperties(extension, this.requestedProperties));
                    if (!this.propertiesMeetConstraints(vcProperties, filterableExtensionProperties)) continue;
                    ++extensionCount;
                    if (SearchUtil.isObjectCountQuery((ResultSpec)this.resultSpec)) continue;
                    ResultItem resultItem = new ResultItem();
                    URI extensionUri = ExtensionUriSpec.toDataServiceUri((String)extension.getKey(), (String)serverGuid);
                    resultItem.resourceObject = extensionUri;
                    Collection properties = CollectionUtils.union(vcProperties, extensionProperties);
                    SearchUtil.setResource((Collection)properties, (Object)extensionUri);
                    resultItem.properties = properties.toArray(new PropertyValue[properties.size()]);
                    resultItems.add(resultItem);
                }
            }
            ResultSet resultSet = SearchUtil.createResultSet((int)extensionCount);
            if (!SearchUtil.isObjectCountQuery((ResultSpec)this.resultSpec)) {
                resultSet.items = resultItems.toArray(new ResultItem[resultItems.size()]);
                ResultUtil.sortResult((ResultSet)resultSet, (ResultSpec)this.resultSpec);
            }
            return resultSet;
        }

        private boolean propertiesMeetConstraints(List<PropertyValue> vcProperties, List<PropertyValue> filterableExtensionProperties) {
            if (this.propertyConstraintsByTargetType.isEmpty()) {
                return true;
            }
            if (this.propertyConstraintsByTargetType.containsKey(VcExtensionSearchProvider.TYPE_FOLDER) && !SearchUtil.meetsAnyConstraint(vcProperties, (Collection)this.propertyConstraintsByTargetType.get(VcExtensionSearchProvider.TYPE_FOLDER))) {
                return false;
            }
            return !this.propertyConstraintsByTargetType.containsKey("VcExtension") || SearchUtil.meetsAnyConstraint(filterableExtensionProperties, (Collection)this.propertyConstraintsByTargetType.get("VcExtension"));
        }

        List<PropertyValue> getVcProperties(String serverGuid) {
            if (!this.vcPropertiesByServerGuid.containsKey(serverGuid) || CollectionUtils.isEmpty(this.requestedProperties)) {
                return Collections.emptyList();
            }
            ArrayList<PropertyValue> result = new ArrayList<PropertyValue>();
            for (Map.Entry<String, Object> property : this.vcPropertiesByServerGuid.get((Object)serverGuid).properties.entrySet()) {
                if (!this.requestedProperties.contains(property.getKey())) continue;
                PropertyValue newProperty = ResultUtil.newProperty((String)property.getKey(), (Object)property.getValue());
                result.add(newProperty);
            }
            if (this.requestedProperties.contains("vCenterRef")) {
                PropertyValue vcRef = ResultUtil.newProperty((String)"vCenterRef", (Object)this.vcPropertiesByServerGuid.get((Object)serverGuid).object);
                result.add(vcRef);
            }
            return result;
        }
    }

    private static class ManagedObjectPropertySet {
        final ManagedObjectReference object;
        final Map<String, Object> properties;

        public ManagedObjectPropertySet(ManagedObjectReference object, Map<String, Object> properties) {
            assert (object != null && properties != null) : "null constructor argument";
            this.object = object;
            this.properties = properties;
        }
    }
}

