/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vcextension.impl;

import com.vmware.vim.binding.vim.Extension;
import com.vmware.vim.binding.vim.ExtensionManager;
import com.vmware.vim.binding.vim.ext.SolutionManagerInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.QueryUtil;
import com.vmware.vise.extensionfw.ExtensionService;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.commons.vcservice.VcServiceConnectionInfo;
import com.vmware.vsphere.client.vcextension.ServerVmInfo;
import com.vmware.vsphere.client.vcextension.VcExtensionDetailsData;
import com.vmware.vsphere.client.vcextension.VcExtensionSummaryData;
import com.vmware.vsphere.client.vcextension.api.H5NamedMoRef;
import com.vmware.vsphere.client.vcextension.api.H5VcExtensionSummaryData;
import com.vmware.vsphere.client.vcextension.common.ExtensionUriSpec;
import com.vmware.vsphere.client.vcextension.common.NamedMoRef;
import com.vmware.vsphere.client.vcextension.common.VcExtensionManagerProxy;
import com.vmware.vsphere.client.vcextension.util.VcExtensionUtil;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VcSolutionPropertyProvider
implements PropertyProviderBean {
    private static final Log _logger = LogFactory.getLog(VcSolutionPropertyProvider.class);
    private static final String SERENITY_CLIENT_TYPE_ID = "vsphere-client-serenity";
    private final DataService _dataService;
    private final VcExtensionManagerProxy _extensionManagerProxy;
    private final ExtensionService _extensionService;

    public VcSolutionPropertyProvider(DataService dataService, VcExtensionManagerProxy extensionManagerProxy, ExtensionService extensionService) {
        this._dataService = dataService;
        this._extensionManagerProxy = extensionManagerProxy;
        this._extensionService = extensionService;
    }

    @type(value="VcExtension")
    public SolutionManagerInfo.TabInfo[] getLegacyViewsData(URI extensionUri) throws Exception {
        ExtensionUriSpec uriSpec = new ExtensionUriSpec(extensionUri);
        Extension extension = this.getExtensionInternal(uriSpec);
        Object[] tabsData = VcExtensionUtil.filterDeprecatedTabs(extension, this._extensionService);
        if (ArrayUtils.isEmpty((Object[])tabsData)) {
            return null;
        }
        String localhostAddress = VcExtensionUtil.getVcServerHostname(uriSpec.getServerGuid());
        for (Object tab : tabsData) {
            try {
                ((SolutionManagerInfo.TabInfo)tab).url = VcExtensionUtil.qualifyHostName(((SolutionManagerInfo.TabInfo)tab).url, localhostAddress);
                ((SolutionManagerInfo.TabInfo)tab).url = this.addQueryParameters(((SolutionManagerInfo.TabInfo)tab).url, uriSpec.getServerGuid());
            }
            catch (Exception e) {
                String errorMessage = VcExtensionUtil.getLocalizedString("Error.invalidExtensionUiUrl", uriSpec.getKey(), ((SolutionManagerInfo.TabInfo)tab).url);
                _logger.error((Object)errorMessage);
                throw new Exception(errorMessage, e);
            }
        }
        return tabsData;
    }

    @type(value="VcExtension")
    public VcExtensionSummaryData getVcExtensionSummary(URI extensionUri) throws Exception {
        return this.getVcExtensionSummary(extensionUri, VcExtensionSummaryData.class);
    }

    @type(value="VcExtension")
    public H5VcExtensionSummaryData getH5VcExtensionSummary(URI extensionUri) throws Exception {
        return this.getVcExtensionSummary(extensionUri, H5VcExtensionSummaryData.class);
    }

    private <T> T getVcExtensionSummary(URI extensionUri, Class<T> clazz) throws Exception {
        ExtensionUriSpec uriSpec = new ExtensionUriSpec(extensionUri);
        Extension extension = this.getExtensionInternal(extensionUri);
        ExtensionManager.ExtensionDataUsage dataUsage = VcExtensionUtil.getExtensionDataUsage(extension, uriSpec);
        ManagedObjectReference vcServerRef = VcExtensionUtil.getVcFolder(uriSpec.getServerGuid());
        PropertyValue[] propertyValues = QueryUtil.getProperty((DataService)this._dataService, (Object[])new ManagedObjectReference[]{vcServerRef}, (String)"vCenterName");
        assert (propertyValues.length == 1) : "Unexpected number of properties returned";
        assert (propertyValues[0].propertyName == "vCenterName") : "Unexpected name of returned property";
        assert (propertyValues[0].value instanceof String) : "Unexpected property type returned";
        String vcServerName = (String)propertyValues[0].value;
        if (VcExtensionSummaryData.class.equals(clazz)) {
            NamedMoRef vCenterServer = new NamedMoRef(vcServerRef, vcServerName);
            return (T)new VcExtensionSummaryData(extension, vCenterServer, dataUsage);
        }
        if (H5VcExtensionSummaryData.class.equals(clazz)) {
            H5NamedMoRef vCenterServer = new H5NamedMoRef(vcServerRef, vcServerName);
            return (T)new H5VcExtensionSummaryData(extension, vCenterServer, dataUsage);
        }
        throw new IllegalArgumentException("Unsupported class: " + clazz.getName());
    }

    @type(value="VcExtension")
    public VcExtensionDetailsData getVcExtensionDetails(URI extensionUri) throws Exception {
        Extension extension = this.getExtensionInternal(extensionUri);
        return new VcExtensionDetailsData(extension);
    }

    @type(value="VcExtension")
    public boolean getHasLegacyViews(URI extensionUri) throws Exception {
        Extension extension = this.getExtensionInternal(extensionUri);
        Object[] tabs = VcExtensionUtil.filterDeprecatedTabs(extension, this._extensionService);
        return !ArrayUtils.isEmpty((Object[])tabs);
    }

    @type(value="VcExtension")
    public String getName(URI extensionUri) throws Exception {
        Extension extension = this.getExtensionInternal(extensionUri);
        return extension.description.label;
    }

    @type(value="VcExtension")
    public boolean getHasServerVm(URI extensionUri) throws Exception {
        Extension extension = this.getExtensionInternal(extensionUri);
        return VcExtensionUtil.getServerVm(extension) != null;
    }

    @type(value="VcExtension")
    public ServerVmInfo getVcExtensionServerVm(URI extensionUri) throws Exception {
        Extension extension = this.getExtensionInternal(extensionUri);
        ManagedObjectReference vmRef = VcExtensionUtil.getServerVm(extension);
        if (vmRef == null) {
            return null;
        }
        ServerVmInfo serverVm = new ServerVmInfo();
        serverVm.vmRef = vmRef;
        serverVm.name = (String)QueryUtil.getProperty((DataService)this._dataService, (Object)serverVm.vmRef, (String)"name");
        return serverVm;
    }

    private Extension getExtensionInternal(ExtensionUriSpec uriSpec) throws Exception {
        Extension extension = VcExtensionUtil.getExtension(uriSpec, this._extensionManagerProxy);
        if (extension == null) {
            String errorMessage = VcExtensionUtil.getLocalizedString("Error.extensionNotFound", uriSpec.getKey(), VcExtensionUtil.getVcServerHostname(uriSpec.getServerGuid()));
            _logger.error((Object)errorMessage);
            throw new Exception(errorMessage);
        }
        return extension;
    }

    private Extension getExtensionInternal(URI extensionUri) throws Exception {
        ExtensionUriSpec uriSpec = new ExtensionUriSpec(extensionUri);
        return this.getExtensionInternal(uriSpec);
    }

    private String addQueryParameters(String baseUrl, String serverGuid) throws URISyntaxException {
        StringBuilder query;
        URI url = new URI(baseUrl);
        VcService vcServer = VimSessionUtil.getService((String)serverGuid);
        if (url.getQuery() != null && url.getQuery().length() > 0) {
            query = new StringBuilder(url.getQuery());
            query.append("&");
        } else {
            query = new StringBuilder();
        }
        query.append("serverGuid=" + serverGuid);
        VcServiceConnectionInfo vcInfo = vcServer.getConnectionInfo();
        String locale = vcInfo.getUserSession().locale;
        query.append("&locale=" + locale);
        String serviceUrl = vcServer.getServiceUrl();
        query.append("&serviceUrl=" + serviceUrl);
        if (url.getScheme().equals("https")) {
            String sessionId = vcInfo.getSessionCookie();
            sessionId = sessionId.replace("\"", "");
            query.append("&sessionId=" + sessionId);
        }
        String vimSessionKey = vcInfo.getUserSession().getKey();
        query.append("&vimSessionKey=" + vimSessionKey);
        query.append("&clientType=vsphere-client-serenity");
        URI result = new URI(url.getScheme(), null, url.getHost(), url.getPort(), url.getPath(), query.toString(), null);
        return result.toString();
    }
}

