/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.advperfcharts.topn;

import com.vmware.opsmgmt.client.advperfcharts.PerformanceCounter;
import com.vmware.opsmgmt.client.advperfcharts.PerformanceMetricTimeIntervals;
import com.vmware.opsmgmt.client.advperfcharts.topn.metricid.MetricIdData;
import com.vmware.opsmgmt.client.advperfcharts.util.PerformanceCounterProvider;
import com.vmware.vim.binding.vim.PerformanceManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.util.Collections;
import java.util.List;

public class GlobalPerformanceCounterProvider
implements PerformanceCounterProvider {
    private final List<PerformanceCounter> _availableCounters;
    private final MetricIdData _metricIdData;

    public GlobalPerformanceCounterProvider(List<PerformanceCounter> availableCounters, MetricIdData metricIdData) {
        this._availableCounters = availableCounters;
        this._metricIdData = metricIdData;
    }

    @Override
    public List<PerformanceManager.MetricId> getAvailableMetricIds(ManagedObjectReference entity, List<Integer> counterIds, List<String> relatedDeviceIds, PerformanceMetricTimeIntervals interval) {
        List<PerformanceManager.MetricId> queriedMetricsForObject = this._metricIdData.queriedMetricIds.get(entity);
        if (queriedMetricsForObject != null) {
            return queriedMetricsForObject;
        }
        return Collections.emptyList();
    }

    @Override
    public PerformanceCounter findCounterInfo(ManagedObjectReference entity, PerformanceManager.MetricId metricId) {
        for (PerformanceCounter counter : this._availableCounters) {
            if (counter.id != metricId.getCounterId()) continue;
            PerformanceCounter performanceCounter = new PerformanceCounter(counter);
            performanceCounter.metricId = metricId;
            performanceCounter.relatedDeviceName = this._metricIdData.nameTranslator.getInstanceName(entity, metricId);
            return performanceCounter;
        }
        return null;
    }
}

