/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.advperfcharts.util;

import com.vmware.opsmgmt.client.advperfcharts.PerformanceCounter;
import com.vmware.opsmgmt.client.advperfcharts.data.PerfCounterGroupsData;
import com.vmware.opsmgmt.client.advperfcharts.data.StorageSystemDataModel;
import com.vmware.opsmgmt.client.advperfcharts.util.Constants;
import com.vmware.vim.binding.vim.host.FileSystemMountInfo;
import com.vmware.vim.binding.vim.host.PlugStoreTopology;
import com.vmware.vim.binding.vim.host.ScsiLun;
import com.vmware.vim.binding.vim.host.VmfsVolume;
import com.vmware.vim.binding.vim.host.VvolVolume;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang3.StringUtils;

class InstanceNameTranslator {
    private static final String GROUP_KEY_DATASTORE = "datastore";
    private static final String GROUP_KEY_DISK = "disk";
    private static final String GROUP_KEY_STORAGE_PATH = "storagePath";
    private static final String STORAGE_PATH_FORMAT = "%S:C%S:T%S:L%S";
    private final PerfCounterGroupsData _countersData;

    InstanceNameTranslator(PerfCounterGroupsData countersData) {
        Validate.notNull((Object)countersData);
        this._countersData = countersData;
    }

    String getInstanceName(PerformanceCounter counter) {
        String result = counter.relatedDeviceId;
        if ("".equals(counter.relatedDeviceId)) {
            result = this._countersData.getName();
        } else if (Constants.TYPE_HOST.equals(this._countersData.getObject().getType()) || Constants.TYPE_VM.equals(this._countersData.getObject().getType())) {
            if (counter.groupId.equals(GROUP_KEY_DISK)) {
                result = this.getLUNName(counter.relatedDeviceId);
            } else if (counter.groupId.equals(GROUP_KEY_STORAGE_PATH)) {
                result = this.getStoragePathName(counter.relatedDeviceId);
            } else if (counter.groupId.equals(GROUP_KEY_DATASTORE)) {
                result = this.getVolumeName(counter.relatedDeviceId);
            }
        }
        if (StringUtils.isEmpty((CharSequence)result)) {
            result = counter.relatedDeviceId;
        }
        return result;
    }

    private String getVolumeName(String relatedDeviceId) {
        FileSystemMountInfo[] fileSystemMountInfoArr;
        StorageSystemDataModel model = this._countersData.getStorageSystem();
        if (model != null && (fileSystemMountInfoArr = model.fileSystemMountInfo) != null) {
            for (FileSystemMountInfo fsmi : fileSystemMountInfoArr) {
                String relativePath;
                if (fsmi.volume == null) continue;
                if (fsmi.volume instanceof VmfsVolume) {
                    VmfsVolume volume = (VmfsVolume)fsmi.volume;
                    if (!relatedDeviceId.contains(volume.getUuid())) continue;
                    return volume.getName();
                }
                if (fsmi.volume instanceof VvolVolume) {
                    VvolVolume vvolVolume = (VvolVolume)fsmi.volume;
                    if (!vvolVolume.scId.replace("-", "").contains(relatedDeviceId.replace("-", ""))) continue;
                    return vvolVolume.name;
                }
                String fullPath = fsmi.mountInfo.path;
                int pathSepIndex = fullPath.lastIndexOf(47);
                if (pathSepIndex <= -1 || !relatedDeviceId.contains(relativePath = fullPath.substring(pathSepIndex + 1))) continue;
                return fsmi.volume.name;
            }
        }
        return relatedDeviceId;
    }

    private String getStoragePathName(String relatedDeviceId) {
        PlugStoreTopology.Path[] storageDeviceInfoToplologyPath;
        StorageSystemDataModel model = this._countersData.getStorageSystem();
        if (model != null && (storageDeviceInfoToplologyPath = model.plugStoreTopologyPath) != null) {
            for (PlugStoreTopology.Path path : storageDeviceInfoToplologyPath) {
                if (!relatedDeviceId.equals(path.name)) continue;
                return String.format(STORAGE_PATH_FORMAT, path.adapter, path.channelNumber, path.targetNumber, path.lunNumber);
            }
        }
        return relatedDeviceId;
    }

    private String getLUNName(String relatedDeviceId) {
        ScsiLun[] storageDeviceInfoScsiLun;
        StorageSystemDataModel model = this._countersData.getStorageSystem();
        if (model != null && (storageDeviceInfoScsiLun = model.scsiLun) != null) {
            for (ScsiLun lun : storageDeviceInfoScsiLun) {
                if (!relatedDeviceId.equals(lun.canonicalName)) continue;
                return lun.displayName;
            }
        }
        return null;
    }
}

