/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.advperfcharts.util;

import com.vmware.opsmgmt.client.advperfcharts.PerformanceCounter;
import com.vmware.opsmgmt.client.advperfcharts.PerformanceMetricTimeIntervals;
import com.vmware.opsmgmt.client.advperfcharts.data.PerfCounterGroupsData;
import com.vmware.opsmgmt.client.advperfcharts.util.PerformanceCounterCache;
import com.vmware.opsmgmt.client.advperfcharts.util.PerformanceCounterUtil;
import com.vmware.opsmgmt.client.advperfcharts.util.comparator.PerformanceCountersComparator;
import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.Datacenter;
import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.DistributedVirtualSwitch;
import com.vmware.vim.binding.vim.Folder;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.PerformanceManager;
import com.vmware.vim.binding.vim.ResourcePool;
import com.vmware.vim.binding.vim.StoragePod;
import com.vmware.vim.binding.vim.VirtualApp;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;

public class PerformanceCounterCollector {
    private final PerformanceManager _perfManager;
    private final PerfCounterGroupsData _countersData;
    private final PerformanceCounterCache _perfCounterCache;

    public PerformanceCounterCollector(PerfCounterGroupsData countersData, PerformanceManager perfManager, PerformanceCounterCache performanceCounterCache) {
        this._perfManager = perfManager;
        this._countersData = countersData;
        this._perfCounterCache = performanceCounterCache;
    }

    public List<PerformanceCounter> getAvailableCountersSorted() {
        ManagedObjectReference moRef = this._countersData.getObject();
        PerformanceManager.ProviderSummary summary = PerformanceCounterCollector.getProviderSummary(moRef);
        List<PerformanceCounter> result = this.getCountersForTimeInterval(moRef, summary, this._countersData);
        Collections.sort(result, new PerformanceCountersComparator());
        return result;
    }

    private List<PerformanceCounter> getCountersForTimeInterval(ManagedObjectReference entity, PerformanceManager.ProviderSummary summary, PerfCounterGroupsData countersData) {
        PerformanceManager.MetricId[] realtimeMetricIds = null;
        if (summary.currentSupported) {
            realtimeMetricIds = this._perfManager.queryAvailableMetric(entity, null, null, summary.refreshRate);
        }
        realtimeMetricIds = (PerformanceManager.MetricId[])ArrayUtils.nullToEmpty(realtimeMetricIds, PerformanceManager.MetricId[].class);
        PerformanceManager.MetricId[] historicalMetricIds = null;
        if (summary.summarySupported) {
            historicalMetricIds = this._perfManager.queryAvailableMetric(entity, null, null, null);
        }
        historicalMetricIds = (PerformanceManager.MetricId[])ArrayUtils.nullToEmpty(historicalMetricIds, PerformanceManager.MetricId[].class);
        if (realtimeMetricIds.length == 0 && historicalMetricIds.length == 0) {
            return Collections.emptyList();
        }
        Map<Integer, PerformanceManager.CounterInfo> counterInfosById = this._perfCounterCache.getCounterInfoMapForMetrics(realtimeMetricIds, historicalMetricIds, this._perfManager);
        List<PerformanceCounter> realtimeCounters = PerformanceCounterUtil.createCounters(realtimeMetricIds, counterInfosById, PerformanceMetricTimeIntervals.REALTIME, countersData);
        List<PerformanceCounter> historicalCounters = PerformanceCounterUtil.createCounters(historicalMetricIds, counterInfosById, PerformanceMetricTimeIntervals.HISTORICAL_STATS, countersData);
        realtimeCounters.addAll(historicalCounters);
        return realtimeCounters;
    }

    static PerformanceManager.ProviderSummary getProviderSummary(ManagedObjectReference moRef) {
        PerformanceManager.ProviderSummary summary = new PerformanceManager.ProviderSummary();
        summary.setEntity(moRef);
        String type2 = moRef.getType();
        if (ClusterComputeResource.class.getSimpleName().equals(type2) || ResourcePool.class.getSimpleName().equals(type2) || Datastore.class.getSimpleName().equals(type2) || Folder.class.getSimpleName().equals(type2) || Datacenter.class.getSimpleName().equals(type2) || VirtualApp.class.getSimpleName().equals(type2) || StoragePod.class.getSimpleName().equals(type2)) {
            summary.setSummarySupported(true);
            summary.setCurrentSupported(false);
            summary.setRefreshRate(Integer.valueOf(-1));
        } else if (VirtualMachine.class.getSimpleName().equals(type2) || HostSystem.class.getSimpleName().equals(type2)) {
            summary.setSummarySupported(true);
            summary.setCurrentSupported(true);
            summary.setRefreshRate(Integer.valueOf(20));
        } else if (DistributedVirtualSwitch.class.getSimpleName().equals(type2)) {
            summary.setSummarySupported(false);
            summary.setCurrentSupported(true);
            summary.setRefreshRate(Integer.valueOf(20));
        } else {
            throw new IllegalArgumentException("Not yet hardcoded summary for type " + type2);
        }
        return summary;
    }
}

