/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.advperfcharts.util;

import com.vmware.opsmgmt.client.advperfcharts.PerformanceCounterStats;
import com.vmware.opsmgmt.client.advperfcharts.PerformanceInfoQuerySpec;
import com.vmware.opsmgmt.client.advperfcharts.util.BasePerformanceStats;
import com.vmware.opsmgmt.client.advperfcharts.util.PerformanceCounterProvider;
import com.vmware.vim.binding.vim.HistoricalInterval;
import com.vmware.vim.binding.vim.PerformanceManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PerformanceStats
extends BasePerformanceStats {
    private static final Log _logger = LogFactory.getLog(PerformanceStats.class);

    public PerformanceStats(List<ManagedObjectReference> moRefs, PerformanceInfoQuerySpec params, PerformanceManager performanceManager, HistoricalInterval[] historicalIntervals, PerformanceCounterProvider counterProvider) {
        super(moRefs, params, performanceManager, historicalIntervals, counterProvider);
    }

    @Override
    protected Map<ManagedObjectReference, PerformanceManager.QuerySpec> prepareQuerySpec() {
        HashMap<ManagedObjectReference, PerformanceManager.QuerySpec> querySpecs = new HashMap<ManagedObjectReference, PerformanceManager.QuerySpec>(this.moRefs.size());
        for (ManagedObjectReference moRef : this.moRefs) {
            ArrayList<PerformanceManager.MetricId> metricIds = new ArrayList<PerformanceManager.MetricId>();
            if (this.hasMetricIdsItems()) {
                metricIds.addAll(Arrays.asList(this.originalParams.metricIds));
            }
            List<PerformanceManager.MetricId> requiredMetrics = this.counterProvider.getAvailableMetricIds(moRef, this.originalParams.counterIds, this.originalParams.relatedDeviceIds, this.originalParams.interval);
            metricIds.addAll(requiredMetrics);
            PerformanceManager.QuerySpec querySpec = this.initBaseQuerySpec(moRef);
            querySpec.metricId = metricIds.toArray(new PerformanceManager.MetricId[0]);
            querySpecs.put(moRef, querySpec);
        }
        return querySpecs;
    }

    @Override
    protected List<PerformanceCounterStats> executeQuery(Map<ManagedObjectReference, PerformanceManager.QuerySpec> querySpecs) {
        ArrayList<PerformanceManager.QuerySpec> nonEmptySpecs = new ArrayList<PerformanceManager.QuerySpec>(querySpecs.size());
        for (PerformanceManager.QuerySpec querySpec : querySpecs.values()) {
            if (querySpec.metricId.length == 0) continue;
            nonEmptySpecs.add(querySpec);
        }
        if (nonEmptySpecs.isEmpty()) {
            return Collections.emptyList();
        }
        _logger.debug((Object)("Calling PerfomanceManager.queryStats(" + nonEmptySpecs + ")"));
        PerformanceManager.EntityMetricBase[] entityMetricBaseArr = this.perfManager.queryStats(nonEmptySpecs.toArray(new PerformanceManager.QuerySpec[0]));
        if (entityMetricBaseArr == null) {
            return Collections.emptyList();
        }
        return this.processResults(entityMetricBaseArr);
    }

    private List<PerformanceCounterStats> processResults(PerformanceManager.EntityMetricBase[] entityMetricBaseArr) {
        ArrayList<PerformanceCounterStats> result = new ArrayList<PerformanceCounterStats>(entityMetricBaseArr.length);
        for (PerformanceManager.EntityMetricBase entityMetricBase : entityMetricBaseArr) {
            PerformanceManager.MetricSeries[] metricSeries = null;
            if (entityMetricBase instanceof PerformanceManager.EntityMetric) {
                metricSeries = ((PerformanceManager.EntityMetric)entityMetricBase).getValue();
            } else if (entityMetricBase instanceof PerformanceManager.EntityMetricCSV) {
                metricSeries = ((PerformanceManager.EntityMetricCSV)entityMetricBase).getValue();
            }
            if (metricSeries == null) continue;
            Date[] samples = PerformanceStats.extractSamples(entityMetricBase);
            this.addValuesToResult(metricSeries, entityMetricBase.entity, samples, result);
        }
        return result;
    }
}

