/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.h5.sdk.plugin.migration;

import java.util.regex.Pattern;

public enum ExtensionType {
    GLOBAL_VIEWS("vise.global.views", "vise\\.global\\.views"),
    NAVIGATOR("vise.navigator.nodespecs", "vise\\.navigator\\.nodespecs"),
    SHORTCUTS("vise.home.shortcuts", "vise\\.home\\.shortcuts"),
    ACTIONS("vise.actions.sets", "vise\\.actions\\.sets"),
    ACTIONS_SPECS("vise.actions.specs", "vise\\.actions\\.specs"),
    SOLUTION_MENUS("vsphere.core.menus.solutionMenus", "vsphere\\.core\\.menus\\.solutionMenus"),
    SUMMARY_VIEWS("summarySectionViews", "vsphere\\.core\\.(\\w+)\\.summarySectionViews"),
    MONITOR_VIEWS("monitorViews", "vsphere\\.core\\.(\\w+)\\.monitorViews"),
    CATEGORY_VIEWS("manageViews", "vsphere\\.core\\.(\\w+)\\.manageViews"),
    MANAGE_SETTING_VIEWS("settingsViews", "vsphere\\.core\\.(\\w+)\\.manage\\.settingsViews");

    private String extensionName;
    private Pattern pattern;

    private ExtensionType(String extensionName, String regex) {
        this.extensionName = extensionName;
        this.pattern = Pattern.compile(regex);
    }

    public boolean matches(String s) {
        return this.pattern.matcher(s).matches();
    }

    public String toString() {
        return this.extensionName;
    }
}

