/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.h5.sdk.plugin.migration.factory.impl;

import com.vmware.h5.sdk.plugin.migration.factory.ModelFactory;
import com.vmware.h5.sdk.plugin.migration.file.ResourceDefinitionManager;
import com.vmware.h5.sdk.plugin.migration.file.SpriteImageCreationException;
import com.vmware.h5.sdk.plugin.migration.model.PluginBuilderConfig;
import com.vmware.h5.sdk.plugin.migration.model.ResourceDefinition;
import com.vmware.vise.plugin.manifest.model.Definitions;
import com.vmware.vise.plugin.manifest.model.i18n.LanguageTag;
import com.vmware.vise.plugin.manifest.model.i18n.LocalizationData;
import com.vmware.vise.plugin.manifest.model.icon.CompositeIconSpriteSheet;
import com.vmware.vise.plugin.manifest.model.icon.SpriteSheetIconDefinition;
import com.vmware.vise.plugin.manifest.model.icon.ThemeOverridesIconSpriteSheet;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class DefinitionsModelFactory
implements ModelFactory<Definitions> {
    @Override
    public Definitions createModel(PluginBuilderConfig pluginBuilderConfig) {
        Definitions definitions = new Definitions();
        ResourceDefinitionManager resourceDefinitionManager = new ResourceDefinitionManager(pluginBuilderConfig.getConfiguration());
        this.setLocaleDefinitions(definitions, pluginBuilderConfig, resourceDefinitionManager);
        this.setIconDefinitions(definitions, pluginBuilderConfig, resourceDefinitionManager);
        return definitions;
    }

    private void setLocaleDefinitions(Definitions definitions, PluginBuilderConfig pluginBuilderConfig, ResourceDefinitionManager resourceDefinitionManager) {
        LocalizationData localizationData = new LocalizationData();
        HashMap<String, Map<String, String>> definitionsMap = new HashMap<String, Map<String, String>>();
        ResourceDefinition resourceDefinition = pluginBuilderConfig.getResourceDefinition();
        String resourceFolderName = resourceDefinition.getLocaleResourceFolderName();
        String resourceFileName = resourceDefinition.getBaseLocaleResourceFileName();
        if (resourceFolderName != null && resourceFileName != null) {
            Map<String, Properties> localePropertiesMap = resourceDefinitionManager.getLocalePropertiesMap(resourceFolderName, resourceFileName);
            Set<String> localeSet = localePropertiesMap.keySet();
            localizationData.changeSupportedLocales(localeSet.toArray(new String[localeSet.size()]));
            for (String key : resourceDefinition.getLocaleDefinitionPropertyKeys()) {
                HashMap<String, String> languageToValue = new HashMap<String, String>();
                for (String locale : localizationData.getSupportedLocales()) {
                    String languageTag = this.getLanguageLocaleString(locale);
                    if (languageTag == null) continue;
                    languageToValue.put(languageTag, this.getPropertyValue(key, localePropertiesMap.get(locale)));
                }
                definitionsMap.put(key, languageToValue);
            }
            localizationData.definitions = definitionsMap;
            definitions.localizationData = localizationData;
        }
    }

    private String getLanguageLocaleString(String language) {
        for (LanguageTag tag : LanguageTag.values()) {
            if (!tag.getLocaleString().equals(language)) continue;
            return tag.getLocaleString();
        }
        return null;
    }

    private void setIconDefinitions(Definitions definitions, PluginBuilderConfig pluginBuilderConfig, ResourceDefinitionManager resourceDefinitionManager) {
        HashMap<String, SpriteSheetIconDefinition> iconDefinitionMap = new HashMap<String, SpriteSheetIconDefinition>();
        CompositeIconSpriteSheet iconSpriteSheet = new CompositeIconSpriteSheet(iconDefinitionMap);
        HashMap<String, ThemeOverridesIconSpriteSheet> themeOverridesIconSpriteSheetMap = new HashMap<String, ThemeOverridesIconSpriteSheet>();
        ThemeOverridesIconSpriteSheet themeOverridesIconSpriteSheet = new ThemeOverridesIconSpriteSheet(iconDefinitionMap);
        themeOverridesIconSpriteSheetMap.put("dark", themeOverridesIconSpriteSheet);
        iconSpriteSheet.themeOverrides = themeOverridesIconSpriteSheetMap;
        ResourceDefinition resourceDefinition = pluginBuilderConfig.getResourceDefinition();
        Set<String> iconDefinitionPropertyKeys = resourceDefinition.getIconDefinitionPropertyKeys();
        if (iconDefinitionPropertyKeys.isEmpty()) {
            return;
        }
        short y = 0;
        for (String iconName : iconDefinitionPropertyKeys) {
            SpriteSheetIconDefinition spriteSheetIconDefinition = new SpriteSheetIconDefinition();
            spriteSheetIconDefinition.x = 0;
            spriteSheetIconDefinition.y = y;
            y = (short)(y + 32);
            iconDefinitionMap.put(iconName, spriteSheetIconDefinition);
        }
        iconSpriteSheet.uri = "assets/images/sprite-image-light.png";
        themeOverridesIconSpriteSheet.uri = "assets/images/sprite-image-dark.png";
        definitions.iconSpriteSheet = iconSpriteSheet;
        if (!iconDefinitionMap.isEmpty()) {
            try {
                BufferedImage spriteImageLight = resourceDefinitionManager.buildSpriteImage(iconDefinitionMap, "placeholder-light.png");
                BufferedImage spriteImageDark = resourceDefinitionManager.buildSpriteImage(iconDefinitionMap, "placeholder-dark.png");
                if (spriteImageLight != null) {
                    resourceDefinitionManager.createSpriteImage(spriteImageLight, "sprite-image-light.png");
                }
                if (spriteImageDark != null) {
                    resourceDefinitionManager.createSpriteImage(spriteImageDark, "sprite-image-dark.png");
                }
            }
            catch (SpriteImageCreationException ex) {
                System.out.println("Sprite image creation exception: " + ex.getMessage());
            }
        }
    }

    private String getPropertyValue(String propertyName, Properties properties) {
        String property = properties.getProperty(propertyName);
        return property != null ? property : "";
    }
}

