/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.h5.sdk.plugin.migration.factory.impl;

import com.vmware.h5.sdk.plugin.migration.ExtensionType;
import com.vmware.h5.sdk.plugin.migration.error.PluginManifestError;
import com.vmware.h5.sdk.plugin.migration.factory.ModelFactory;
import com.vmware.h5.sdk.plugin.migration.model.PluginBuilderConfig;
import com.vmware.h5.sdk.plugin.migration.utils.PluginMigrationUtils;
import com.vmware.h5.sdk.plugin.migration.utils.XmlUtils;
import com.vmware.vise.plugin.manifest.model.home.HomeScope;
import com.vmware.vise.plugin.manifest.model.home.HomeView;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.w3c.dom.Element;

public class HomeScopeModelFactory
implements ModelFactory<HomeScope> {
    @Override
    public HomeScope createModel(PluginBuilderConfig pluginBuilderConfig) {
        HomeScope homeScope = null;
        Map<String, List<Element>> globalViewExtensionsMap = pluginBuilderConfig.getGlobalViewExtensionsMap();
        LinkedHashMap<String, List<Element>> globalExtensions = new LinkedHashMap<String, List<Element>>(globalViewExtensionsMap);
        for (Map.Entry<String, List<Element>> entry : globalExtensions.entrySet()) {
            if (homeScope == null) {
                HomeView homeView;
                Optional<Element> optionalElement = entry.getValue().stream().filter(e -> ExtensionType.GLOBAL_VIEWS.toString().equals(XmlUtils.getChildElementNodeValue(e, "extendedPoint"))).findFirst();
                if (!optionalElement.isPresent()) continue;
                Element globalViewExtension = optionalElement.get();
                homeScope = new HomeScope();
                homeScope.view = homeView = this.createHomeView(pluginBuilderConfig, globalViewExtension);
                continue;
            }
            PluginManifestError error = PluginManifestError.GLOBAL_VIEWS_UNSUPPORTED_ERR;
            String message = String.format(error.getMessage(), ExtensionType.GLOBAL_VIEWS.toString());
            PluginMigrationUtils.addToUnsupportedExtensions(pluginBuilderConfig, ExtensionType.GLOBAL_VIEWS.toString(), message, error.getErrorCode(), entry.getValue());
        }
        return homeScope;
    }

    private HomeView createHomeView(PluginBuilderConfig pluginBuilderConfig, Element homeViewExtension) {
        HomeView homeView = null;
        if (homeViewExtension != null) {
            homeView = new HomeView();
            homeView.setNavigationId(XmlUtils.getAttributeValue(homeViewExtension, "id"));
            homeView.setNavigationVisible(true);
            Element objElement = XmlUtils.getLastChildElementNode(homeViewExtension, "object");
            homeView.setUri(PluginMigrationUtils.getUri(pluginBuilderConfig.getManifest(), objElement));
        }
        return homeView;
    }
}

