/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.h5.sdk.plugin.migration.factory.impl;

import com.vmware.h5.sdk.plugin.migration.ExtensionType;
import com.vmware.h5.sdk.plugin.migration.factory.ModelFactory;
import com.vmware.h5.sdk.plugin.migration.model.PluginBuilderConfig;
import com.vmware.h5.sdk.plugin.migration.utils.PluginMigrationUtils;
import com.vmware.h5.sdk.plugin.migration.utils.XmlUtils;
import com.vmware.vise.plugin.manifest.model.PluginConfig;
import com.vmware.vise.plugin.manifest.model.icon.SpriteSheetIconReference;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.w3c.dom.Element;

public class PluginConfigModelFactory
implements ModelFactory<PluginConfig> {
    @Override
    public PluginConfig createModel(PluginBuilderConfig pluginBuilderConfig) {
        PluginConfig pluginConfig = null;
        Map<String, List<Element>> globalViewExtensionsMap = pluginBuilderConfig.getGlobalViewExtensionsMap();
        LinkedHashMap<String, List<Element>> globalExtensions = new LinkedHashMap<String, List<Element>>(globalViewExtensionsMap);
        pluginConfig = this.createPluginConfigurationFromNavigatorExtension(globalExtensions, pluginBuilderConfig);
        if (pluginConfig == null) {
            pluginConfig = this.createPluginConfigurationFromGlobalExtension(globalExtensions, pluginBuilderConfig);
        }
        return pluginConfig != null ? pluginConfig : this.createDefaultPluginConfig(pluginBuilderConfig);
    }

    private PluginConfig createDefaultPluginConfig(PluginBuilderConfig pluginBuilderConfig) {
        PluginConfig pluginConfig = new PluginConfig();
        pluginConfig.changeNameKey(pluginBuilderConfig.getPluginId());
        return pluginConfig;
    }

    private PluginConfig createPluginConfigurationFromNavigatorExtension(LinkedHashMap<String, List<Element>> globalExtensions, PluginBuilderConfig pluginBuilderConfig) {
        for (Map.Entry<String, List<Element>> entry : globalExtensions.entrySet()) {
            Optional<Element> optionalElement = entry.getValue().stream().filter(e -> ExtensionType.NAVIGATOR.toString().equals(XmlUtils.getChildElementNodeValue(e, "extendedPoint"))).findFirst();
            if (!optionalElement.isPresent()) continue;
            Element navigatorExtension = optionalElement.get();
            return this.createPluginConfiguration(pluginBuilderConfig, navigatorExtension, "title");
        }
        return null;
    }

    private PluginConfig createPluginConfigurationFromGlobalExtension(LinkedHashMap<String, List<Element>> globalExtensions, PluginBuilderConfig pluginBuilderConfig) {
        for (Map.Entry<String, List<Element>> entry : globalExtensions.entrySet()) {
            Optional<Element> optionalElement = entry.getValue().stream().filter(e -> ExtensionType.GLOBAL_VIEWS.toString().equals(XmlUtils.getChildElementNodeValue(e, "extendedPoint"))).findFirst();
            Element globalViewExtension = optionalElement.get();
            if (globalViewExtension == null) continue;
            return this.createPluginConfiguration(pluginBuilderConfig, globalViewExtension, "title");
        }
        return null;
    }

    private PluginConfig createPluginConfiguration(PluginBuilderConfig pluginBuilderConfig, Element extension, String nameKey) {
        PluginConfig pluginConfig = new PluginConfig();
        String title = XmlUtils.getLastChildElementNodeValue(extension, "object", nameKey);
        pluginConfig.changeNameKey(PluginMigrationUtils.saveAndReturnLocaleKey(pluginBuilderConfig.getPluginDefaultBundleName(), pluginBuilderConfig.getResourceDefinition(), title));
        String iconReference = XmlUtils.getLastChildElementNodeValue(extension, "object", "icon");
        if (!PluginMigrationUtils.isStringEmpty(iconReference)) {
            SpriteSheetIconReference spriteSheetIconRef = new SpriteSheetIconReference();
            spriteSheetIconRef.name = PluginMigrationUtils.saveAndReturnIconKey(pluginBuilderConfig.getPluginDefaultBundleName(), pluginBuilderConfig.getResourceDefinition(), iconReference);
            pluginConfig.changeIcon(spriteSheetIconRef);
        }
        return pluginConfig;
    }
}

