/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.h5.sdk.plugin.migration.file;

import java.io.StringWriter;
import java.util.regex.Pattern;

public class CustomStringWriter
extends StringWriter {
    private static final String INDENT_SPACE = "   ";
    private static final Pattern START_TAG_PATTERN = Pattern.compile("<(?!/)(\\S+?)(.*?)>");
    private static final Pattern END_TAG_PATTERN = Pattern.compile("(.*)(</(\\S+?)(.*?)>)");

    @Override
    public String toString() {
        String originalString = super.toString();
        String[] lines = originalString.split("\\n");
        return this.getNestedXmlString(lines, 0);
    }

    private String getNestedXmlString(String[] lines, int level) {
        StringBuilder sb = new StringBuilder();
        int deep = level;
        for (String line : lines) {
            if (START_TAG_PATTERN.matcher(line = line.trim()).matches()) {
                ++deep;
            }
            sb.append(this.getIndentSpace(deep)).append(line).append("\n");
            if (!END_TAG_PATTERN.matcher(line).matches()) continue;
            --deep;
        }
        return sb.toString();
    }

    private String getIndentSpace(int level) {
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i < level; ++i) {
            sb.append(INDENT_SPACE);
        }
        return sb.toString();
    }
}

