/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.h5.sdk.plugin.migration.utils;

import com.vmware.h5.sdk.plugin.migration.ExtensionType;
import com.vmware.h5.sdk.plugin.migration.UnsupportedExtensionInfo;
import com.vmware.h5.sdk.plugin.migration.error.PluginManifestError;
import com.vmware.h5.sdk.plugin.migration.model.Manifest;
import com.vmware.h5.sdk.plugin.migration.model.PluginBuilderConfig;
import com.vmware.h5.sdk.plugin.migration.model.ResourceDefinition;
import com.vmware.h5.sdk.plugin.migration.utils.ObjectTypeUtils;
import com.vmware.h5.sdk.plugin.migration.utils.XmlUtils;
import com.vmware.vise.plugin.manifest.model.object.ObjectType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.w3c.dom.Element;

public class PluginMigrationUtils {
    private static final Pattern RESOURCE_KEY_PATTERN = Pattern.compile("#\\{(\\w+:)*(\\w+.*\\w*)\\}");

    public static boolean isStringEmpty(String str) {
        return str == null || "".equals(str.trim());
    }

    public static String getResourceKey(String resourceValue) {
        Matcher matcher = RESOURCE_KEY_PATTERN.matcher(resourceValue);
        if (matcher.find()) {
            return matcher.group(2);
        }
        return "";
    }

    public static String getUri(Manifest manifest, Element objectElement) {
        String url = XmlUtils.getLastChildElementNodeValue(objectElement, "contentSpec", "url");
        if (PluginMigrationUtils.isStringEmpty(url)) {
            url = XmlUtils.getLastChildElementNodeValue(objectElement, "componentClass", "object", "root", "url");
        }
        return PluginMigrationUtils.getUri(manifest, url);
    }

    public static String getUri(Manifest manifest, String url) {
        if (manifest.getWebContextPath() == null) {
            throw new RuntimeException("MANIFEST.MF file does not contain webContextPath. MANIFEST.MF file could be invalid.");
        }
        String[] webContextSegments = manifest.getWebContextPath().split("/");
        String[] urlSegments = url.startsWith("/") ? url.substring(1).split("/") : url.split("/");
        int urlSegmentsStartIndex = 0;
        for (int i = 0; i < webContextSegments.length; ++i) {
            if (i >= urlSegments.length || !webContextSegments[i].equals(urlSegments[urlSegmentsStartIndex])) continue;
            ++urlSegmentsStartIndex;
        }
        return Arrays.stream(urlSegments, urlSegmentsStartIndex, urlSegments.length).collect(Collectors.joining("/"));
    }

    public static void addToUnsupportedExtensions(PluginBuilderConfig pluginBuilderConfig, String extensionType, String message, String errorCode, List<Element> elements) {
        PluginMigrationUtils.addToUnsupportedExtensions(pluginBuilderConfig, extensionType, null, message, errorCode, elements);
    }

    public static void addToUnsupportedExtensions(PluginBuilderConfig pluginBuilderConfig, String extensionType, ObjectType objectType, String message, String errorCode, List<Element> elements) {
        if (elements.isEmpty()) {
            return;
        }
        PluginMigrationUtils.addToMapIfPresent(pluginBuilderConfig.getUnsupportedExtensionsMap(), new UnsupportedExtensionInfo(extensionType, objectType, message, errorCode), elements);
    }

    public static String saveAndReturnLocaleKey(String id, ResourceDefinition resourceDefinition, String resourceName) {
        String resourceKey = PluginMigrationUtils.getResourceKey(resourceName);
        resourceDefinition.getLocaleDefinitionPropertyKeys().add(resourceKey);
        return resourceKey;
    }

    public static String saveAndReturnIconKey(String id, ResourceDefinition resourceDefinition, String resourceName) {
        String resourceKey = PluginMigrationUtils.getResourceKey(resourceName);
        resourceDefinition.getIconDefinitionPropertyKeys().add(resourceKey);
        return resourceKey;
    }

    public static Map<ObjectType, List<Element>> createObjectTypeExtensionsMap(Map<String, List<Element>> extensionsMap, Map<String, List<Element>> templateInstancesMap, PluginBuilderConfig pluginBuilderConfig) {
        HashMap<ObjectType, List<Element>> objectTypeExtensionsMap = new HashMap<ObjectType, List<Element>>();
        ArrayList<Element> unsupportedElements = new ArrayList<Element>();
        for (Map.Entry<String, List<Element>> entry : extensionsMap.entrySet()) {
            String extendedPoint = entry.getKey();
            List<Element> elements = entry.getValue();
            for (Element element : elements) {
                List<ObjectType> objectTypeList = ObjectTypeUtils.getObjectTypes(element, extendedPoint, templateInstancesMap, pluginBuilderConfig);
                if ((objectTypeList != null || objectTypeList.isEmpty()) && !PluginMigrationUtils.isExtensionTypeSupported(extendedPoint)) {
                    unsupportedElements.add(element);
                }
                objectTypeList.stream().forEach(objectType -> objectTypeExtensionsMap.computeIfAbsent((ObjectType)((Object)objectType), o -> new ArrayList()).add(element));
            }
        }
        PluginManifestError error = PluginManifestError.EXTENSIONS_UNSUPPORTED_ERR;
        PluginMigrationUtils.addToUnsupportedExtensions(pluginBuilderConfig, "unsupported-element", error.getMessage(), error.getErrorCode(), unsupportedElements);
        return objectTypeExtensionsMap;
    }

    public static void printPluginManifestConverterHelp() {
        System.out.println("Options:\n\n--projectDir or -p : Required path to the project directory which contains the plugin.xml, MANIFEST.MF, locale properties files and plugin's css and images.\n\n--outputDir or -o  : Optional path to the output directory where the converted plugin.json, sprite image file and report.txt file are placed. If this option is not specified then the converted files will be placed in the project directory specified with --projectDir or -p option.\n\n--sdkVersion or -v : Optional property to specify the target sdk version for the manifest conversion. The default value is the initial sdk version \"1.0.0\".\n\n--help or -h       : Provides help on the input options.");
    }

    private static boolean isExtensionTypeSupported(String extendedPoint) {
        for (ExtensionType extensionType : ExtensionType.values()) {
            if (!extensionType.matches(extendedPoint)) continue;
            return true;
        }
        return false;
    }

    private static void addToMapIfPresent(Map<UnsupportedExtensionInfo, List<Element>> map, UnsupportedExtensionInfo key, List<Element> elements) {
        map.computeIfAbsent(key, k -> new ArrayList()).addAll(elements);
    }
}

