/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.computepolicy;

import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vapi.std.LocalizableMessage;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.annotation.ModelMetadata;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vsphere.client.h5.computepolicy.model.ComputePolicyCapability;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class ComputePolicyCreatePropertyProvider
implements PropertyProviderBean {
    private final QueryService _queryService;

    public ComputePolicyCreatePropertyProvider(QueryServiceFactory queryServiceFactory) {
        this._queryService = queryServiceFactory.getQueryService();
    }

    @ModelMetadata(type={"Folder"}, propertyNamespace="computePolicy", property="capabilities")
    public List<ComputePolicyCapability> getComputePolicyCapabilities(ManagedObjectReference rootFolderMor) {
        ResultSet resultSet = this._queryService.select(new String[]{"capability_identifier", "capability_name", "capability_description", "capability_tag_usage_description", "@type", "@modelKey"}).from(new String[]{"com.vmware.vcenter.compute.policies.capabilities"}).fetch();
        ArrayList<ComputePolicyCapability> capabilities = new ArrayList<ComputePolicyCapability>(resultSet.getItems().size());
        for (ResourceItem resultItem : resultSet.getItems()) {
            ComputePolicyCapability capability = new ComputePolicyCapability();
            capability.capabilityIdentifier = (String)resultItem.get("capability_identifier");
            capability.capabilityName = (LocalizableMessage)resultItem.get("capability_name");
            capability.capabilityDescription = (LocalizableMessage)resultItem.get("capability_description");
            capability.tagUsageDescription = (LocalizableMessage)resultItem.get("capability_tag_usage_description");
            switch (capability.capabilityIdentifier) {
                case "com.vmware.vcenter.compute.policies.capabilities.vm_host_affinity": {
                    capability.orderIndex = 1;
                    break;
                }
                case "com.vmware.vcenter.compute.policies.capabilities.vm_host_anti_affinity": {
                    capability.orderIndex = 2;
                    break;
                }
                case "com.vmware.vcenter.compute.policies.capabilities.vm_vm_affinity": {
                    capability.orderIndex = 3;
                    break;
                }
                case "com.vmware.vcenter.compute.policies.capabilities.vm_vm_anti_affinity": {
                    capability.orderIndex = 4;
                    break;
                }
                case "com.vmware.vcenter.compute.policies.capabilities.disable_drs_vmotion": {
                    capability.orderIndex = 5;
                    break;
                }
                case "com.vmware.vcenter.compute.policies.capabilities.vm.evacuation.vmotion": {
                    capability.orderIndex = 6;
                    break;
                }
                case "com.vmware.vcenter.compute.policies.capabilities.vm.placement.anti_affinity_with_vcls": {
                    capability.orderIndex = 7;
                    break;
                }
                case "com.vmware.vcenter.compute.policies.capabilities.vm.placement.host_group.affinity.limit": {
                    capability.orderIndex = 8;
                }
            }
            capabilities.add(capability);
        }
        Collections.sort(capabilities);
        return capabilities;
    }

    @ModelMetadata(type={"inventoryservice:InventoryServiceTag"}, propertyNamespace="computePolicy", property="numberOfVmsManagedByTag")
    public int getNumberOfVmsManagedByTag(ManagedObjectReference tagMor, String serverGuid) {
        return this.getTotalNumberOfEntities(VirtualMachine.class.getSimpleName(), tagMor, serverGuid);
    }

    @ModelMetadata(type={"inventoryservice:InventoryServiceTag"}, propertyNamespace="computePolicy", property="numberOfHostsManagedByTag")
    public int getNumberOfHostsManagedByTag(ManagedObjectReference tagMor, String serverGuid) {
        return this.getTotalNumberOfEntities(HostSystem.class.getSimpleName(), tagMor, serverGuid);
    }

    private int getTotalNumberOfEntities(String entityType, ManagedObjectReference tagMor, String serverGuid) {
        List<PropertyPredicate> propertyPredicateList = this.getListWithPropertyPredicates(tagMor, serverGuid);
        ResultSet resultSet = this._queryService.select(new String[0]).from(new String[]{entityType}).where(LogicalOperator.AND, propertyPredicateList).withTotalCount().fetch();
        Integer number = resultSet.getTotalCount();
        return number != null ? number : 0;
    }

    private List<PropertyPredicate> getListWithPropertyPredicates(ManagedObjectReference tagMor, String serverGuid) {
        ArrayList<PropertyPredicate> propertyPredicateList = new ArrayList<PropertyPredicate>();
        if (StringUtils.isNotEmpty((String)serverGuid) && !StringUtils.isBlank((String)serverGuid)) {
            propertyPredicateList.add(new PropertyPredicate("serverGuid", PropertyPredicate.ComparisonOperator.EQUAL, (Object)serverGuid));
        }
        propertyPredicateList.add(new PropertyPredicate("tags", PropertyPredicate.ArrayOperator.ANY, PropertyPredicate.ComparisonOperator.EQUAL, (Object)tagMor));
        return propertyPredicateList;
    }
}

