/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.computepolicy;

import com.vmware.cis.data.api.ComplexQueryService;
import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryCommand;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.api.SortCriterion;
import com.vmware.cis.data.internal.provider.util.filter.OperatorLikeEvaluator;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vapi.std.LocalizableMessage;
import com.vmware.vim.binding.vim.ComputePolicyStatus;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.annotation.ModelMetadata;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vise.data.uri.resolve.VapiUriSchemeUtil;
import com.vmware.vise.util.Optional;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vsphere.client.h5.computepolicy.model.ComputePolicyDataParam;
import com.vmware.vsphere.client.h5.computepolicy.model.ComputePolicyOverviewData;
import com.vmware.vsphere.client.h5.computepolicy.model.ComputePolicyOverviewDetailsData;
import com.vmware.vsphere.client.h5.computepolicy.model.ComputePolicyOverviewItem;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ComputePolicyOverviewPropertyProvider
implements PropertyProviderBean {
    private final QueryService _queryService;
    private final ComplexQueryService _complexQueryService;
    private static final String NO_ASSOCIATED_OBJECTS_COUNT = "0";

    public ComputePolicyOverviewPropertyProvider(QueryServiceFactory queryServiceFactory, ComplexQueryService complexQueryService) {
        this._queryService = queryServiceFactory.getQueryService();
        this._complexQueryService = complexQueryService;
    }

    @ModelMetadata(type={"inventoryservice:InventoryServiceTag"}, propertyNamespace="computePolicy", property="overviewData")
    public ComputePolicyOverviewData getVmComputePoliciesStatus(ManagedObjectReference tagMor, ComputePolicyDataParam policyDataParam) {
        String vmPolicyStatusProperty = policyDataParam.formattedPolicyStatusProperty;
        List<SortCriterion> sortCriteria = this.getListWithSortCriteria(policyDataParam);
        List<PropertyPredicate> propertyPredicateList = this.getListWithPropertyPredicates(policyDataParam, vmPolicyStatusProperty);
        QueryCommand.Builder query = this._queryService.select(new String[]{"name", "host", "hostName", "cluster", "vmClusterName", vmPolicyStatusProperty, "@modelKey"}).from(new String[]{VirtualMachine.class.getSimpleName()}).where(LogicalOperator.OR, propertyPredicateList).withTotalCount().orderBy(sortCriteria).limit(policyDataParam.limitOfItems).offset(policyDataParam.offset);
        PropertyPredicate tagPredicate = new PropertyPredicate("tags", PropertyPredicate.ArrayOperator.ANY, PropertyPredicate.ComparisonOperator.EQUAL, (Object)tagMor);
        PropertyPredicate vmTemplatePredicate = new PropertyPredicate("isNormalVM", PropertyPredicate.ComparisonOperator.EQUAL, (Object)true);
        ArrayList<PropertyPredicate> predicateList = new ArrayList<PropertyPredicate>();
        predicateList.add(tagPredicate);
        predicateList.add(vmTemplatePredicate);
        Optional filter = Optional.of((Object)new Filter(predicateList, LogicalOperator.AND));
        ResultSet resultSet = this._complexQueryService.joinFilter(query.build(), new Filter[]{(Filter)filter.get()});
        ComputePolicyOverviewData overviewData = new ComputePolicyOverviewData();
        overviewData.overviewItems = new ArrayList<ComputePolicyOverviewItem>();
        overviewData.totalItemsCount = resultSet.getTotalCount();
        for (ResourceItem resourceItem : resultSet.getItems()) {
            if (resourceItem == null) continue;
            ComputePolicyOverviewItem computePolicyOverviewItem = new ComputePolicyOverviewItem();
            computePolicyOverviewItem.vmName = (String)resourceItem.get("name");
            computePolicyOverviewItem.vmMor = (ManagedObjectReference)resourceItem.get("@modelKey");
            computePolicyOverviewItem.hostMor = (ManagedObjectReference)resourceItem.get("host");
            computePolicyOverviewItem.hostName = resourceItem.get("hostName") != null ? (String)resourceItem.get("hostName") : this.localizeString("computePolicy.na", new String[0]);
            computePolicyOverviewItem.clusterMor = (ManagedObjectReference)resourceItem.get("cluster");
            computePolicyOverviewItem.clusterName = resourceItem.get("vmClusterName") != null ? (String)resourceItem.get("vmClusterName") : this.localizeString("computePolicy.na", new String[0]);
            String status = (String)resourceItem.get(vmPolicyStatusProperty);
            if (ComputePolicyStatus.ComplianceStatus.Compliant.name().equals(status)) {
                computePolicyOverviewItem.statusLabel = this.localizeString("compute.policy.compliant.status", new String[0]);
                computePolicyOverviewItem.compliantStatus = ComputePolicyOverviewItem.CompliantStatus.COMPLIANT;
            } else if (ComputePolicyStatus.ComplianceStatus.NonCompliant.name().equals(status)) {
                computePolicyOverviewItem.statusLabel = this.localizeString("compute.policy.non.compliant.status", new String[0]);
                computePolicyOverviewItem.compliantStatus = ComputePolicyOverviewItem.CompliantStatus.NON_COMPLIANT;
            } else if (ComputePolicyStatus.ComplianceStatus.NotApplicable.name().equals(status)) {
                computePolicyOverviewItem.statusLabel = this.localizeString("compute.policy.non.applicable.status", new String[0]);
                computePolicyOverviewItem.compliantStatus = ComputePolicyOverviewItem.CompliantStatus.INACTIVE;
            } else if (ComputePolicyStatus.ComplianceStatus.Unknown.name().equals(status)) {
                computePolicyOverviewItem.statusLabel = this.localizeString("compute.policy.unknown.status", new String[0]);
                computePolicyOverviewItem.compliantStatus = ComputePolicyOverviewItem.CompliantStatus.UNKNOWN;
            }
            overviewData.overviewItems.add(computePolicyOverviewItem);
        }
        return overviewData;
    }

    private List<PropertyPredicate> getListWithPropertyPredicates(ComputePolicyDataParam policyDataParam, String vmPolicyStatusProperty) {
        ArrayList<PropertyPredicate> propertyPredicateList = new ArrayList<PropertyPredicate>();
        if (policyDataParam.searchTerm != null) {
            String searchTemplate = OperatorLikeEvaluator.toSearchTemplate((String)policyDataParam.searchTerm, (OperatorLikeEvaluator.StringMatchingMode)OperatorLikeEvaluator.StringMatchingMode.Contains);
            propertyPredicateList.add(this.createPredicateWithProperty(vmPolicyStatusProperty, searchTemplate));
            propertyPredicateList.add(this.createPredicateWithProperty("name", searchTemplate));
            propertyPredicateList.add(this.createPredicateWithProperty("hostName", searchTemplate));
            propertyPredicateList.add(this.createPredicateWithProperty("vmClusterName", searchTemplate));
        } else {
            propertyPredicateList.add(new PropertyPredicate(vmPolicyStatusProperty, PropertyPredicate.ComparisonOperator.EQUAL, (Object)ComputePolicyStatus.ComplianceStatus.Compliant.name()));
            propertyPredicateList.add(new PropertyPredicate(vmPolicyStatusProperty, PropertyPredicate.ComparisonOperator.EQUAL, (Object)ComputePolicyStatus.ComplianceStatus.NotApplicable.name()));
            propertyPredicateList.add(new PropertyPredicate(vmPolicyStatusProperty, PropertyPredicate.ComparisonOperator.EQUAL, (Object)ComputePolicyStatus.ComplianceStatus.NonCompliant.name()));
            propertyPredicateList.add(new PropertyPredicate(vmPolicyStatusProperty, PropertyPredicate.ComparisonOperator.EQUAL, (Object)ComputePolicyStatus.ComplianceStatus.Unknown.name()));
        }
        return propertyPredicateList;
    }

    @ModelMetadata(type={"com.vmware.vcenter.compute.policies"}, property="com.vmware.vcenter.compute.policies/overviewDetailsData")
    public ComputePolicyOverviewDetailsData getComputePolicyOverviewDetails(URI policyUri) {
        String policyId = VapiUriSchemeUtil.getId((URI)policyUri);
        ResultSet resultSet = this._queryService.select(new String[]{"policy_name", "policy_description", "capability_name", "capability_description", "vm_tag_association_count", "host_tag_identifier", "host_tag_association_count", "group_size"}).from(new String[]{"com.vmware.vcenter.compute.policies"}).where(new PropertyPredicate[]{new PropertyPredicate("policy_identifier", PropertyPredicate.ComparisonOperator.EQUAL, (Object)policyId)}).fetch();
        ComputePolicyOverviewDetailsData detailsData = new ComputePolicyOverviewDetailsData();
        for (ResourceItem resultItem : resultSet.getItems()) {
            String key;
            boolean hasGroupSize;
            if (resultItem == null) continue;
            detailsData.policyName = (String)resultItem.get("policy_name");
            detailsData.capabilityType = (LocalizableMessage)resultItem.get("capability_name");
            detailsData.description = (String)resultItem.get("policy_description");
            if ((detailsData.description == null || detailsData.description.trim().isEmpty()) && resultItem.get("capability_description") != null) {
                detailsData.defaultDescription = (LocalizableMessage)resultItem.get("capability_description");
            }
            String numberOfVms = "";
            String numberOfHosts = "";
            numberOfVms = this.getNumberOfItems("vm_tag_association_count", resultItem);
            boolean hasHostTagAssociations = resultItem.get("host_tag_identifier") != null;
            boolean bl = hasGroupSize = resultItem.get("group_size") != null;
            if (hasHostTagAssociations) {
                numberOfHosts = this.getNumberOfItems("host_tag_association_count", resultItem);
                key = Integer.valueOf(numberOfVms) == 1 ? (Integer.valueOf(numberOfHosts) == 1 ? "compute.policy.overview.related.vmsAndHosts.msg" : "compute.policy.overview.related.vmsAndHosts.multipleHosts.msg") : (Integer.valueOf(numberOfHosts) == 1 ? "compute.policy.overview.related.vmsAndHosts.multipleVms.msg" : "compute.policy.overview.related.vmsAndHosts.multiple.msg");
                detailsData.relatedObjectsMsg = this.localizeString(key, numberOfVms, numberOfHosts);
                continue;
            }
            if (hasGroupSize) {
                Long groupSize = (Long)resultItem.get("group_size");
                String key2 = Integer.valueOf(numberOfVms) == 1 ? (groupSize.intValue() == 1 ? "compute.policy.overview.related.vmsHostGroupLimit.msg" : "compute.policy.overview.related.vmsHostGroupLimit.multipleHosts.msg") : (groupSize.intValue() == 1 ? "compute.policy.overview.related.vmsHostGroupLimit.multipleVms.msg" : "compute.policy.overview.related.vmsHostGroupLimit.multiple.msg");
                detailsData.relatedObjectsMsg = this.localizeString(key2, numberOfVms, String.valueOf(groupSize));
                continue;
            }
            key = Integer.valueOf(numberOfVms) == 1 ? "compute.policy.overview.related.vms.msg" : "compute.policy.overview.related.vms.multiple.msg";
            detailsData.relatedObjectsMsg = this.localizeString(key, numberOfVms);
        }
        return detailsData;
    }

    private String getNumberOfItems(String property, ResourceItem resultItem) {
        Long numberOfVmsLongValue = (Long)resultItem.get(property);
        return numberOfVmsLongValue != null ? String.valueOf(numberOfVmsLongValue) : NO_ASSOCIATED_OBJECTS_COUNT;
    }

    private String localizeString(String key, String ... parameters) {
        return ResourceUtil.getString((String)"h5computepolicyservice", (String)key, (String[])parameters, (ClassLoader)ComputePolicyOverviewPropertyProvider.class.getClassLoader());
    }

    private List<SortCriterion> getListWithSortCriteria(ComputePolicyDataParam policyDataParam) {
        ArrayList<SortCriterion> sortCriteria = new ArrayList<SortCriterion>();
        ArrayList<String> propertyNames = new ArrayList<String>();
        String vmPolicyStatusPropertyValue = policyDataParam.formattedPolicyStatusValueProperty;
        if (policyDataParam.sortSpecs != null) {
            ArrayList sortSpecs = (ArrayList)policyDataParam.sortSpecs;
            for (LinkedHashMap sortSpec : sortSpecs) {
                String propertyName = "";
                SortCriterion.SortDirection direction = null;
                for (Map.Entry entrySet : sortSpec.entrySet()) {
                    if (((String)entrySet.getKey()).equals("field")) {
                        propertyName = ((String)entrySet.getValue()).equals(policyDataParam.formattedPolicyStatusProperty) ? vmPolicyStatusPropertyValue : (String)entrySet.getValue();
                    }
                    if (!((String)entrySet.getKey()).equals("dir")) continue;
                    if (((String)entrySet.getValue()).equals("desc")) {
                        direction = SortCriterion.SortDirection.DESCENDING;
                        continue;
                    }
                    direction = SortCriterion.SortDirection.ASCENDING;
                }
                this.addSortCriteria(sortCriteria, propertyName, direction);
                propertyNames.add(propertyName);
                if (!propertyNames.contains(vmPolicyStatusPropertyValue)) {
                    this.addSortCriteria(sortCriteria, vmPolicyStatusPropertyValue, direction);
                    propertyNames.add(vmPolicyStatusPropertyValue);
                }
                if (propertyNames.contains("name")) continue;
                this.addSortCriteria(sortCriteria, "name", direction);
                propertyNames.add("name");
            }
        } else {
            this.addSortCriteria(sortCriteria, vmPolicyStatusPropertyValue, SortCriterion.SortDirection.DESCENDING);
            this.addSortCriteria(sortCriteria, "name", SortCriterion.SortDirection.ASCENDING);
        }
        return sortCriteria;
    }

    private void addSortCriteria(List<SortCriterion> sortCriteria, String propertyName, SortCriterion.SortDirection direction) {
        SortCriterion orderByProperty = new SortCriterion(propertyName, direction);
        sortCriteria.add(orderByProperty);
    }

    private PropertyPredicate createPredicateWithProperty(String property, String searchTemplate) {
        return new PropertyPredicate(property, PropertyPredicate.ArrayOperator.ANY, PropertyPredicate.ComparisonOperator.LIKE, (Object)searchTemplate, true);
    }
}

