/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vm.cloudpatch.service;

import com.vmware.vim.binding.vim.fault.InvalidLogin;
import com.vmware.vim.binding.vim.vm.RelocateSpec;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.fault.SystemError;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vsphere.client.vm.VmCloneSpec;
import com.vmware.vsphere.client.vm.cloudpatch.error.CloudCredentialsInvalidError;
import com.vmware.vsphere.client.vm.cloudpatch.error.CloudCredentialsRequiredError;
import com.vmware.vsphere.client.vm.migration.LocationSpecPair;

public class CloudPatchService {
    static final String SIGNATURE_VERIFICATION_ERROR = "Signature verification error. No verification key available.";
    static final String VMC_GATEWAY_PROPERTY = "vmc.gateway.mode";
    private boolean _isRunningOnVmcGateway = false;

    public CloudPatchService(ConfigurationService configurationService) {
        String propertyValue = configurationService.getProperty(VMC_GATEWAY_PROPERTY);
        this._isRunningOnVmcGateway = propertyValue != null && propertyValue.equalsIgnoreCase("true");
    }

    public Exception handleRelocateError(Exception e, LocationSpecPair specPair) {
        if (specPair == null || specPair.spec == null) {
            return e;
        }
        return this.handleError(e, specPair.entity, specPair.spec.relocateSpec);
    }

    public Exception handleCloneError(Exception e, VmCloneSpec spec) {
        if (spec == null || spec.cloneSpec == null || spec.cloneSpec.location == null) {
            return e;
        }
        return this.handleError(e, spec.vm, spec.cloneSpec.location);
    }

    public Exception handleError(Exception e, ManagedObjectReference vm, RelocateSpec spec) {
        if (spec == null || !this._isRunningOnVmcGateway || !this.isCrossVcOperation(vm, spec)) {
            return e;
        }
        if (this.isSignatureVerificationError(e)) {
            return new CloudCredentialsRequiredError(e);
        }
        if (e instanceof InvalidLogin) {
            return new CloudCredentialsInvalidError(e);
        }
        return e;
    }

    private boolean isCrossVcOperation(ManagedObjectReference vm, RelocateSpec spec) {
        return vm != null && !vm.getServerGuid().equals(CloudPatchService.getDestinationServerGuid(spec));
    }

    private boolean isSignatureVerificationError(Exception e) {
        if (!(e instanceof SystemError)) {
            return false;
        }
        SystemError se = (SystemError)e;
        return se.getReason() != null && se.getReason().equals(SIGNATURE_VERIFICATION_ERROR);
    }

    private static String getDestinationServerGuid(RelocateSpec spec) {
        ManagedObjectReference target = null;
        if (spec.pool != null) {
            target = spec.pool;
        } else if (spec.host != null) {
            target = spec.host;
        } else if (spec.datastore != null) {
            target = spec.datastore;
        }
        return target != null ? target.getServerGuid() : null;
    }
}

