/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vm.customizations.impl;

import com.vmware.vim.binding.vim.CustomizationSpecItem;
import com.vmware.vim.binding.vim.CustomizationSpecManager;
import com.vmware.vim.binding.vim.vm.customization.Password;
import com.vmware.vim.binding.vim.vm.customization.Specification;
import com.vmware.vim.binding.vim.vm.customization.Sysprep;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.mutation.OperationResult;
import com.vmware.vise.core.model.mutation.ValidationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.mixed.MixedServiceUtil;
import com.vmware.vsphere.client.vm.customizations.VmCustomizationCopySpec;
import com.vmware.vsphere.client.vm.customizations.VmCustomizationDuplicateSpec;
import com.vmware.vsphere.client.vm.customizations.VmCustomizationEditSpec;
import com.vmware.vsphere.client.vm.customizations.VmCustomizationImportSpec;
import com.vmware.vsphere.client.vm.customizations.VmCustomizationImportValidationSpec;
import com.vmware.vsphere.client.vm.customizations.VmCustomizationNameValidationSpec;
import com.vmware.vsphere.client.vm.customizations.VmCustomizationRemovalSpec;
import com.vmware.vsphere.client.vm.customizations.VmCustomizationRenameSpec;
import com.vmware.vsphere.client.vm.customizations.VmCustomizationSpec;
import com.vmware.vsphere.client.vm.customizations.impl.VmCustomizationPasswordService;
import com.vmware.vsphere.client.vm.customizations.impl.VmCustomizationSpecService;
import com.vmware.vsphere.client.vm.customizations.impl.VmCustomizationValidator;
import com.vmware.vsphere.client.vm.util.FetchedManagedObject;
import java.security.Provider;
import java.security.Security;
import org.apache.commons.lang3.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;

public class VmCustomizationMutationProvider
implements MutationProvider {
    private static final int SPEC_NAME_MAX_LENGTH = 255;
    private static final Log _logger = LogFactory.getLog(VmCustomizationMutationProvider.class);
    private VmCustomizationValidator customizationValidator;
    private final VmCustomizationSpecService _customizationSpecService;
    private final VmCustomizationPasswordService _vmCustomizationPasswordService;

    public VmCustomizationMutationProvider(VmCustomizationValidator customizationValidator, VmCustomizationSpecService customizationSpecService, VmCustomizationPasswordService vmCustomizationPasswordService) {
        this.customizationValidator = customizationValidator;
        this._customizationSpecService = customizationSpecService;
        this._vmCustomizationPasswordService = vmCustomizationPasswordService;
    }

    public OperationResult add(VmCustomizationSpec spec) {
        OperationResult opResult = new OperationResult();
        try {
            CustomizationSpecManager manager = this._customizationSpecService.getCustomizationSpecManager(spec.customizationSpecManager);
            this.encryptPasswordIfNecessary(manager, spec);
            manager.create(spec.config);
            opResult.entity = manager._getRef();
            opResult.result = spec.config.info.name;
        }
        catch (Exception e) {
            _logger.error((Object)"Error occurred while creating vm customization spec.", (Throwable)e);
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    public OperationResult add(VmCustomizationCopySpec spec) {
        OperationResult opResult = new OperationResult();
        try {
            CustomizationSpecManager manager = this._customizationSpecService.getCustomizationSpecManager(spec.customizationSpecManager);
            String newName = MixedServiceUtil.getLocalizedString((String)"VmCustomization.copyName");
            newName = String.format(newName, spec.specName);
            newName = VmCustomizationMutationProvider.getCustomizationSpecUniqueName(manager, newName);
            manager.duplicate(spec.specName, newName);
            opResult.entity = spec.customizationSpecManager;
            opResult.result = newName;
        }
        catch (Exception e) {
            _logger.error((Object)"Error occurred while cloning vm customization spec.", (Throwable)e);
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    public OperationResult add(VmCustomizationDuplicateSpec spec) {
        Validate.notNull((Object)spec.newSpecName);
        Validate.notNull((Object)spec.newSpecDesc);
        Validate.notNull((Object)spec.sourceSpecName);
        Validate.notNull((Object)spec.sourceSpecManagerRef);
        Validate.notNull((Object)spec.targetVcGuid);
        OperationResult opResult = new OperationResult();
        try {
            String newName;
            ManagedObjectReference affectedSpecManagerRef;
            CustomizationSpecManager sourceSpecManager = this._customizationSpecService.getCustomizationSpecManager(spec.sourceSpecManagerRef);
            CustomizationSpecItem sourceSpecItem = sourceSpecManager.get(spec.sourceSpecName);
            this.customizationValidator.checkAutoLogon(sourceSpecItem);
            if (spec.sourceSpecManagerRef.getServerGuid().equals(spec.targetVcGuid)) {
                affectedSpecManagerRef = spec.sourceSpecManagerRef;
                newName = VmCustomizationMutationProvider.getCustomizationSpecUniqueName(sourceSpecManager, spec.newSpecName);
                sourceSpecItem.getInfo().setName(newName);
                sourceSpecItem.getInfo().setDescription(spec.newSpecDesc);
                sourceSpecManager.create(sourceSpecItem);
            } else {
                FetchedManagedObject<CustomizationSpecManager> customizationSpecManager = this._customizationSpecService.getCustomizationSpecManager(spec.targetVcGuid);
                affectedSpecManagerRef = customizationSpecManager.getMor();
                CustomizationSpecManager targetSpecManager = customizationSpecManager.getManagedObject();
                newName = VmCustomizationMutationProvider.getCustomizationSpecUniqueName(targetSpecManager, spec.newSpecName);
                sourceSpecItem.getInfo().setName(newName);
                sourceSpecItem.getInfo().setDescription(spec.newSpecDesc);
                this.customizationValidator.checkPublicKey(targetSpecManager, sourceSpecItem);
                sourceSpecItem.getSpec().setEncryptionKey(targetSpecManager.getEncryptionKey());
                targetSpecManager.create(sourceSpecItem);
            }
            opResult.entity = affectedSpecManagerRef;
            opResult.result = newName;
        }
        catch (Exception e) {
            _logger.error((Object)"Error occurred while cloning vm customization spec.", (Throwable)e);
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    public OperationResult add(VmCustomizationImportSpec spec) {
        OperationResult opResult = new OperationResult();
        try {
            CustomizationSpecManager manager = this._customizationSpecService.getCustomizationSpecManager(spec.customizationSpecManager);
            opResult.entity = manager._getRef();
            CustomizationSpecItem specItem = spec.customizationSpecItem;
            String origName = specItem.getInfo().getName();
            String newName = VmCustomizationMutationProvider.getCustomizationSpecUniqueName(manager, origName);
            specItem.getInfo().setName(newName);
            specItem.getSpec().setEncryptionKey(manager.getEncryptionKey());
            manager.create(specItem);
            opResult.result = specItem;
        }
        catch (Exception e) {
            _logger.error((Object)"Error occurred while importing vm customization spec.", (Throwable)e);
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    public OperationResult remove(ManagedObjectReference specManagerRef, VmCustomizationRemovalSpec spec) {
        OperationResult opResult = new OperationResult();
        try {
            CustomizationSpecManager manager = this._customizationSpecService.getCustomizationSpecManager(specManagerRef);
            manager.delete(spec.specName);
            opResult.entity = specManagerRef;
            opResult.result = spec.specName;
        }
        catch (Exception e) {
            _logger.error((Object)"Error occurred while deleting vm customization spec.", (Throwable)e);
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    public OperationResult apply(ManagedObjectReference specManager, VmCustomizationRenameSpec renameSpec) {
        OperationResult opResult = new OperationResult();
        try {
            CustomizationSpecManager manager = this._customizationSpecService.getCustomizationSpecManager(specManager);
            if (!renameSpec.newName.equals(renameSpec.oldName)) {
                manager.rename(renameSpec.oldName, renameSpec.validatedName);
            }
            opResult.entity = manager;
            opResult.result = renameSpec.validatedName;
        }
        catch (Exception ex) {
            _logger.error((Object)"Error occurred while renaming vm customization spec.", (Throwable)ex);
            opResult.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return opResult;
    }

    public OperationResult apply(ManagedObjectReference specManager, VmCustomizationEditSpec editSpec) {
        OperationResult opResult = new OperationResult();
        try {
            CustomizationSpecManager manager = this._customizationSpecService.getCustomizationSpecManager(specManager);
            this.encryptPasswordIfNecessary(manager, (VmCustomizationSpec)editSpec);
            String editedSpecName = editSpec.newName;
            if (editSpec.newName != null && !editSpec.newName.equals(editSpec.oldName)) {
                editedSpecName = VmCustomizationMutationProvider.getCustomizationSpecUniqueName(manager, editSpec.newName);
                manager.rename(editSpec.oldName, editedSpecName);
            }
            if (editSpec.isSpecModified) {
                manager.overwrite(editSpec.config);
            }
            opResult.result = editedSpecName;
            opResult.entity = specManager;
        }
        catch (Exception ex) {
            _logger.error((Object)"Error occurred while renaming vm customization spec.", (Throwable)ex);
            opResult.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return opResult;
    }

    private void encryptPasswordIfNecessary(CustomizationSpecManager manager, VmCustomizationSpec spec) throws Exception {
        Specification specification = spec.config.getSpec();
        if (specification.getIdentity() instanceof Sysprep) {
            byte[] key = manager.getEncryptionKey();
            specification.encryptionKey = key;
            Sysprep identity = (Sysprep)specification.getIdentity();
            Password password = identity.getGuiUnattended().getPassword();
            if (spec.passwordEncryption.encryptAdminPassword && this._vmCustomizationPasswordService.isPasswordEncryptionNeeded(password)) {
                password.value = this._vmCustomizationPasswordService.encryptPassword(key, password.value);
            }
            password = identity.getIdentification().getDomainAdminPassword();
            if (spec.passwordEncryption.encryptDomainPassword && this._vmCustomizationPasswordService.isPasswordEncryptionNeeded(password)) {
                password.value = this._vmCustomizationPasswordService.encryptPassword(key, password.value);
            }
        }
    }

    public ValidationResult validate(Object entity, VmCustomizationRenameSpec spec) throws Exception {
        CustomizationSpecManager manager = this._customizationSpecService.getCustomizationSpecManager((ManagedObjectReference)entity);
        String newName = VmCustomizationMutationProvider.getCustomizationSpecUniqueName(manager, spec.newName);
        ValidationResult result = new ValidationResult();
        spec.validatedName = newName;
        result.result = spec;
        return result;
    }

    public ValidationResult validate(Object entity, VmCustomizationNameValidationSpec spec) throws Exception {
        CustomizationSpecManager manager = this._customizationSpecService.getCustomizationSpecManager((ManagedObjectReference)entity);
        ValidationResult result = new ValidationResult();
        result.result = false;
        if (manager.exists(spec.specName)) {
            result.result = true;
        }
        return result;
    }

    public ValidationResult validate(Object entity, VmCustomizationImportValidationSpec spec) {
        ValidationResult result = this.customizationValidator.checkImport(spec);
        return result;
    }

    public ValidationResult validate(ManagedObjectReference sourceSpecManagerRef, VmCustomizationDuplicateSpec spec) throws Exception {
        Validate.notNull((Object)spec.targetVcGuid);
        Validate.notNull((Object)spec.sourceSpecManagerRef);
        Validate.notNull((Object)spec.sourceSpecName);
        ValidationResult result = this.customizationValidator.checkDuplicate(spec);
        return result;
    }

    private static String getCustomizationSpecUniqueName(CustomizationSpecManager specManager, String name) {
        int cnt = 1;
        String newName = name;
        if (newName.length() > 255) {
            newName = newName.substring(0, 255);
        }
        while (specManager.exists(newName)) {
            String cntString = Integer.toString(++cnt);
            int toAppend = cntString.length() + 2;
            if (name.length() + toAppend > 255) {
                name = name.substring(0, 255 - toAppend);
            }
            newName = name + "(" + cntString + ")";
        }
        return newName;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleFipsProvider());
    }
}

