/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vm.impl;

import com.vmware.vim.binding.vim.storageDrs.StoragePlacementSpec;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.mutation.ValidationResult;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.vim.tasks.TaskMonitor;
import com.vmware.vsphere.client.common.ServiceLocatorFactory;
import com.vmware.vsphere.client.vm.VmCloneSpec;
import com.vmware.vsphere.client.vm.cloudpatch.service.CloudPatchService;
import com.vmware.vsphere.client.vm.provisioning.impl.ProvisioningValidator;
import com.vmware.vsphere.client.vm.storageDrs.impl.StoragePlacementSpecBuilder;
import com.vmware.vsphere.client.vm.storageDrs.impl.StorageRecommendationsValidator;
import com.vmware.vsphere.client.vm.util.Util;

public class DrsStorageRecommendationValidator {
    private final DataService _dataService;
    private final ServiceLocatorFactory _serviceLocatorFactory;
    private final TaskMonitor _taskMonitor;
    private CloudPatchService _cloudPatchService;

    public DrsStorageRecommendationValidator(DataService dataService, TaskMonitor taskMonitor, ServiceLocatorFactory serviceLocatorFactory) {
        this._dataService = dataService;
        this._taskMonitor = taskMonitor;
        this._serviceLocatorFactory = serviceLocatorFactory;
    }

    public void setCloudPatch(CloudPatchService cloudPatch) {
        this._cloudPatchService = cloudPatch;
    }

    public ValidationResult validate(ManagedObjectReference vm, VmCloneSpec vmCloneSpec) throws Exception {
        ValidationResult result = new ValidationResult();
        Util.populateSpecWithXvcInfo(vmCloneSpec, false, this._dataService, this._serviceLocatorFactory);
        if (vmCloneSpec.podSelectionSpec == null) {
            ProvisioningValidator validator = new ProvisioningValidator(this._taskMonitor, vm, vmCloneSpec);
            validator.setCloudPatch(this._cloudPatchService);
            result = validator.checkClone();
        } else {
            StoragePlacementSpec spec = StoragePlacementSpecBuilder.createSpec(vmCloneSpec);
            StorageRecommendationsValidator validator = new StorageRecommendationsValidator(vm, spec);
            result = validator.getValidationResult();
        }
        return result;
    }
}

