/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vm.migration.impl;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.vmware.sso.tokenmgmt.SsoDomainHelper;
import com.vmware.vcenter.apigw.api.sso.MultiTokenNotSupportedException;
import com.vmware.vcenter.apigw.api.sso.SsoDomain;
import com.vmware.vcenter.apigw.api.sso.SsoService;
import com.vmware.vcenter.apigw.api.sso.SsoServiceException;
import com.vmware.vcenter.apigw.api.sso.SsoServiceLocator;
import com.vmware.vcenter.apigw.api.sso.SsoServicesFederation;
import com.vmware.vcenter.apigw.api.sso.TokenProperties;
import com.vmware.vcenter.apigw.api.sso.tokenmgmt.SamlTokenEx;
import com.vmware.vim.binding.lookup.ServiceRegistration;
import com.vmware.vim.binding.lookup.fault.EntryNotFoundFault;
import com.vmware.vim.binding.vim.ServiceDirectory;
import com.vmware.vim.binding.vim.ServiceLocator;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vise.data.query.impl.Utils;
import com.vmware.vise.util.ExceptionUtil;
import com.vmware.vise.vim.commons.VcServiceHelper;
import com.vmware.vise.vim.commons.sso.AuthSessionUtil;
import com.vmware.vise.vim.lookup.LookupService;
import com.vmware.vise.vim.lookup.LookupUtil;
import com.vmware.vise.vim.security.sso.SsoUtil;
import com.vmware.vsphere.client.common.ServiceLocatorFactory;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VcServiceLocatorFactory
implements ServiceLocatorFactory {
    private static final Log _logger = LogFactory.getLog(VcServiceLocatorFactory.class);
    private static final String VC_SERVICE_ENDPOINT_TYPE_ID = "com.vmware.vim";
    private static final String UPN_SEPARATOR = "@";
    private static final ServiceLocator INVALID_LOCATOR = new ServiceLocator();
    private final SsoServiceLocator _ssoServiceLocator;
    private final SsoService _ssoService;
    private final LookupService _lookupService;
    private final VcServiceHelper _vcServiceHelper;
    private final LoadingCache<Context, ServiceLocator> _cachedLocatorsByContext = CacheBuilder.newBuilder().softValues().expireAfterWrite(30L, TimeUnit.SECONDS).build((CacheLoader)new Loader());

    public VcServiceLocatorFactory(SsoServiceLocator ssoServiceLocator, SsoService ssoService, LookupService lookupService, VcServiceHelper vcSvcHelper) {
        this._ssoServiceLocator = Objects.requireNonNull(ssoServiceLocator);
        this._ssoService = Objects.requireNonNull(ssoService);
        this._lookupService = Objects.requireNonNull(lookupService);
        this._vcServiceHelper = Objects.requireNonNull(vcSvcHelper);
    }

    public ServiceLocator newServiceLocator(String serviceId, ServiceLocator.NamePassword credential) {
        ServiceLocator vcLocator = this.createVcLocatorWithCredential(serviceId, (ServiceLocator.Credential)credential);
        return vcLocator;
    }

    public ServiceLocator newServiceLocator(String serviceId, SsoDomain targetSsoDomain, SsoDomain sourceSsoDomain, SamlTokenEx tokenEx, String delegeeServiceId) {
        ServiceLocator vcLocator = null;
        try {
            Context context = new Context(serviceId, targetSsoDomain, sourceSsoDomain, tokenEx, delegeeServiceId);
            vcLocator = (ServiceLocator)this._cachedLocatorsByContext.getUnchecked((Object)context);
        }
        catch (IllegalArgumentException iaeException) {
            _logger.error((Object)("Invalid ServiceLocator creation context: " + iaeException.getMessage()), (Throwable)iaeException);
        }
        catch (Exception exception) {
            _logger.error((Object)("Unexpected error while creating ServiceLocator for serviceId: " + serviceId + " and delegeeServiceId: " + delegeeServiceId + " : " + exception.getMessage()), (Throwable)exception);
        }
        if (vcLocator == INVALID_LOCATOR) {
            return null;
        }
        return vcLocator;
    }

    private ServiceLocator.Credential createSamlCredential(SsoDomain targetSsoDomain, SsoDomain sourceSsoDomain, SamlTokenEx tokenEx, String delegeeServiceId) throws SsoServiceException {
        ServiceLocator.SAMLCredential credential = null;
        if (delegeeServiceId == null) {
            credential = new ServiceLocator.SAMLCredential(tokenEx.getToken().toXml());
            return credential;
        }
        try {
            SamlToken delegatedToken;
            ServiceRegistration.Info vcInfo = this._lookupService.find(delegeeServiceId);
            String delegateName = VcServiceLocatorFactory.extractUsernameFromUpn(vcInfo.getOwnerId());
            SsoDomain delegateDomain = (SsoDomain)LookupUtil.getSsoDomain((ServiceRegistration.Info)vcInfo).orElse((Object)SsoDomainHelper.getLocal());
            SsoDomain authzTokenIssuerDomain = tokenEx.getIssuerSsoDomain();
            SamlToken authzToken = tokenEx.getToken();
            SsoServicesFederation sourceSsoFed = this._ssoServiceLocator.getSsoServicesFederation(sourceSsoDomain);
            SsoServicesFederation delegateSsoFed = this._ssoServiceLocator.getSsoServicesFederation(delegateDomain);
            long tokenLifetimeMs = TimeUnit.HOURS.toSeconds(5L);
            long tokenLifetimeSecs = TimeUnit.MILLISECONDS.toSeconds(tokenLifetimeMs);
            TokenProperties tokenProps = new TokenProperties(tokenLifetimeSecs, true, true);
            SsoDomain delegatedTokenIssuerDomain = sourceSsoDomain;
            if (!sourceSsoFed.hasMultiTokenSupport() || !delegateSsoFed.hasMultiTokenSupport()) {
                delegatedTokenIssuerDomain = authzTokenIssuerDomain;
            }
            try {
                _logger.info((Object)("Acquiring a token for the source VC. sourceSsoDomain=" + sourceSsoDomain + ", delegatedTokenIssuerDomain=" + delegatedTokenIssuerDomain + ", authzTokenIssuerDomain=" + authzTokenIssuerDomain + ", delegateDomain=" + delegateDomain + ".  delegateName=" + delegateName));
                SamlTokenEx delegatedTokenEx = this._ssoService.acquireDelegatedToken(delegatedTokenIssuerDomain, authzTokenIssuerDomain, authzToken, delegateDomain, delegateName, tokenProps);
                delegatedToken = delegatedTokenEx.getToken();
                delegatedTokenIssuerDomain = delegatedTokenEx.getIssuerSsoDomain();
            }
            catch (Exception e) {
                if (!ExceptionUtil.isCausedBy((Throwable)e, MultiTokenNotSupportedException.class)) {
                    throw e;
                }
                if (delegatedTokenIssuerDomain.equals((Object)authzTokenIssuerDomain)) {
                    throw e;
                }
                _logger.error((Object)("Multi-token failed for domain " + delegatedTokenIssuerDomain + ". Will switch to single-token, and more specifically, will try to acquire a token from the authorization token's domain " + authzTokenIssuerDomain), (Throwable)e);
                SamlTokenEx delegatedTokenEx = this._ssoService.acquireDelegatedToken(authzTokenIssuerDomain, authzTokenIssuerDomain, authzToken, sourceSsoDomain, delegateName, tokenProps);
                delegatedToken = delegatedTokenEx.getToken();
                delegatedTokenIssuerDomain = delegatedTokenEx.getIssuerSsoDomain();
            }
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("Acquired token: " + SsoUtil.getTokenDescription((SamlToken)delegatedToken)));
            }
            if (!delegatedTokenIssuerDomain.equals((Object)targetSsoDomain)) {
                SsoServicesFederation targetSsoFed = this._ssoServiceLocator.getSsoServicesFederation(targetSsoDomain);
                if (sourceSsoFed.hasMultiTokenSupport() && targetSsoFed.hasMultiTokenSupport()) {
                    _logger.info((Object)("Acquiring a token for the target VC from STS  in domain " + targetSsoDomain + ". delegatedTokenIssuerDomain=" + delegatedTokenIssuerDomain + ", delegateName=" + delegateName));
                    try {
                        SamlTokenEx tokenExIssuedByTargetSts = this._ssoService.acquireDelegatedToken(targetSsoDomain, authzTokenIssuerDomain, authzToken, delegatedTokenIssuerDomain, delegatedToken, tokenProps);
                        delegatedToken = tokenExIssuedByTargetSts.getToken();
                        if (_logger.isDebugEnabled()) {
                            _logger.debug((Object)("Acquired token: " + SsoUtil.getTokenDescription((SamlToken)delegatedToken)));
                        }
                    }
                    catch (Exception e) {
                        if (ExceptionUtil.isCausedBy((Throwable)e, MultiTokenNotSupportedException.class)) {
                            _logger.warn((Object)("Failed to acquire a token for the target SSO domain " + targetSsoDomain + " due to lack of multi-token support. Will switch to single-token."), (Throwable)e);
                            if (!delegatedTokenIssuerDomain.equals((Object)authzTokenIssuerDomain)) {
                                SamlTokenEx acqTokenEx = this._ssoService.acquireDelegatedToken(authzTokenIssuerDomain, authzTokenIssuerDomain, authzToken, delegateDomain, delegateName, tokenProps);
                                delegatedToken = acqTokenEx.getToken();
                            }
                        }
                        throw e;
                    }
                }
            }
            credential = new ServiceLocator.SAMLCredential(delegatedToken.toXml());
        }
        catch (EntryNotFoundFault lsFault) {
            String errorMsg = "Error while retrieving delegate service from LS: " + lsFault.getMessage();
            _logger.error((Object)errorMsg, (Throwable)lsFault);
            throw new SsoServiceException(errorMsg, (Throwable)lsFault);
        }
        catch (Exception e) {
            String errorMsg = "Error while delegating token: " + e.getMessage();
            _logger.error((Object)errorMsg, (Throwable)e);
            if (e instanceof SsoServiceException) {
                throw (SsoServiceException)e;
            }
            throw new SsoServiceException(errorMsg, (Throwable)e);
        }
        return credential;
    }

    private ServiceLocator createVcLocatorWithCredential(String serverGuid, ServiceLocator.Credential credential) {
        if (credential == null) {
            _logger.error((Object)"Error, during ServiceLocator creation! Provided credential must not be null!");
            return null;
        }
        String vcEndpointUrl = this.getVcEndpointUrl(serverGuid);
        if (vcEndpointUrl == null) {
            _logger.error((Object)("Error, during ServiceLocator creation! Cannot find ServiceEndpoint data for VC with GUID: " + serverGuid));
            return null;
        }
        ServiceDirectory.ServiceEndpoint vcEndpoint = this._vcServiceHelper.getServiceEndpoint(serverGuid);
        if (vcEndpoint == null) {
            _logger.error((Object)("Error, during ServiceLocator creation! Cannot find ServiceEndpoint data for VC with GUID: " + serverGuid));
            return null;
        }
        ServiceLocator vcLocator = new ServiceLocator(serverGuid, vcEndpointUrl, credential, vcEndpoint.sslThumbprint);
        return vcLocator;
    }

    private String getVcEndpointUrl(String serverGuid) {
        ServiceRegistration.Endpoint endpoint = null;
        try {
            ServiceRegistration.Info vcServiceInfo = this._lookupService.find(serverGuid);
            endpoint = LookupUtil.getEndpoint((ServiceRegistration.Info)vcServiceInfo, (String)VC_SERVICE_ENDPOINT_TYPE_ID);
        }
        catch (EntryNotFoundFault lsFault) {
            return null;
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Url retrived from lookup service : " + endpoint.getUrl().toString()));
        }
        return endpoint.getUrl().toString();
    }

    private static String extractUsernameFromUpn(String ownerId) {
        if (ownerId == null) {
            return null;
        }
        String username = Utils.getStringBeforeSubStr((String)ownerId, (String)UPN_SEPARATOR);
        return username;
    }

    private SamlToken getBearerToken(SsoDomain ssoDomain) {
        SamlTokenEx tokenEx;
        if (ssoDomain == null) {
            ssoDomain = SsoDomainHelper.getLocal();
        }
        if ((tokenEx = AuthSessionUtil.getSsoTokenEx((SsoDomain)ssoDomain)) == null) {
            throw new IllegalStateException("Can't find a token for domain " + ssoDomain);
        }
        SamlToken hokToken = tokenEx.getToken();
        Date now = new Date();
        long bearerLifetimeMs = hokToken.getExpirationTime().getTime() - now.getTime();
        long bearerLifetimeS = bearerLifetimeMs / 1000L;
        SamlToken bearerToken = null;
        try {
            TokenProperties tokenProps = new TokenProperties(bearerLifetimeS, hokToken.isDelegable(), hokToken.isRenewable());
            SamlTokenEx bearerTokenEx = this._ssoService.acquireBearerTokenFromToken(ssoDomain, tokenEx.getIssuerSsoDomain(), hokToken, tokenProps);
            bearerToken = bearerTokenEx.getToken();
        }
        catch (SsoServiceException e) {
            _logger.error((Object)"Could not construct a bearer token.", (Throwable)e);
        }
        return bearerToken;
    }

    static final class Context {
        private final String _serviceId;
        private final SsoDomain _targetSsoDomain;
        private final SsoDomain _sourceSsoDomain;
        private final SamlTokenEx _tokenEx;
        private final String _delegeeServiceId;
        private volatile int _hashCode;

        public Context(String serviceId, SsoDomain targetSsoDomain, SsoDomain sourceSsoDomain, SamlTokenEx tokenEx, String delegeeServiceId) {
            Objects.requireNonNull(serviceId, "The serviceId argument cannot be null!");
            if (tokenEx != null) {
                Objects.requireNonNull(targetSsoDomain, "The target sso domain argument cannot be null!");
                Objects.requireNonNull(sourceSsoDomain, "The source sso domain argument cannot be null!");
            }
            this._serviceId = serviceId;
            this._targetSsoDomain = targetSsoDomain;
            this._sourceSsoDomain = sourceSsoDomain;
            this._tokenEx = tokenEx;
            this._delegeeServiceId = delegeeServiceId;
        }

        public String serviceId() {
            return this._serviceId;
        }

        public SsoDomain targetSsoDomain() {
            return this._targetSsoDomain;
        }

        public SsoDomain sourceSsoDomain() {
            return this._sourceSsoDomain;
        }

        public SamlTokenEx tokenEx() {
            return this._tokenEx;
        }

        public String delegeeServiceId() {
            return this._delegeeServiceId;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Context)) {
                return false;
            }
            Context otherContext = (Context)other;
            if (!this._serviceId.equals(otherContext._serviceId)) {
                return false;
            }
            if (!Objects.equals(this._targetSsoDomain, otherContext._targetSsoDomain)) {
                return false;
            }
            if (!Objects.equals(this._sourceSsoDomain, otherContext._sourceSsoDomain)) {
                return false;
            }
            if (!Objects.equals(this._tokenEx, otherContext._tokenEx)) {
                return false;
            }
            return Objects.equals(this._delegeeServiceId, otherContext._delegeeServiceId);
        }

        public int hashCode() {
            int result = this._hashCode;
            if (result == 0) {
                String targetSsoDomainId = this._targetSsoDomain == null ? null : this._targetSsoDomain.getId();
                String sourceSsoDomainId = this._sourceSsoDomain == null ? null : this._sourceSsoDomain.getId();
                String tokenId = this._tokenEx == null ? null : this._tokenEx.getToken().getId();
                this._hashCode = result = Objects.hash(this._serviceId, targetSsoDomainId, sourceSsoDomainId, tokenId, this._delegeeServiceId);
            }
            return result;
        }
    }

    final class Loader
    extends CacheLoader<Context, ServiceLocator> {
        Loader() {
        }

        public ServiceLocator load(Context context) throws Exception {
            ServiceLocator.Credential credential = null;
            if (context.tokenEx() == null) {
                SamlToken bearerToken = VcServiceLocatorFactory.this.getBearerToken(context.targetSsoDomain());
                if (bearerToken == null) {
                    return INVALID_LOCATOR;
                }
                _logger.info((Object)("Created a bearer token " + bearerToken.getId() + " for VC " + context.serviceId()));
                credential = new ServiceLocator.SAMLCredential(bearerToken.toXml());
            } else {
                credential = VcServiceLocatorFactory.this.createSamlCredential(context.targetSsoDomain(), context.sourceSsoDomain(), context.tokenEx(), context.delegeeServiceId());
            }
            ServiceLocator vcLocator = VcServiceLocatorFactory.this.createVcLocatorWithCredential(context.serviceId(), credential);
            if (vcLocator == null) {
                return INVALID_LOCATOR;
            }
            return vcLocator;
        }
    }
}

