/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vm.migration.impl;

import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.mutation.OperationResult;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.util.Pair;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.common.ServiceLocatorFactory;
import com.vmware.vsphere.client.vm.migration.LocationSpec;
import com.vmware.vsphere.client.vm.migration.LocationSpecPair;
import com.vmware.vsphere.client.vm.storageDrs.impl.StorageRecommendationsManager;
import com.vmware.vsphere.client.vm.util.Util;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class VmRelocator {
    private static Log _logger = LogFactory.getLog(VmRelocator.class);

    VmRelocator() {
    }

    public static OperationResult relocateVm(ManagedObjectReference entity, LocationSpec spec, DataService dataService, ServiceLocatorFactory serviceLocatorFactory) {
        OperationResult operationResult = new OperationResult();
        operationResult.entity = entity;
        String errorMsg = null;
        if (entity == null) {
            operationResult.error = Util.getInvalidEntityFault();
            return operationResult;
        }
        try {
            if (!(spec instanceof LocationSpec)) {
                errorMsg = Util.getLocalizedString("error.locationSpecRequired");
                throw new IllegalArgumentException(errorMsg);
            }
            VirtualMachine vm = (VirtualMachine)ManagedObjectUtil.getManagedObject((ManagedObjectReference)entity);
            LocationSpec locationSpec = spec;
            ManagedObjectReference taskRef = null;
            if (!ArrayUtils.isEmpty((Object[])locationSpec.cancelRecommendations)) {
                VmRelocator.cancelDRSRecommendations(entity, locationSpec);
            }
            if (VmRelocator.isCancelRecommendationOnlySpec(locationSpec)) {
                return operationResult;
            }
            LocationSpecPair locationSpecPair = new LocationSpecPair();
            locationSpecPair.entity = entity;
            locationSpecPair.spec = locationSpec;
            operationResult.result = new Pair((Object)"isCrossVcMigration", (Object)Util.populateSpecWithXvcInfo(locationSpecPair, true, dataService, serviceLocatorFactory));
            Util.keepCurrentVmPoolIfPossible(locationSpecPair, dataService);
            if (locationSpec.relocateSpec == null) {
                errorMsg = Util.getLocalizedString("error.relocateSpecNotProvided");
                throw new IllegalArgumentException(errorMsg);
            }
            taskRef = !ArrayUtils.isEmpty((Object[])locationSpec.recommendations) ? VmRelocator.relocateViaDrs(entity, locationSpec) : vm.relocate(locationSpec.relocateSpec, locationSpec.priority);
            operationResult.task = taskRef;
        }
        catch (Exception ex) {
            _logger.error((Object)("Exception occurred during relocation of VM " + ManagedObjectUtil.morefToString((ManagedObjectReference)entity)), (Throwable)ex);
            operationResult.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return operationResult;
    }

    private static ManagedObjectReference relocateViaDrs(ManagedObjectReference vm, LocationSpec spec) throws Exception {
        StorageRecommendationsManager sdrsMgr = new StorageRecommendationsManager(vm);
        ManagedObjectReference retVal = sdrsMgr.applyDatastoreRecommendations(spec.recommendations);
        return retVal;
    }

    private static void cancelDRSRecommendations(ManagedObjectReference vm, LocationSpec spec) throws Exception {
        StorageRecommendationsManager sdrsMgr = new StorageRecommendationsManager(vm);
        sdrsMgr.cancelDatastoreRecommendations(spec.cancelRecommendations, true);
    }

    private static boolean isCancelRecommendationOnlySpec(LocationSpec spec) {
        return spec.relocateSpec == null && ArrayUtils.isEmpty((Object[])spec.recommendations) && !ArrayUtils.isEmpty((Object[])spec.cancelRecommendations);
    }
}

