/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.perfstats.impl;

import com.vmware.vim.binding.vim.PerformanceManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vsphere.client.data.util.DataUtil;
import com.vmware.vsphere.client.perfstats.Metric;
import com.vmware.vsphere.client.perfstats.PerformanceManagerService;
import com.vmware.vsphere.client.perfstats.impl.model.EntityMetricsRequest;
import com.vmware.vsphere.client.perfstats.impl.model.VcMetricsRequest;
import com.vmware.vsphere.client.perfstats.impl.util.CounterInfoUtil;
import com.vmware.vsphere.client.perfstats.impl.util.PerfUtil;
import com.vmware.vsphere.client.perfstats.impl.util.QueryBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;

public class PerformanceManagerServiceImpl
implements PerformanceManagerService {
    public ResultSet getStats(Map<ManagedObjectReference, List<Metric>> rawRequests) {
        List<VcMetricsRequest> vcRequests = PerformanceManagerServiceImpl.groupRequestsByVc(rawRequests);
        ArrayList<ResultItem> resultsForAllVcs = new ArrayList<ResultItem>();
        for (VcMetricsRequest vcRequest : vcRequests) {
            PerformanceManager perfManager = PerfUtil.getPerfManager(vcRequest.vcUid);
            if (perfManager == null) continue;
            PerformanceManager.QuerySpec[] querySpecs = QueryBuilder.buildQuerySpecs(vcRequest);
            PerformanceManager.EntityMetricBase[] entityMetrics = perfManager.queryStats(querySpecs);
            List<ResultItem> resultForVc = PerformanceManagerServiceImpl.toResultItems(entityMetrics, vcRequest.vcUid);
            resultsForAllVcs.addAll(resultForVc);
        }
        return DataUtil.toResultSet(resultsForAllVcs);
    }

    private static List<VcMetricsRequest> groupRequestsByVc(Map<ManagedObjectReference, List<Metric>> requestedMetrics) {
        HashMap<String, VcMetricsRequest> vcIdToVcRequestMap = new HashMap<String, VcMetricsRequest>();
        for (ManagedObjectReference entity : requestedMetrics.keySet()) {
            VcMetricsRequest vcRequest = (VcMetricsRequest)vcIdToVcRequestMap.get(entity.getServerGuid());
            if (vcRequest == null) {
                String vcUid = entity.getServerGuid();
                vcRequest = new VcMetricsRequest(vcUid, new ArrayList<EntityMetricsRequest>());
                vcIdToVcRequestMap.put(vcUid, vcRequest);
            }
            EntityMetricsRequest entityRequest = new EntityMetricsRequest(entity, requestedMetrics.get(entity));
            vcRequest.entityRequests.add(entityRequest);
        }
        return new ArrayList<VcMetricsRequest>(vcIdToVcRequestMap.values());
    }

    private static List<ResultItem> toResultItems(PerformanceManager.EntityMetricBase[] entityMetrics, String vcUid) {
        if (ArrayUtils.isEmpty((Object[])entityMetrics)) {
            return new ArrayList<ResultItem>();
        }
        ArrayList<ResultItem> resultItemsToReturn = new ArrayList<ResultItem>();
        PerformanceManager perfManager = PerfUtil.getPerfManager(vcUid);
        for (PerformanceManager.EntityMetricBase entityMetric : entityMetrics) {
            PerformanceManager.MetricSeries[] returnedMetrics = ((PerformanceManager.EntityMetric)entityMetric).getValue();
            ArrayList<PropertyValue> props = new ArrayList<PropertyValue>();
            for (PerformanceManager.MetricSeries metricSeries : returnedMetrics) {
                PerformanceManager.IntSeries metricValue = (PerformanceManager.IntSeries)metricSeries;
                PropertyValue pv = new PropertyValue();
                int counterId = metricValue.getId().getCounterId();
                pv.propertyName = CounterInfoUtil.getNameById(perfManager, vcUid, counterId);
                PerformanceManagerServiceImpl.filterLatestValidValue(metricValue);
                pv.value = metricValue;
                props.add(pv);
            }
            ResultItem resultItem = new ResultItem();
            resultItem.properties = props.toArray(new PropertyValue[props.size()]);
            resultItem.resourceObject = ((PerformanceManager.EntityMetric)entityMetric).getEntity();
            resultItemsToReturn.add(resultItem);
        }
        return resultItemsToReturn;
    }

    private static void filterLatestValidValue(PerformanceManager.IntSeries metricValue) {
        long[] values = metricValue.value;
        long[] latestValidValue = new long[]{0L};
        for (int i = values.length - 1; i >= 0; --i) {
            if (values[i] == -1L || values[i] == 0L) continue;
            latestValidValue[0] = values[i];
            break;
        }
        metricValue.value = latestValidValue;
    }
}

