/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.rp;

import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.ResourcePool;
import com.vmware.vim.binding.vim.VirtualApp;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.mutation.ValidationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.h5.rp.CreateResourcePoolNameSpec;
import com.vmware.vsphere.client.h5.rp.util.ResourcePoolStringUtil;
import org.apache.commons.lang3.StringUtils;

public class CreateResourcePoolMutationProvider
implements MutationProvider {
    private static final String NAME_PROPERTY = "name";
    private static final String ROOT_RP_PROPERTY = "resourcePool";
    private static final String PARENT_RP_PROPERTY = "parent";
    private static final String DUPLICATE_RP_NAME_ERROR_KEY = "error.resourcePoolNameExists";
    private final QueryServiceFactory _queryServiceFactory;

    public CreateResourcePoolMutationProvider(QueryServiceFactory queryServiceFactory) {
        this._queryServiceFactory = queryServiceFactory;
    }

    public ValidationResult validate(ManagedObjectReference parentRef, CreateResourcePoolNameSpec spec) {
        if (StringUtils.isEmpty((CharSequence)spec.name)) {
            throw new IllegalArgumentException("spec.name can't be null or empty");
        }
        if (!(ManagedObjectUtil.isOfType((ManagedObjectReference)parentRef, ClusterComputeResource.class) || ManagedObjectUtil.isOfType((ManagedObjectReference)parentRef, HostSystem.class) || ManagedObjectUtil.isOfType((ManagedObjectReference)parentRef, ResourcePool.class) || ManagedObjectUtil.isOfType((ManagedObjectReference)parentRef, VirtualApp.class))) {
            throw new IllegalArgumentException("Invalid resource pool parent type");
        }
        ValidationResult result = new ValidationResult();
        result.entity = parentRef;
        if (this.hasChildRpWithName(parentRef, spec.name)) {
            result.result = ResourcePoolStringUtil.getString(DUPLICATE_RP_NAME_ERROR_KEY);
        }
        return result;
    }

    private boolean hasChildRpWithName(ManagedObjectReference parentRef, String childRpName) {
        ManagedObjectReference parentRpRef;
        QueryService queryService = this._queryServiceFactory.getQueryService();
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)parentRef, ClusterComputeResource.class) || ManagedObjectUtil.isOfType((ManagedObjectReference)parentRef, HostSystem.class)) {
            ResultSet rootRpResultSet = queryService.select(new String[]{ROOT_RP_PROPERTY}).from(new String[]{parentRef.getType()}).where("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)parentRef).fetch();
            if (rootRpResultSet.getItems().isEmpty()) {
                throw new IllegalStateException("Could not find root resource pool");
            }
            parentRpRef = (ManagedObjectReference)((ResourceItem)rootRpResultSet.getItems().get(0)).getPropertyValues().get(0);
        } else {
            parentRpRef = parentRef;
        }
        ResultSet childRpWithNameResultSet = queryService.select(new String[]{NAME_PROPERTY}).from(new String[]{"AnyResourcePool"}).where(LogicalOperator.AND, new PropertyPredicate[]{new PropertyPredicate(PARENT_RP_PROPERTY, PropertyPredicate.ComparisonOperator.EQUAL, (Object)parentRpRef), new PropertyPredicate(NAME_PROPERTY, PropertyPredicate.ComparisonOperator.EQUAL, (Object)childRpName)}).fetch();
        return !childRpWithNameResultSet.getItems().isEmpty();
    }
}

