/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.rp;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.mutation.OperationResult;
import com.vmware.vise.core.model.mutation.ValidationResult;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.mutation.MutationService;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.util.QueryUtil;
import com.vmware.vsphere.client.h5.rp.spec.MoveResourcePoolSpec;
import com.vmware.vsphere.client.mixed.ManagedEntityMoveSpec;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang3.ArrayUtils;

public class MoveResourcePoolMutationProvider
implements MutationProvider {
    private final DataService _dataService;
    private final MutationService _mutationService;

    public MoveResourcePoolMutationProvider(DataService _dataService, MutationService mutationService) {
        this._dataService = _dataService;
        this._mutationService = mutationService;
    }

    public OperationResult apply(ManagedObjectReference targetLocation, MoveResourcePoolSpec spec) {
        ManagedEntityMoveSpec managedEntityMoveSpec = new ManagedEntityMoveSpec();
        managedEntityMoveSpec.entities = spec.entities;
        return this._mutationService.apply((Object)targetLocation, (Object)managedEntityMoveSpec);
    }

    public ValidationResult validate(ManagedObjectReference targetLocation, MoveResourcePoolSpec spec) {
        Validate.notNull((Object)spec);
        Validate.notNull((Object)spec.entities);
        ValidationResult validationResult = new ValidationResult();
        ObjectIdentityConstraint targetLocationIdentityConstraint = QueryUtil.createObjectIdentityConstraint((Object)targetLocation);
        Constraint[] sourceEntitiesObjectIdentityContsraint = new Constraint[spec.entities.length];
        for (int i = 0; i < spec.entities.length; ++i) {
            sourceEntitiesObjectIdentityContsraint[i] = QueryUtil.createObjectIdentityConstraint((Object)spec.entities[i]);
        }
        CompositeConstraint sourceEntitiesConstraint = QueryUtil.createCompositeConstraint((Constraint[])sourceEntitiesObjectIdentityContsraint, (Conjoiner)Conjoiner.OR);
        CompositeConstraint constraint = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{targetLocationIdentityConstraint, QueryUtil.createRelationalConstraint((String)"ancestorRp", (Constraint)sourceEntitiesConstraint, (Boolean)false, (String)targetLocation.getType())}, (Conjoiner)Conjoiner.AND);
        QuerySpec querySpec = new QuerySpec();
        querySpec.resourceSpec = QueryUtil.createEmptyResourceSpec();
        querySpec.resourceSpec.constraint = constraint;
        RequestSpec requestSpec = new RequestSpec();
        requestSpec.querySpec = new QuerySpec[]{querySpec};
        Response response = this._dataService.getData(requestSpec);
        validationResult.result = ArrayUtils.isEmpty((Object[])response.resultSet) || response.resultSet[0].totalMatchedObjectCount == 0;
        return validationResult;
    }
}

