/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.automatic.plugin.registration;

import com.vmware.automatic.plugin.registration.PluginCmdInstanceCreator;
import com.vmware.automatic.plugin.registration.actions.Action;
import com.vmware.automatic.plugin.registration.commands.PluginCmd;
import com.vmware.automatic.plugin.registration.services.PrintHelper;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class PluginRegistrationEntryPoint {
    private final PluginCmdInstanceCreator pluginCmdInstanceCreator;
    private final CommandLineParser parser;
    private final String[] cmdLineArguments;
    private static final String ACTION_ARG = "action";
    private static final String ARGS_DELIMITER = "-";

    public PluginRegistrationEntryPoint(String[] cmdLineArguments, PluginCmdInstanceCreator pluginCmdInstanceCreator, CommandLineParser parser) {
        this.cmdLineArguments = cmdLineArguments;
        this.pluginCmdInstanceCreator = pluginCmdInstanceCreator;
        this.parser = parser;
    }

    public void execute() throws Exception {
        CommandLine commandLine;
        Options options = new Options();
        options.addOption(Option.builder(ACTION_ARG).hasArg().required().desc("Action to perform.").hasArg().argName(String.format("%s, %s, %s, %s", new Object[]{Action.REGISTER_PLUGIN, Action.UNREGISTER_PLUGIN, Action.UPDATE_PLUGIN, Action.IS_PLUGIN_REGISTERED})).build());
        try {
            commandLine = this.parser.parse(options, this.extractActionArg(this.cmdLineArguments), true);
        }
        catch (ParseException e) {
            PrintHelper.printHelp(options, e.getMessage());
            throw new ParseException(e.getMessage());
        }
        String action = commandLine.getOptionValue(ACTION_ARG);
        PluginCmd pluginCmd = this.pluginCmdInstanceCreator.getInstance(action);
        pluginCmd.execute(this.cmdLineArguments);
    }

    private String[] extractActionArg(String[] cmdLineArguments) {
        if (cmdLineArguments != null) {
            for (int i = 0; i < cmdLineArguments.length; ++i) {
                if (!ARGS_DELIMITER.concat(ACTION_ARG).equals(cmdLineArguments[i])) continue;
                if (cmdLineArguments.length > i + 1 && !cmdLineArguments[i + 1].startsWith(ARGS_DELIMITER)) {
                    return new String[]{cmdLineArguments[i], cmdLineArguments[i + 1]};
                }
                return new String[]{cmdLineArguments[i]};
            }
        }
        return cmdLineArguments;
    }
}

