/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.automatic.plugin.registration.services;

import com.vmware.automatic.plugin.registration.services.SslTrustStrategy;
import com.vmware.vim25.InvalidLocaleFaultMsg;
import com.vmware.vim25.InvalidLoginFaultMsg;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.ServiceContent;
import com.vmware.vim25.VimPortType;
import com.vmware.vim25.VimService;
import java.io.Console;
import java.io.IOException;
import java.util.Map;
import javax.net.ssl.SSLHandshakeException;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.WebServiceException;
import org.apache.commons.cli.CommandLine;

public class ConnectionService {
    private static final ManagedObjectReference SVC_INST_REF = new ManagedObjectReference();
    private static final String SVC_INST_NAME = "ServiceInstance";
    private final VimService vimService;
    private final SslTrustStrategy trustStrategy;
    private VimPortType vimPort;
    private ServiceContent serviceContent;
    private ManagedObjectReference extensionManager;
    private boolean isConnected;

    public ConnectionService(VimService vimService, SslTrustStrategy trustStrategy) {
        this.vimService = vimService;
        this.trustStrategy = trustStrategy;
    }

    public void connect(CommandLine commandLine) {
        if (this.isConnected) {
            return;
        }
        String username = commandLine.getOptionValue("u");
        String password = commandLine.getOptionValue("p");
        if (password == null || password.length() == 0) {
            password = this.readPasswordFromStdin();
        }
        String url = commandLine.getOptionValue("url");
        String vcServerThumbprint = commandLine.getOptionValue("vct");
        boolean insecure = commandLine.hasOption("insecure");
        try {
            this.trustStrategy.init(insecure, vcServerThumbprint);
            SVC_INST_REF.setType(SVC_INST_NAME);
            SVC_INST_REF.setValue(SVC_INST_NAME);
            this.vimPort = this.vimService.getVimPort();
            Map ctxt = ((BindingProvider)this.vimPort).getRequestContext();
            ctxt.put("javax.xml.ws.service.endpoint.address", url);
            ctxt.put("javax.xml.ws.session.maintain", true);
            this.serviceContent = this.vimPort.retrieveServiceContent(SVC_INST_REF);
            this.vimPort.login(this.serviceContent.getSessionManager(), username, password, null);
            this.extensionManager = this.serviceContent.getExtensionManager();
            this.isConnected = true;
        }
        catch (InvalidLocaleFaultMsg | InvalidLoginFaultMsg | RuntimeFaultFaultMsg e) {
            String msg = String.format("Error while connecting to vCenter Server SDK <%s>. Please verify the provided arguments are correct: -url: %s, -username: %s, -password: %s", url, url, username, password);
            throw new RuntimeException(msg, e);
        }
        catch (WebServiceException e) {
            if (e.getCause() != null && e.getCause() instanceof SSLHandshakeException) {
                String msg = String.format("Error while connecting to vCenter Server SDK <%s>. \nThis is because your vCenter Server has no valid certificate from a trusted authority. \nTo be able to securely connect to your vCenter server, please provide the server's SHA-1, or SHA-256 thumbprint as command line argument '-vct'.\nIf you want to skip the security checks, use the '-insecure' command line parameter instead.", url);
                throw new RuntimeException(msg);
            }
            if (e.getCause() != null && e.getCause() instanceof IOException) {
                String msg = String.format("Cannot securely connect to vCenter Server SDK <%s>.\nYou probably try to refer your vCenter Server by IP address and it is not listed as a subject alternative name in the server's certificate.\nPlease, try to refer your vCenter Server by its FQDN, not IP address.\nIf you want to skip the security checks, use the '-insecure' command line parameter instead.", url);
                throw new RuntimeException(msg);
            }
            throw e;
        }
    }

    private String readPasswordFromStdin() {
        Console console = System.console();
        if (console != null) {
            char[] password = console.readPassword("Password: ", new Object[0]);
            return String.valueOf(password);
        }
        throw new IllegalStateException("No console detected. Please provide your password via cmd line argument '-p'.");
    }

    public void disconnect(CommandLine commandLine) {
        if (!this.isConnected) {
            return;
        }
        String url = commandLine.getOptionValue("url");
        try {
            this.getVimPort().logout(this.serviceContent.getSessionManager());
        }
        catch (RuntimeFaultFaultMsg e) {
            String msg = String.format("Error while disconnecting from vCenter Server SDK <%s>.", url);
            throw new RuntimeException(msg, e);
        }
        finally {
            this.isConnected = false;
        }
    }

    public VimPortType getVimPort() {
        if (this.vimPort == null) {
            throw new RuntimeException("No Connection to vCenter Server established");
        }
        return this.vimPort;
    }

    public ManagedObjectReference getExtensionManager() {
        if (this.extensionManager == null) {
            throw new RuntimeException("No connection to vCenter Server established.");
        }
        return this.extensionManager;
    }
}

