/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.automatic.plugin.registration.services;

import com.vmware.automatic.plugin.registration.services.InsecureHostnameVerifier;
import com.vmware.automatic.plugin.registration.services.ThumbprintTrustManager;
import com.vmware.automatic.plugin.registration.services.TrustAllCertificatesTrustManager;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.TrustManager;

public class SslTrustStrategy {
    void init(boolean insecure, String serverThumbprint) {
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            SSLSessionContext sslsc = sc.getServerSessionContext();
            sslsc.setSessionTimeout(0);
            sc.init(null, this.getTrustManager(insecure, serverThumbprint), null);
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier(new InsecureHostnameVerifier(insecure));
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            System.out.println("Error while creating SSLContext");
            throw new RuntimeException(e);
        }
    }

    private TrustManager[] getTrustManager(boolean insecure, String serverThumbprint) {
        TrustManager[] trustManagerArray;
        if (insecure) {
            return new TrustManager[]{new TrustAllCertificatesTrustManager()};
        }
        if (serverThumbprint == null || serverThumbprint.length() == 0) {
            trustManagerArray = null;
        } else {
            TrustManager[] trustManagerArray2 = new TrustManager[1];
            trustManagerArray = trustManagerArray2;
            trustManagerArray2[0] = new ThumbprintTrustManager(serverThumbprint);
        }
        return trustManagerArray;
    }
}

