/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.automatic.plugin.registration.services;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Locale;
import javax.net.ssl.X509TrustManager;

public class ThumbprintTrustManager
implements X509TrustManager {
    private static final String[] ALGORITHM_NAMES = new String[]{"SHA-1", "SHA-256"};
    private final String expectedThumbprint;

    ThumbprintTrustManager(String expectedThumbprint) {
        this.expectedThumbprint = expectedThumbprint.replaceAll("\\s+|:", "");
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509Certificates, String s) {
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        for (String algorithmName : ALGORITHM_NAMES) {
            MessageDigest md;
            try {
                md = MessageDigest.getInstance(algorithmName);
            }
            catch (NoSuchAlgorithmException e) {
                throw new AssertionError((Object)e);
            }
            md.update(x509Certificates[0].getEncoded());
            String certThumb = ThumbprintTrustManager.hexify(md.digest());
            if (!this.expectedThumbprint.equalsIgnoreCase(certThumb)) continue;
            return;
        }
        throw new CertificateException("Host certificate thumbprint did not match the provided value.");
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }

    private static String hexify(byte[] bytes) {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        StringBuffer buf = new StringBuffer(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            buf.append(hexDigits[(bytes[i] & 0xF0) >> 4]);
            buf.append(hexDigits[bytes[i] & 0xF]);
        }
        return buf.toString().toUpperCase(Locale.ENGLISH);
    }
}

