/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.autodeploy.config.legacy.util;

import com.vmware.vim.binding.vim.Extension;
import com.vmware.vim.binding.vim.ExtensionManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.client.http.ThumbprintVerifier;
import com.vmware.vim.vmomi.client.http.impl.ThumbprintTrustManager;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.mks.util.SslThumbprintVerifier;
import com.vmware.vise.vim.commons.vcservice.VcService;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.ArrayList;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;

public class Util {
    private static final Log _logger = LogFactory.getLog(Util.class);
    private static final String PARAM_SOCKET_TIMEOUT = "http.socket.timeout";
    private static final Integer SOCKET_TIMEOUT_MILLIS = new Integer(30000);
    private static final String VIM_SESSION_KEY = "vimSessionKey";

    public static String getVcServerHostname(String serverGuid) {
        String serviceUrl = "";
        try {
            VcService sourceVcServer = VimSessionUtil.getService((String)serverGuid);
            serviceUrl = VcServiceUtil.getServiceUrl((VcService)sourceVcServer);
            URL vcServerUrl = new URL(serviceUrl);
            return vcServerUrl.getHost();
        }
        catch (MalformedURLException e) {
            String errorMessage = Util.getLocalizedString("Error.malformedServiceUrl", Util.getVcServerHostname(serverGuid));
            _logger.error((Object)errorMessage);
            return null;
        }
    }

    public static ExtensionManager getExtensionManager(String serverGuid) {
        if (serverGuid == null) {
            _logger.error((Object)"Cannot get extension manager based on a null server GUID");
            return null;
        }
        try {
            VcService sourceVcServer = VimSessionUtil.getService((String)serverGuid);
            ManagedObjectReference emRef = sourceVcServer.getServiceInstanceContent().extensionManager;
            return (ExtensionManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)emRef);
        }
        catch (Exception e) {
            String errorMessage = Util.getLocalizedString("Error.extensionManagerNotFound", Util.getVcServerHostname(serverGuid));
            _logger.error((Object)errorMessage);
            return null;
        }
    }

    private static String getLocalizedString(String key, String ... parameters) {
        return ResourceUtil.getString((String)"autodeployservice", (String)key, (String[])parameters, (ClassLoader)Util.class.getClassLoader());
    }

    private static HttpClient getHttpClient(URL serviceUrl, String thumbprint, KeyStore truststore) {
        DefaultHttpClient client = new DefaultHttpClient();
        if (thumbprint == null) {
            return client;
        }
        SSLSocketFactory factory = Util.getSSLSocketFactory(thumbprint, truststore);
        Scheme scheme = new Scheme(serviceUrl.getProtocol(), (SocketFactory)factory, serviceUrl.getPort());
        client.getConnectionManager().getSchemeRegistry().register(scheme);
        return client;
    }

    private static SSLSocketFactory getSSLSocketFactory(String thumbprint, KeyStore truststore) {
        try {
            SSLSocketFactory factory = null;
            if (truststore != null) {
                factory = new SSLSocketFactory(truststore);
            } else {
                SSLContext context = SSLContext.getInstance("TLS");
                SslThumbprintVerifier thumbVerifier = new SslThumbprintVerifier();
                thumbVerifier.setThumbprint(thumbprint);
                ThumbprintTrustManager manager = new ThumbprintTrustManager(null, (ThumbprintVerifier)thumbVerifier);
                TrustManager[] managers = new TrustManager[]{manager};
                context.init(null, managers, null);
                factory = new SSLSocketFactory(context);
                factory.setHostnameVerifier((X509HostnameVerifier)new ThumbprintTrustManager.HostnameVerifier(manager));
            }
            return factory;
        }
        catch (GeneralSecurityException exception) {
            _logger.error((Object)"Failure in initializing SecurityContext.", (Throwable)exception);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String executeRequest(URL serviceUrl, String thumbprint, String vimSessionKey, KeyStore truststore) {
        HttpClient client = null;
        String responseBody = null;
        URI requestUri = null;
        try {
            client = Util.getHttpClient(serviceUrl, thumbprint, truststore);
            if (vimSessionKey != null) {
                ArrayList<BasicNameValuePair> urlParameters = new ArrayList<BasicNameValuePair>();
                urlParameters.add(new BasicNameValuePair(VIM_SESSION_KEY, vimSessionKey));
                String query = URLEncodedUtils.format(urlParameters, (String)"UTF-8");
                requestUri = new URI(serviceUrl.getProtocol(), serviceUrl.getUserInfo(), serviceUrl.getHost(), serviceUrl.getPort(), serviceUrl.getPath(), query, null);
            } else {
                requestUri = new URI(serviceUrl.getProtocol(), serviceUrl.getUserInfo(), serviceUrl.getHost(), serviceUrl.getPort(), serviceUrl.getPath(), null, null);
            }
            _logger.debug((Object)("Executing requestUri: " + requestUri.toString()));
            HttpGet method = new HttpGet(requestUri);
            method.setHeader("Accept", "text/xml");
            method.setHeader("Content-Type", "text/xml");
            method.getParams().setParameter(PARAM_SOCKET_TIMEOUT, (Object)SOCKET_TIMEOUT_MILLIS);
            BasicResponseHandler handler = new BasicResponseHandler();
            responseBody = (String)client.execute((HttpUriRequest)method, (ResponseHandler)handler);
        }
        catch (URISyntaxException exception) {
            _logger.error((Object)"Executing requestUri: ", (Throwable)exception);
        }
        catch (ClientProtocolException exception) {
            _logger.error((Object)"Executing requestUri: ", (Throwable)exception);
        }
        catch (SocketTimeoutException exception) {
            _logger.error((Object)"Executing requestUri: ", (Throwable)exception);
        }
        catch (IOException exception) {
            _logger.error((Object)"Executing requestUri: ", (Throwable)exception);
        }
        finally {
            if (client != null) {
                client.getConnectionManager().shutdown();
            }
        }
        return responseBody;
    }

    public static Extension.ServerInfo getServerInfo(String serverGuid, String extensionKey) {
        Extension.ServerInfo[] extensionList;
        ExtensionManager extMngr = Util.getExtensionManager(serverGuid);
        if (extMngr == null) {
            return null;
        }
        Extension extension = extMngr.findExtension(extensionKey);
        if (extension == null) {
            String errorMessage = Util.getLocalizedString("Error.extensionNotFound", extensionKey, Util.getVcServerHostname(serverGuid));
            _logger.error((Object)errorMessage);
            return null;
        }
        for (Extension.ServerInfo si : extensionList = extension.getServer()) {
            if (!si.getType().equals("com.vmware.vim.viClientScripts")) continue;
            return si;
        }
        return null;
    }
}

