/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.autodeploy.imageProfile;

import com.vmware.vim.binding.imagebuilder.pkg.ComponentSpec;
import com.vmware.vim.binding.imagebuilder.pkg.ImageProfile;
import java.util.Calendar;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;

public final class ImageProfileBuilder {
    private String _name;
    private String _vendor;
    private String _author;
    private Calendar _created;
    private Calendar _lastModified;
    private String _description;
    private boolean _readOnly;
    private ComponentSpec[] _vibList;
    private String _acceptanceLevel;
    private int _serialNo;
    private String _profileId;

    public ImageProfileBuilder() {
        this._created = Calendar.getInstance();
        this._lastModified = Calendar.getInstance();
        this._readOnly = false;
        this._profileId = UUID.randomUUID().toString();
    }

    public ImageProfileBuilder(ImageProfile p) {
        this._name = p.name;
        this._vendor = p.vendor;
        this._author = p.author;
        this._created = p.whenCreated;
        this._lastModified = p.whenLastModified;
        this._description = p.description;
        this._readOnly = p.read_only;
        this._vibList = p.viblist;
        this._acceptanceLevel = p.acceptanceLevel;
        this._serialNo = p.serialno;
        this._profileId = p.profileId;
    }

    public ImageProfileBuilder name(String val) {
        this._name = val;
        return this;
    }

    public ImageProfileBuilder vendor(String val) {
        this._vendor = val;
        return this;
    }

    public ImageProfileBuilder author(String val) {
        this._author = val;
        return this;
    }

    public ImageProfileBuilder created(Calendar val) {
        this._created = val;
        return this;
    }

    public ImageProfileBuilder lastModified(Calendar val) {
        this._lastModified = val;
        return this;
    }

    public ImageProfileBuilder description(String val) {
        this._description = val;
        return this;
    }

    public ImageProfileBuilder readOnly(boolean val) {
        this._readOnly = val;
        return this;
    }

    public ImageProfileBuilder vibList(ComponentSpec[] val) {
        this._vibList = val;
        return this;
    }

    public ImageProfileBuilder acceptanceLevel(String val) {
        this._acceptanceLevel = val;
        return this;
    }

    public ImageProfileBuilder serialNo(int val) {
        this._serialNo = val;
        return this;
    }

    public ImageProfileBuilder profileId(String val) {
        this._profileId = val;
        return this;
    }

    public ImageProfile build() {
        ImageProfile result = new ImageProfile();
        result.name = StringUtils.defaultString((String)this._name);
        result.vendor = StringUtils.defaultString((String)this._vendor);
        result.author = StringUtils.defaultString((String)this._author);
        result.whenCreated = this._created == null ? Calendar.getInstance() : this._created;
        result.whenLastModified = this._lastModified == null ? Calendar.getInstance() : this._lastModified;
        result.description = this._description;
        result.read_only = this._readOnly;
        result.viblist = this._vibList;
        result.acceptanceLevel = this._acceptanceLevel;
        result.serialno = this._serialNo;
        result.profileId = this._profileId;
        return result;
    }
}

