/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.autodeploy.impl;

import com.vmware.vim.binding.imagebuilder.DepotManager;
import com.vmware.vim.binding.imagebuilder.pkg.ComponentSpec;
import com.vmware.vim.binding.imagebuilder.pkg.ImageProfile;
import com.vmware.vim.binding.rbd.ScriptBundle;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.client.common.UnexpectedStatusCodeException;
import com.vmware.vim.vmomi.client.exception.ConnectionException;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcServiceConnectionInfo;
import com.vmware.vsphere.client.h5.autodeploy.AutoDeployService;
import com.vmware.vsphere.client.h5.autodeploy.ImageBuilderService;
import com.vmware.vsphere.client.h5.autodeploy.connection.ServiceState;
import com.vmware.vsphere.client.h5.autodeploy.connection.impl.AutoDeployServiceFactory;
import com.vmware.vsphere.client.h5.autodeploy.connection.impl.ImageBuilderServiceFactory;
import com.vmware.vsphere.client.h5.autodeploy.depot.UploadDepotParamsData;
import com.vmware.vsphere.client.h5.autodeploy.scriptBundle.ScriptBundleItem;
import com.vmware.vsphere.client.h5.autodeploy.scriptBundle.ScriptBundleQuerySpec;
import com.vmware.vsphere.client.h5.autodeploy.util.AutoDeployUtil;
import com.vmware.vsphere.client.h5.autodeploy.util.DepotReferenceUtil;
import com.vmware.vsphere.client.h5.autodeploy.util.ImageProfileReferenceUtil;
import com.vmware.vsphere.client.h5.autodeploy.util.VibPackageReferenceUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AutoDeployPropertyProvider
implements PropertyProviderBean {
    private AutoDeployServiceFactory _autoDeployServiceFactory;
    private ImageBuilderServiceFactory _imageBuilderServiceFactory;
    private ThreadPoolExecutor _threadPoolExecutor;
    private static final Log _logger = LogFactory.getLog(AutoDeployPropertyProvider.class);

    public AutoDeployPropertyProvider(AutoDeployServiceFactory autoDeployServiceFactory, ImageBuilderServiceFactory imageBuilderServiceFactory, ThreadPoolExecutor threadPoolExecutor) {
        this._autoDeployServiceFactory = autoDeployServiceFactory;
        this._imageBuilderServiceFactory = imageBuilderServiceFactory;
        this._threadPoolExecutor = threadPoolExecutor;
    }

    @type(value="Folder")
    public UploadDepotParamsData getUploadDepotParamsData(ManagedObjectReference vcRootFolder) {
        UploadDepotParamsData params = new UploadDepotParamsData();
        params.activationId = UUID.randomUUID().toString();
        VcServiceConnectionInfo connectionInfo = VimSessionUtil.getService((String)vcRootFolder.getServerGuid()).getConnectionInfo();
        params.vcSessionKey = connectionInfo.getUserSession().key;
        return params;
    }

    @type(value="Folder")
    public ServiceState getAutodeployServiceState(ManagedObjectReference vcRef) {
        return this.getAutoDeployServiceState(vcRef.getServerGuid());
    }

    @type(value="Folder")
    public ServiceState getImageBuilderServiceState(ManagedObjectReference vcRef) {
        return this.getImageBuilderServiceState(vcRef.getServerGuid());
    }

    @type(value="Folder")
    public ScriptBundleItem[] getAutoDeployVcScriptBundles(ManagedObjectReference vcRootFolder, ScriptBundleQuerySpec querySpec) {
        AutoDeployService autoDeployService;
        ManagedObjectReference[] scriptRefs;
        if (querySpec == null) {
            querySpec = ScriptBundleQuerySpec.defaultQuerySpec();
        }
        if ((scriptRefs = (autoDeployService = this._autoDeployServiceFactory.getService(vcRootFolder.getServerGuid())).getScriptManager().retrieveScriptBundleList()) == null) {
            return new ScriptBundleItem[0];
        }
        ArrayList<Callable<Void>> requests = new ArrayList<Callable<Void>>();
        ScriptBundleItem[] result = new ScriptBundleItem[scriptRefs.length];
        for (int i = 0; i < scriptRefs.length; ++i) {
            ScriptBundleItem scriptBundleItem;
            result[i] = scriptBundleItem = new ScriptBundleItem();
            scriptBundleItem.scriptBundleRef = scriptRefs[i];
            final ScriptBundle scriptBundle = (ScriptBundle)autoDeployService.getManagedObject(scriptRefs[i]);
            requests.add(new Callable<Void>(){

                @Override
                public Void call() {
                    try {
                        ScriptBundle.ScriptBundleMetadata metadata = scriptBundle.getMetadata();
                        if (metadata != null) {
                            scriptBundleItem.name = metadata.getName();
                        }
                    }
                    catch (Exception ex) {
                        _logger.error((Object)("Failed to retrieve ScriptBundleMetadata for " + scriptBundle._getRef()), (Throwable)ex);
                    }
                    return null;
                }
            });
            if (querySpec.retrieveScripts) {
                requests.add(new Callable<Void>(){

                    @Override
                    public Void call() {
                        try {
                            ScriptBundle.ScriptBundleConfig config = scriptBundle.getConfig();
                            if (config != null) {
                                scriptBundleItem.scripts = scriptBundle.getConfig().getScripts();
                            }
                        }
                        catch (Exception ex) {
                            _logger.error((Object)("Failed to retrieve ScriptBundleConfig for " + scriptBundle._getRef()), (Throwable)ex);
                        }
                        return null;
                    }
                });
            }
            if (querySpec.retrieveCreatedTime) {
                requests.add(new Callable<Void>(){

                    @Override
                    public Void call() {
                        try {
                            scriptBundleItem.createdTime = scriptBundle.getCreatedTime();
                        }
                        catch (Exception ex) {
                            _logger.error((Object)("Failed to retrieve createdTime for " + scriptBundle._getRef()), (Throwable)ex);
                        }
                        return null;
                    }
                });
            }
            if (querySpec.retrieveLastModifiedTime) {
                requests.add(new Callable<Void>(){

                    @Override
                    public Void call() {
                        try {
                            scriptBundleItem.lastModifiedTime = scriptBundle.getModifiedTime();
                        }
                        catch (Exception ex) {
                            _logger.error((Object)("Failed to retrieve lastModifiedTime for " + scriptBundle._getRef()), (Throwable)ex);
                        }
                        return null;
                    }
                });
            }
            if (!querySpec.retrieveIsEditable) continue;
            requests.add(new Callable<Void>(){

                @Override
                public Void call() {
                    try {
                        scriptBundleItem.isEditable = scriptBundle.isEditable();
                    }
                    catch (Exception ex) {
                        scriptBundleItem.isEditable = true;
                        _logger.error((Object)("Failed to retrieve isEditable field for " + scriptBundle._getRef()), (Throwable)ex);
                    }
                    return null;
                }
            });
        }
        try {
            this._threadPoolExecutor.invokeAll(requests);
        }
        catch (Exception ex) {
            _logger.error((Object)"Failed to retrieve VC script bundles.", (Throwable)ex);
        }
        return result;
    }

    @type(value="imagebuilder:Depot")
    public Map<String, String[]> getAutodeployVibsDataPerImageProfile(URI depotRef) {
        String vcGuid = DepotReferenceUtil.getVcGuid(depotRef);
        String depotUrl = DepotReferenceUtil.getDepotUrl(depotRef);
        if (vcGuid == null || depotUrl == null) {
            return Collections.emptyMap();
        }
        DepotManager.ImageProfileFilterSpec imageProfileFilterSpec = AutoDeployUtil.createEmptyImageProfileFilterSpec();
        imageProfileFilterSpec.matchDepotUrl = new String[]{depotUrl};
        DepotManager depotManager = this._imageBuilderServiceFactory.getService(vcGuid).getDepotManager();
        ImageProfile[] imageProfiles = depotManager.queryProfiles(imageProfileFilterSpec, Boolean.valueOf(false));
        if (imageProfiles == null) {
            return Collections.emptyMap();
        }
        return this.formatResult(imageProfiles, vcGuid, depotUrl);
    }

    private ServiceState getAutoDeployServiceState(String serverGuid) {
        ServiceState state = new ServiceState();
        state.isActive = true;
        try {
            AutoDeployService autoDeployService = this._autoDeployServiceFactory.getService(serverGuid);
            autoDeployService.getServiceInstance().getContent();
        }
        catch (UnexpectedStatusCodeException e) {
            state.isActive = false;
            state.errorMessage = e.getMessage();
            int statusCode = e.getStatusCode();
            if (statusCode == 503) {
                state.errorMessage = AutoDeployPropertyProvider.getLocalizedString("Error.autodeployServiceDownOrNotResponding");
            }
        }
        catch (ConnectionException ce) {
            state.isActive = false;
            state.errorMessage = AutoDeployPropertyProvider.getLocalizedString("Error.autodeployServiceDownOrNotResponding");
        }
        catch (Exception e) {
            state.isActive = false;
            state.errorMessage = e.getMessage();
        }
        return state;
    }

    private ServiceState getImageBuilderServiceState(String serverGuid) {
        ServiceState state = new ServiceState();
        state.isActive = true;
        try {
            ImageBuilderService imageBuilderService = this._imageBuilderServiceFactory.getService(serverGuid);
            imageBuilderService.getServiceInstance().queryImageBuilder();
        }
        catch (UnexpectedStatusCodeException e) {
            state.isActive = false;
            state.errorMessage = e.getMessage();
            int statusCode = e.getStatusCode();
            state.errorMessage = statusCode == 503 ? AutoDeployPropertyProvider.getLocalizedString("Error.imageBuilderServiceDown") : e.getMessage();
        }
        catch (ConnectionException ce) {
            state.isActive = false;
            state.errorMessage = AutoDeployPropertyProvider.getLocalizedString("Error.imageBuilderServiceNotResponding");
        }
        catch (Exception e) {
            state.isActive = false;
            state.errorMessage = e.getMessage();
        }
        return state;
    }

    private static String getLocalizedString(String key) {
        return ResourceUtil.getString((String)"autodeployservice", (String)key, (ClassLoader)AutoDeployPropertyProvider.class.getClassLoader());
    }

    private Map<String, String[]> formatResult(ImageProfile[] imageProfiles, String vcGuid, String depotUrl) {
        HashMap<String, String[]> vibsPerProfile = new HashMap<String, String[]>();
        for (ImageProfile profile : imageProfiles) {
            ComponentSpec[] vibInfos = profile.getViblist();
            URI imageProfileRef = ImageProfileReferenceUtil.createRef(vcGuid, depotUrl, profile.getProfileId());
            if (vibInfos == null) {
                vibsPerProfile.put(imageProfileRef.toString(), new String[0]);
                continue;
            }
            String[] vibRefs = new String[vibInfos.length];
            for (int i = 0; i < vibInfos.length; ++i) {
                vibRefs[i] = VibPackageReferenceUtil.createRef(vcGuid, vibInfos[i].getGuid()).toString();
            }
            vibsPerProfile.put(imageProfileRef.toString(), vibRefs);
        }
        return vibsPerProfile;
    }
}

