/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.autodeploy.impl;

import com.google.common.base.Preconditions;
import com.vmware.vim.binding.rbd.ScriptBundle;
import com.vmware.vim.binding.rbd.ScriptManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.mutation.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vsphere.client.h5.autodeploy.AutoDeployService;
import com.vmware.vsphere.client.h5.autodeploy.connection.impl.AutoDeployServiceFactory;
import com.vmware.vsphere.client.h5.autodeploy.connection.impl.AutoDeployWaiterService;
import com.vmware.vsphere.client.h5.autodeploy.connection.impl.AutoDeployWaiterServiceFactory;
import com.vmware.vsphere.client.h5.autodeploy.scriptBundle.DeleteScriptBundleSpec;
import com.vmware.vsphere.client.h5.autodeploy.scriptBundle.UploadScriptBundleSpec;
import com.vmware.vsphere.client.h5.autodeploy.util.AutoDeployUtil;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ScriptBundleMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(ScriptBundleMutationProvider.class);
    private static final String SCRIPT_PLUGIN = "script";
    private final AutoDeployServiceFactory _autoDeployServiceFactory;
    private final AutoDeployWaiterServiceFactory _autoDeployWaiterServiceFactory;

    public ScriptBundleMutationProvider(AutoDeployServiceFactory autoDeployServiceFactory, AutoDeployWaiterServiceFactory autoDeployWaiterServiceFactory) {
        this._autoDeployServiceFactory = autoDeployServiceFactory;
        this._autoDeployWaiterServiceFactory = autoDeployWaiterServiceFactory;
    }

    public OperationResult add(UploadScriptBundleSpec spec) {
        String[] scripts;
        OperationResult result = new OperationResult();
        ScriptManager scriptManager = this._autoDeployServiceFactory.getService(spec.vcRootFolder.getServerGuid()).getScriptManager();
        try {
            String encodedContent = Base64.encodeBase64String((byte[])spec.fileContent);
            scripts = scriptManager.validateScriptBundle(encodedContent);
        }
        catch (Exception ex) {
            _logger.warn((Object)"Invalid script bundle file. ", (Throwable)ex);
            result.error = ex;
            return result;
        }
        AutoDeployWaiterService waiterService = this._autoDeployWaiterServiceFactory.getService(spec.vcRootFolder.getServerGuid());
        if (waiterService.getResourceBaseUrl(SCRIPT_PLUGIN, spec.scriptBundleName) != null) {
            _logger.warn((Object)("Script bundle " + spec.scriptBundleName + " already exists. "));
            result.error = new Exception(AutoDeployUtil.getLocalizedString("scriptBundle.upload.bundleAlreadyExists", spec.scriptBundleName));
            return result;
        }
        try {
            waiterService.uploadResource(SCRIPT_PLUGIN, spec.scriptBundleName, spec.fileContent);
            ScriptBundle.ScriptBundleMetadata metadata = new ScriptBundle.ScriptBundleMetadata();
            metadata.name = spec.scriptBundleName;
            ScriptBundle.ScriptBundleConfig config = new ScriptBundle.ScriptBundleConfig();
            config.scripts = scripts;
            result.entity = scriptManager.createScriptBundle(metadata, config);
        }
        catch (Exception ex) {
            _logger.error((Object)"Failed to create script bundle. ", (Throwable)ex);
            result.error = ex;
        }
        return result;
    }

    public OperationResult remove(ManagedObjectReference scriptBundleRef, DeleteScriptBundleSpec spec) {
        Preconditions.checkNotNull((Object)scriptBundleRef, (Object)AutoDeployUtil.getLocalizedString("scriptBundle.remove.nullBundleRefError", new String[0]));
        Preconditions.checkNotNull((Object)scriptBundleRef.getServerGuid(), (Object)AutoDeployUtil.getLocalizedString("scriptBundle.remove.nullServerGuidError", new String[0]));
        OperationResult opResult = new OperationResult();
        opResult.entity = scriptBundleRef;
        try {
            AutoDeployService autoDeployService = this._autoDeployServiceFactory.getService(scriptBundleRef.getServerGuid());
            ScriptManager scriptManager = autoDeployService.getScriptManager();
            ScriptBundle bundle = (ScriptBundle)autoDeployService.getManagedObject(scriptBundleRef);
            scriptManager.removeScriptBundle(bundle.getMetadata().getName());
        }
        catch (Exception ex) {
            _logger.error((Object)"Failed to delete script bundle. ", (Throwable)ex);
            opResult.error = ex;
        }
        return opResult;
    }
}

