/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.autodeploy.impl;

import com.google.common.collect.Sets;
import com.vmware.vim.binding.imagebuilder.DepotManager;
import com.vmware.vim.binding.imagebuilder.fault.NotFound;
import com.vmware.vim.binding.imagebuilder.pkg.ComponentSpec;
import com.vmware.vim.binding.imagebuilder.pkg.VibPackageSpec;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vsphere.client.h5.autodeploy.ImageBuilderService;
import com.vmware.vsphere.client.h5.autodeploy.connection.impl.ImageBuilderServiceFactory;
import com.vmware.vsphere.client.h5.autodeploy.impl.AdDataProviderAdapterBase;
import com.vmware.vsphere.client.h5.autodeploy.impl.DerivedProperty;
import com.vmware.vsphere.client.h5.autodeploy.impl.RelatedProperty;
import com.vmware.vsphere.client.h5.autodeploy.util.CommonReferenceUtil;
import com.vmware.vsphere.client.h5.autodeploy.util.DepotReferenceUtil;
import com.vmware.vsphere.client.h5.autodeploy.util.ImageProfileReferenceUtil;
import com.vmware.vsphere.client.h5.autodeploy.util.VibPackageReferenceUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@type(value="imagebuilder:VibPackage")
public class VibPackageDataProviderAdapter
extends AdDataProviderAdapterBase {
    public static final String NAME_PROPERTY = "name";
    public static final String VERSION_PROPERTY = "version";
    public static final String ACCEPTANCE_LEVEL_PROPERTY = "acceptanceLevel";
    public static final String VENDOR_PROPERTY = "vendor";
    public static final String RELEASE_DATE_PROPERTY = "releaseDate";
    public static final String DESCRIPTION_PROPERTY = "description";
    public static final String RAW_OBJECT_PROPERTY = "rawObject";
    private static final Log _logger = LogFactory.getLog(VibPackageDataProviderAdapter.class);
    private final ImageBuilderServiceFactory _imageBuilderServiceFactory;
    private final ObjectReferenceService _objectReferenceService;

    protected VibPackageInfo[] getEmptyResult() {
        return new VibPackageInfo[0];
    }

    private static boolean shouldHandleConstraintForType(Constraint c) {
        return c.targetType == null || c.targetType.equalsIgnoreCase("imagebuilder:VibPackage");
    }

    private static URI createDepotVibPackageRef(String vcGuid, ComponentSpec vibPackage) {
        String vibPackageGuid = vibPackage.Guid;
        return VibPackageReferenceUtil.createRef(vcGuid, vibPackageGuid);
    }

    public static DepotManager.VibPackageFilterSpec createEmptyVibPackageFilterSpec() {
        return new DepotManager.VibPackageFilterSpec(new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], null, null, null, new String[0], new String[0]);
    }

    private static VibPackageSpec findVibPackageByGuid(VibPackageSpec[] vibPackages, String targetVibPackageGuid) {
        for (VibPackageSpec vibPackage : vibPackages) {
            if (!vibPackage.Guid.equals(targetVibPackageGuid)) continue;
            return vibPackage;
        }
        return null;
    }

    public VibPackageDataProviderAdapter(QueryExecutor queryExecutor, ImageBuilderServiceFactory imageBuilderServiceFactory, ObjectReferenceService objectReferenceService) {
        super(queryExecutor);
        this._imageBuilderServiceFactory = imageBuilderServiceFactory;
        this._objectReferenceService = objectReferenceService;
    }

    @Override
    protected Set<String> initBaseProperties() {
        return Sets.newHashSet((Object[])new String[]{NAME_PROPERTY, VERSION_PROPERTY, ACCEPTANCE_LEVEL_PROPERTY, VENDOR_PROPERTY, RELEASE_DATE_PROPERTY, DESCRIPTION_PROPERTY, RAW_OBJECT_PROPERTY});
    }

    @Override
    protected Map<String, DerivedProperty> initDerivedProperties() {
        HashMap<String, DerivedProperty> result = new HashMap<String, DerivedProperty>();
        return result;
    }

    @Override
    protected Map<String, RelatedProperty> initRelatedProperties() {
        HashMap<String, RelatedProperty> result = new HashMap<String, RelatedProperty>();
        return result;
    }

    @Override
    protected Object[] filterObjects(RelationalConstraint c, Map<String, Object> requestContext) {
        if (!VibPackageDataProviderAdapter.shouldHandleConstraintForType((Constraint)c)) {
            return this.getEmptyResult();
        }
        if ("vibPackages".equals(c.relation)) {
            if (!(c.constraintOnRelatedObject instanceof ObjectIdentityConstraint)) {
                return this.getEmptyResult();
            }
            ObjectIdentityConstraint oic = (ObjectIdentityConstraint)c.constraintOnRelatedObject;
            if (this.isDepotRef(oic.target)) {
                URI depotRef = (URI)oic.target;
                String vcGuid = DepotReferenceUtil.getVcGuid(depotRef);
                String targetDepotUrl = DepotReferenceUtil.getDepotUrl(depotRef);
                ImageBuilderService imageBuilderService = this._imageBuilderServiceFactory.getService(vcGuid);
                DepotManager depotManager = imageBuilderService.getDepotManager();
                return this.getVibPackagesFromDepot(targetDepotUrl, depotManager, vcGuid);
            }
            if (this.isImageProfileRef(oic.target)) {
                VibPackageSpec[] vibList;
                URI imageProfileRef = (URI)oic.target;
                String imageProfileId = ImageProfileReferenceUtil.getImageProfileId(imageProfileRef);
                String vcGuid = ImageProfileReferenceUtil.getVcGuid(imageProfileRef);
                DepotManager.VibPackageFilterSpec filterSpec = VibPackageDataProviderAdapter.createEmptyVibPackageFilterSpec();
                filterSpec.matchImageProfile = new String[]{imageProfileId};
                ImageBuilderService imageBuilderService = this._imageBuilderServiceFactory.getService(vcGuid);
                DepotManager depotManager = imageBuilderService.getDepotManager();
                try {
                    vibList = depotManager.queryPackages(filterSpec);
                }
                catch (NotFound e) {
                    String message = ResourceUtil.getString((String)"autodeployservice", (String)"Error.queryVibsForProfile", (String[])new String[]{imageProfileId}, (ClassLoader)VibPackageDataProviderAdapter.class.getClassLoader());
                    throw new RuntimeException(message, e);
                }
                Object[] result = new VibPackageInfo[vibList.length];
                for (int i = 0; i < vibList.length; ++i) {
                    result[i] = new VibPackageInfo(vcGuid, (ComponentSpec)vibList[i]);
                }
                return result;
            }
            return this.getEmptyResult();
        }
        if ("imageBuilderVibPackages".equals(c.relation)) {
            VibPackageSpec[] vibs;
            if (!(c.constraintOnRelatedObject instanceof ObjectIdentityConstraint)) {
                return this.getEmptyResult();
            }
            ObjectIdentityConstraint oic = (ObjectIdentityConstraint)c.constraintOnRelatedObject;
            if (!(oic.target instanceof ManagedObjectReference)) {
                return this.getEmptyResult();
            }
            String vcGuid = ((ManagedObjectReference)oic.target).getServerGuid();
            ImageBuilderService ib = this._imageBuilderServiceFactory.getService(vcGuid);
            DepotManager dm = ib.getDepotManager();
            DepotManager.VibPackageFilterSpec vibFilter = VibPackageDataProviderAdapter.createEmptyVibPackageFilterSpec();
            try {
                vibs = dm.queryPackages(vibFilter);
            }
            catch (NotFound e) {
                throw new RuntimeException("Error while querying packages", e);
            }
            Object[] result = new VibPackageInfo[vibs == null ? 0 : vibs.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = new VibPackageInfo(vcGuid, (ComponentSpec)vibs[i]);
            }
            return result;
        }
        return this.getEmptyResult();
    }

    @Override
    protected Object[] filterObjects(ObjectIdentityConstraint c, Map<String, Object> requestContext) {
        VibPackageSpec[] vibPackages;
        if (!VibPackageDataProviderAdapter.shouldHandleConstraintForType((Constraint)c)) {
            return this.getEmptyResult();
        }
        if (!this.isVibPackageRef(c.target)) {
            return this.getEmptyResult();
        }
        URI vibPackageRef = (URI)c.target;
        String vcGuid = VibPackageReferenceUtil.getVcGuid(vibPackageRef);
        String targetVibPackageGuid = VibPackageReferenceUtil.getVibPackageGuid(vibPackageRef);
        ImageBuilderService imageBuilderService = this._imageBuilderServiceFactory.getService(vcGuid);
        DepotManager depotManager = imageBuilderService.getDepotManager();
        DepotManager.VibPackageFilterSpec vibPackageFilterSpec = VibPackageDataProviderAdapter.createEmptyVibPackageFilterSpec();
        vibPackageFilterSpec.matchGuid = new String[]{targetVibPackageGuid};
        try {
            vibPackages = depotManager.queryPackages(vibPackageFilterSpec);
        }
        catch (NotFound e) {
            throw new RuntimeException("Error while querying packages", e);
        }
        if (vibPackages == null) {
            return this.getEmptyResult();
        }
        VibPackageSpec targetVibPackage = VibPackageDataProviderAdapter.findVibPackageByGuid(vibPackages, targetVibPackageGuid);
        if (targetVibPackage == null) {
            return this.getEmptyResult();
        }
        return new VibPackageInfo[]{new VibPackageInfo(vcGuid, (ComponentSpec)targetVibPackage)};
    }

    @Override
    protected Object[] filterObjects(CompositeConstraint c, Map<String, Object> requestContext) {
        VibPackageSpec[] packages;
        ArrayList<URI> objectIdentities = VibPackageDataProviderAdapter.unpackMultiObjectIdentityConstraint(c);
        if (objectIdentities == null) {
            return super.filterObjects(c, requestContext);
        }
        if (objectIdentities.size() == 0) {
            return this.getEmptyResult();
        }
        String vcGuid = VibPackageReferenceUtil.getVcGuid(objectIdentities.get(0));
        DepotManager dm = this._imageBuilderServiceFactory.getService(vcGuid).getDepotManager();
        HashSet<String> vibIds = new HashSet<String>();
        for (URI vibUri : objectIdentities) {
            vibIds.add(VibPackageReferenceUtil.getVibPackageGuid(vibUri));
        }
        DepotManager.VibPackageFilterSpec filterSpec = VibPackageDataProviderAdapter.createEmptyVibPackageFilterSpec();
        filterSpec.matchGuid = vibIds.toArray(new String[vibIds.size()]);
        try {
            packages = dm.queryPackages(filterSpec);
        }
        catch (NotFound e) {
            throw new RuntimeException("Error while querying packages", e);
        }
        Object[] result = new VibPackageInfo[vibIds.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new VibPackageInfo(vcGuid, (ComponentSpec)packages[i]);
        }
        return result;
    }

    @Override
    protected Map<String, Object[]> retrieveBaseProperties(Set<String> basePropertyNames, Object[] sourceObjectRefs, Map<String, Object> requestContext) {
        assert (sourceObjectRefs instanceof VibPackageInfo[]);
        VibPackageInfo[] vibPackageInfos = (VibPackageInfo[])sourceObjectRefs;
        HashMap<String, Object[]> valuesByProperty = new HashMap<String, Object[]>();
        for (String basePropertyName : basePropertyNames) {
            Object[] values = new Object[vibPackageInfos.length];
            block19: for (int i = 0; i < vibPackageInfos.length; ++i) {
                ComponentSpec componentSpec = vibPackageInfos[i].vibPackage;
                VibPackageSpec vibPackage = null;
                if (componentSpec instanceof VibPackageSpec) {
                    vibPackage = (VibPackageSpec)componentSpec;
                }
                switch (basePropertyName) {
                    case "name": {
                        values[i] = componentSpec.name;
                        continue block19;
                    }
                    case "version": {
                        values[i] = componentSpec.versionStr;
                        continue block19;
                    }
                    case "acceptanceLevel": {
                        values[i] = vibPackage != null ? vibPackage.acceptanceLevel : "";
                        continue block19;
                    }
                    case "vendor": {
                        values[i] = componentSpec.vendor;
                        continue block19;
                    }
                    case "releaseDate": {
                        values[i] = componentSpec.releaseDateTime;
                        continue block19;
                    }
                    case "description": {
                        values[i] = vibPackage != null ? vibPackage.description : "";
                        continue block19;
                    }
                    case "rawObject": {
                        values[i] = vibPackage != null ? vibPackage : componentSpec;
                        continue block19;
                    }
                    default: {
                        _logger.warn((Object)("Unknown VibPackageSpec property: " + basePropertyName));
                    }
                }
            }
            valuesByProperty.put(basePropertyName, values);
        }
        return valuesByProperty;
    }

    @Override
    protected Object sourceObjectToReference(Object sourceObject) {
        assert (sourceObject instanceof VibPackageInfo);
        VibPackageInfo vibPackageInfo = (VibPackageInfo)sourceObject;
        return VibPackageDataProviderAdapter.createDepotVibPackageRef(vibPackageInfo.vcGuid, vibPackageInfo.vibPackage);
    }

    private VibPackageInfo[] getVibPackagesFromDepot(String depotUrl, DepotManager dm, String vcGuid) {
        VibPackageSpec[] vibPackages;
        DepotManager.VibPackageFilterSpec vibPackageFilterSpec = VibPackageDataProviderAdapter.createEmptyVibPackageFilterSpec();
        vibPackageFilterSpec.matchDepotUrl = new String[]{depotUrl};
        try {
            vibPackages = dm.queryPackages(vibPackageFilterSpec);
        }
        catch (NotFound e) {
            throw new RuntimeException("Error while querying packages", e);
        }
        if (vibPackages == null) {
            return this.getEmptyResult();
        }
        VibPackageInfo[] result = new VibPackageInfo[vibPackages.length];
        for (int i = 0; i < vibPackages.length; ++i) {
            result[i] = new VibPackageInfo(vcGuid, (ComponentSpec)vibPackages[i]);
        }
        return result;
    }

    private boolean isDepotRef(Object object) {
        return CommonReferenceUtil.isReferenceOfType(object, "imagebuilder:Depot", this._objectReferenceService);
    }

    private boolean isImageProfileRef(Object object) {
        return CommonReferenceUtil.isReferenceOfType(object, "imagebuilder:ImageProfile", this._objectReferenceService);
    }

    private boolean isVibPackageRef(Object object) {
        return CommonReferenceUtil.isReferenceOfType(object, "imagebuilder:VibPackage", this._objectReferenceService);
    }

    private static ArrayList<URI> unpackMultiObjectIdentityConstraint(CompositeConstraint cc) {
        if (cc.conjoiner != Conjoiner.OR) {
            return null;
        }
        ArrayList<URI> result = new ArrayList<URI>();
        for (Constraint c : cc.nestedConstraints) {
            if (c instanceof ObjectIdentityConstraint) {
                result.add((URI)((ObjectIdentityConstraint)c).target);
                continue;
            }
            if (c instanceof CompositeConstraint) {
                ArrayList<URI> nestedResult = VibPackageDataProviderAdapter.unpackMultiObjectIdentityConstraint((CompositeConstraint)c);
                if (nestedResult == null) {
                    return null;
                }
                result.addAll(nestedResult);
                continue;
            }
            return null;
        }
        return result;
    }

    private static class VibPackageInfo {
        final String vcGuid;
        final ComponentSpec vibPackage;

        VibPackageInfo(String vcGuid, ComponentSpec vibPackage) {
            this.vcGuid = vcGuid;
            this.vibPackage = vibPackage;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            VibPackageInfo o = (VibPackageInfo)other;
            return this.vcGuid.equals(o.vcGuid) && this.vibPackage.name.equals(o.vibPackage.name);
        }

        public int hashCode() {
            return 17 * this.vcGuid.hashCode() + 31 * this.vibPackage.name.hashCode();
        }
    }
}

