/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.dvportgroup.impl;

import com.vmware.vim.binding.vim.DistributedVirtualSwitch;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPortgroup;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.mutation.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.util.QueryUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.dvportgroup.DvPortGroupDeleteSpec;
import com.vmware.vsphere.client.dvportgroup.DvPortgroupCreateSpec;
import com.vmware.vsphere.client.dvs.api.spec.DvPortgroupApplyRestoreSpec;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DvPortgroupMutationProvider
implements MutationProvider {
    DataService _dataService;
    private static final Log _logger = LogFactory.getLog(DvPortgroupMutationProvider.class);

    public DvPortgroupMutationProvider(DataService dataService) {
        this._dataService = dataService;
    }

    public OperationResult apply(ManagedObjectReference mor, DistributedVirtualPortgroup.ConfigSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = mor;
        try {
            String escapedName;
            DistributedVirtualPortgroup portgroup = (DistributedVirtualPortgroup)ManagedObjectUtil.getManagedObject((ManagedObjectReference)mor);
            spec.name = escapedName = MixedUtil.escapeVimEntityNameSpecialChars((String)spec.name);
            if (spec.configVersion == null) {
                spec.configVersion = (String)QueryUtil.getProperty((DataService)this._dataService, (Object)mor, (String)"config.configVersion");
            }
            result.task = portgroup.reconfigure(spec);
        }
        catch (Exception ex) {
            _logger.error((Object)"Cannot reconfigure dvPortGroup.", (Throwable)ex);
            result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference mor, DvPortgroupApplyRestoreSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = mor;
        try {
            String escapedName;
            DistributedVirtualPortgroup portgroup = (DistributedVirtualPortgroup)ManagedObjectUtil.getManagedObject((ManagedObjectReference)mor);
            spec.configSpec.name = escapedName = MixedUtil.escapeVimEntityNameSpecialChars((String)spec.configSpec.name);
            result.task = portgroup.reconfigure(spec.configSpec);
        }
        catch (Exception ex) {
            _logger.error((Object)"Cannot reconfigure dvPortGroup.", (Throwable)ex);
            result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return result;
    }

    public OperationResult add(DvPortgroupCreateSpec spec) {
        DistributedVirtualPortgroup.ConfigSpec[] specList = new DistributedVirtualPortgroup.ConfigSpec[]{spec.configSpec};
        OperationResult result = new OperationResult();
        result.entity = spec.switchRef;
        try {
            DistributedVirtualSwitch dvs = (DistributedVirtualSwitch)ManagedObjectUtil.getManagedObject((ManagedObjectReference)spec.switchRef);
            result.task = dvs.addPortgroups(specList);
        }
        catch (Exception e) {
            _logger.error((Object)e.getMessage());
            result.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return result;
    }

    public OperationResult[] removeOnMultiEntity(ManagedObjectReference[] dvpgMors, DvPortGroupDeleteSpec spec) {
        ArrayList<OperationResult> results = new ArrayList<OperationResult>();
        for (ManagedObjectReference dvpgMor : dvpgMors) {
            OperationResult result = new OperationResult();
            result.entity = dvpgMor;
            try {
                DistributedVirtualPortgroup distributedVirtualPortgroup = (DistributedVirtualPortgroup)ManagedObjectUtil.getManagedObject((ManagedObjectReference)dvpgMor);
                distributedVirtualPortgroup.destroy();
            }
            catch (Exception e) {
                _logger.error((Object)"The distributed port group could not be removed. ", (Throwable)e);
                result.error = MixedUtil.getMethodFault((Throwable)e);
            }
            results.add(result);
        }
        return results.toArray(new OperationResult[results.size()]);
    }
}

