/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.dvs.impl;

import com.vmware.vim.binding.vim.ConfigSpecOperation;
import com.vmware.vim.binding.vim.SharesInfo;
import com.vmware.vim.binding.vim.StringPolicy;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPort;
import com.vmware.vim.binding.vim.dvs.NetworkResourcePool;
import com.vmware.vim.binding.vim.vm.ConfigSpec;
import com.vmware.vim.binding.vim.vm.device.VirtualDevice;
import com.vmware.vim.binding.vim.vm.device.VirtualDeviceSpec;
import com.vmware.vim.binding.vim.vm.device.VirtualEthernetCard;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.util.QueryUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.common.compositecommand.api.spec.BaseCommandSpec;
import com.vmware.vsphere.client.dvs.api.spec.DvsResControlUpgradeSpec;
import com.vmware.vsphere.client.dvs.api.spec.ResControlUpgradeVersionCommandSpec;
import com.vmware.vsphere.client.dvs.impl.DvsUtil;
import com.vmware.vsphere.client.dvs.ports.DistributedVirtualPortQuerySpecBuilder;
import com.vmware.vsphere.client.dvs.specs.DvsReconfigurePortsCommandSpec;
import com.vmware.vsphere.client.dvs.specs.DvsRemoveNetworkResourcePoolSpec;
import com.vmware.vsphere.client.dvs.specs.resmgmt.DvPortgroupNrpUnassignCommandSpec;
import com.vmware.vsphere.client.network.vm.api.spec.VmReconfigureCommandSpec;
import com.vmware.vsphere.client.networking.util.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

class DvsResControlUpgradeCommandBuilder {
    private static final String RELATION_PORT_GROUP_VMS = "vm";
    private static final String PROP_DVS_UUID = "uuid";
    private static final String PROP_DVS_NRPS = "networkResourcePool";
    private static final String PROP_DVS_CONFIG_VERSION = "config.configVersion";
    private static final String PROP_PORT_GROUP_KEY = "key";
    private static final String PROP_PORT_GROUP_NRP_KEY = "config.defaultPortConfig.networkResourcePoolKey.value";
    private static final String PROP_PORT_GROUP_CONFIG_VERSION = "config.configVersion";
    private static final String PROP_VM_CHANGE_VERSION = "config.changeVersion";
    private static final String PROP_FT_ROLE_PROPERTY = "ftRole";
    private static final String PROP_TEMPLATE = "config.template";
    private static final String PROP_VM_DEVICES = "virtualEthernetDistributedBacking";
    private static final String PROP_NETIORM_POLICY_OVERRIDE = "config.policy.networkResourcePoolOverrideAllowed";
    private static final String PROP_PORT_PORT_KEY = "key";
    private static final String PROP_PORT_PORT_GROUP_KEY = "portgroupKey";
    private static final String PROP_PORT_PORT_CONFIG_VERSION = "configVersion";
    private static final String PROP_PORT_NRP_POLICY = "networkResourcePoolKeyPolicy";
    private static final String PROP_PORT_CONNECTED_ENTITY = "connectedEntityReference";
    private static final String PROP_PORT_CONFLICT = "conflict";
    private static final int MAX_PORTS_PER_COMMAND = 200;
    private final DataService _dataService;
    private final ManagedObjectReference _dvsRef;
    private final DvsResControlUpgradeSpec _spec;
    private String _dvsConfigVersion;
    private String _dvsUuid;
    private NetworkResourcePool[] _pools;
    private String[] _userDefinedNrpKeys;
    private Map<Object, Map<String, Object>> _pgProps;
    private final Map<Object, Map<String, Object>> _portProps;
    private final Set<String> _defaultNrpPortKeys;

    public DvsResControlUpgradeCommandBuilder(DataService dataService, ManagedObjectReference dvsRef, DvsResControlUpgradeSpec spec) {
        if (dataService == null) {
            throw new NullPointerException("Parameter 'dataService' is required.");
        }
        if (dvsRef == null) {
            throw new NullPointerException("Parameter 'dvsRef' is required.");
        }
        if (spec == null) {
            throw new NullPointerException("Parameter 'spec' is required.");
        }
        this._dataService = dataService;
        this._dvsRef = dvsRef;
        this._spec = spec;
        this._portProps = new HashMap<Object, Map<String, Object>>();
        this._defaultNrpPortKeys = new HashSet<String>();
    }

    public BaseCommandSpec build() throws Exception {
        this.initializeDvsProperties();
        if (this._userDefinedNrpKeys.length > 0) {
            this.initializePortgroupProperties();
            this.initializePortProperties();
        }
        ArrayList<BaseCommandSpec> upgradeSpecs = new ArrayList<BaseCommandSpec>();
        DvsRemoveNetworkResourcePoolSpec deleteNrpsSpec = null;
        if (this._userDefinedNrpKeys.length > 0) {
            upgradeSpecs.addAll(this.createPortGroupNrpUnassignSpecs());
            upgradeSpecs.addAll(this.createPortNrpUnassignSpecs());
            deleteNrpsSpec = new DvsRemoveNetworkResourcePoolSpec();
            deleteNrpsSpec.keys = this._userDefinedNrpKeys;
            deleteNrpsSpec.mor = this._dvsRef;
            upgradeSpecs.add(deleteNrpsSpec);
        }
        ResControlUpgradeVersionCommandSpec versionBumpSpec = new ResControlUpgradeVersionCommandSpec();
        versionBumpSpec.mor = this._dvsRef;
        versionBumpSpec.configVersion = this._dvsConfigVersion;
        upgradeSpecs.add((BaseCommandSpec)versionBumpSpec);
        DvsResControlUpgradeCommandBuilder.chainSpecs(upgradeSpecs);
        if (this._spec.migrateShares && this._userDefinedNrpKeys.length > 0) {
            Collection<VmReconfigureCommandSpec> vmSpecs = this.createMigrateNrpSharesSpecs();
            versionBumpSpec.dependentSpecs = (BaseCommandSpec[])vmSpecs.toArray(new VmReconfigureCommandSpec[vmSpecs.size()]);
        }
        if (deleteNrpsSpec != null) {
            deleteNrpsSpec.dependentSpecs = new BaseCommandSpec[]{versionBumpSpec};
        }
        return (BaseCommandSpec)upgradeSpecs.get(0);
    }

    private static void chainSpecs(List<BaseCommandSpec> specs) {
        BaseCommandSpec lastSpec = null;
        for (BaseCommandSpec spec : specs) {
            if (lastSpec != null) {
                lastSpec.dependentSpecs = new BaseCommandSpec[]{spec};
            }
            lastSpec = spec;
        }
    }

    private void initializeDvsProperties() throws Exception {
        Map<Object, Map<String, Object>> dvsRs = Util.propertyValuesToMap(QueryUtil.getProperties((DataService)this._dataService, (Object)this._dvsRef, (String[])new String[]{PROP_DVS_UUID, "config.configVersion", PROP_DVS_NRPS}));
        if (dvsRs.size() != 1) {
            throw new RuntimeException("Could not retrive DVS configVersion and resource pools");
        }
        Map<String, Object> dvsProps = dvsRs.values().iterator().next();
        this._pools = (NetworkResourcePool[])dvsProps.get(PROP_DVS_NRPS);
        this._dvsConfigVersion = (String)dvsProps.get("config.configVersion");
        this._dvsUuid = (String)dvsProps.get(PROP_DVS_UUID);
        this._userDefinedNrpKeys = this.extractUserDefinedResourcePoolKeys();
    }

    private void initializePortgroupProperties() throws Exception {
        QuerySpec query = QueryUtil.buildQuerySpec((Constraint)DvsUtil.createPortGroupsWithNrpConstraint(this._dvsRef), (String[])new String[]{"config.configVersion", "key", PROP_PORT_GROUP_NRP_KEY});
        this._pgProps = Util.resultSetToMap(Util.validateResultSet("query-portgroup-properties", QueryUtil.getData((DataService)this._dataService, (QuerySpec)query)));
    }

    private void initializePortProperties() throws Exception {
        ResultSet rs = DvsUtil.retrievePortGroupsByOverridablePolicy(this._dataService, this._dvsRef, PROP_NETIORM_POLICY_OVERRIDE, new String[]{"key"});
        Map<Object, Map<String, Object>> results = Util.resultSetToMap(Util.validateResultSet("query-portgroup-nrp-overrides", rs));
        ArrayList<String> overrideAllowedPgList = new ArrayList<String>();
        for (Map<String, Object> pgProps : results.values()) {
            String key = (String)pgProps.get("key");
            overrideAllowedPgList.add(key);
        }
        String[] portPropertyNames = new String[]{"key", PROP_PORT_PORT_GROUP_KEY, PROP_PORT_PORT_CONFIG_VERSION, PROP_PORT_NRP_POLICY, PROP_PORT_CONNECTED_ENTITY, PROP_PORT_CONFLICT};
        if (overrideAllowedPgList.size() > 0) {
            String[] portgroupKeys = overrideAllowedPgList.toArray(new String[overrideAllowedPgList.size()]);
            QuerySpec querySpec = new DistributedVirtualPortQuerySpecBuilder().queryName("fetch-ports-for-port-groups").dvs(this._dvsRef).filterPortgroupKey(portgroupKeys).propertyNames(portPropertyNames).build();
            this.addPortProps(Util.resultSetToMap(Util.validateResultSet("fetch-ports-for-port-groups", QueryUtil.getData((DataService)this._dataService, (QuerySpec)querySpec))));
        }
        QuerySpec querySpec = new DistributedVirtualPortQuerySpecBuilder().queryName("fetch-standalone-ports").dvs(this._dvsRef).filterInside(false).propertyNames(portPropertyNames).build();
        this.addPortProps(Util.resultSetToMap(Util.validateResultSet("fetch-standalone-ports", QueryUtil.getData((DataService)this._dataService, (QuerySpec)querySpec))));
    }

    private void addPortProps(Map<Object, Map<String, Object>> portProps) {
        for (Map.Entry<Object, Map<String, Object>> ri : portProps.entrySet()) {
            String key = (String)ri.getValue().get("key");
            String configVersion = (String)ri.getValue().get(PROP_PORT_PORT_CONFIG_VERSION);
            StringPolicy policy = (StringPolicy)ri.getValue().get(PROP_PORT_NRP_POLICY);
            if (!StringUtils.isNotEmpty((CharSequence)key) || !StringUtils.isNotEmpty((CharSequence)configVersion) || policy == null || policy.inherited || !StringUtils.isNotEmpty((CharSequence)policy.value)) continue;
            if (!policy.value.equals("-1")) {
                this._portProps.put(ri.getKey(), ri.getValue());
                continue;
            }
            this._defaultNrpPortKeys.add(key);
        }
    }

    private List<DvPortgroupNrpUnassignCommandSpec> createPortGroupNrpUnassignSpecs() {
        ArrayList<DvPortgroupNrpUnassignCommandSpec> pgSpecs = new ArrayList<DvPortgroupNrpUnassignCommandSpec>();
        if (this._pgProps != null) {
            for (Map.Entry<Object, Map<String, Object>> ri : this._pgProps.entrySet()) {
                DvPortgroupNrpUnassignCommandSpec pgSpec = new DvPortgroupNrpUnassignCommandSpec();
                pgSpec.mor = (ManagedObjectReference)ri.getKey();
                pgSpec.configVersion = (String)ri.getValue().get("config.configVersion");
                pgSpecs.add(pgSpec);
            }
        }
        return pgSpecs;
    }

    private List<DvsReconfigurePortsCommandSpec> createPortNrpUnassignSpecs() {
        ArrayList<DvsReconfigurePortsCommandSpec> portCommandSpecs = new ArrayList<DvsReconfigurePortsCommandSpec>();
        ArrayList<DistributedVirtualPort.ConfigSpec> portConfigSpecs = new ArrayList<DistributedVirtualPort.ConfigSpec>();
        Iterator<Map<String, Object>> it = this._portProps.values().iterator();
        while (it.hasNext()) {
            Map<String, Object> pi = it.next();
            DistributedVirtualPort.ConfigSpec spec = new DistributedVirtualPort.ConfigSpec();
            spec.key = (String)pi.get("key");
            spec.configVersion = (String)pi.get(PROP_PORT_PORT_CONFIG_VERSION);
            spec.operation = ConfigSpecOperation.edit.name();
            spec.setting = new DistributedVirtualPort.Setting();
            String pgKey = (String)pi.get(PROP_PORT_PORT_GROUP_KEY);
            spec.setting.networkResourcePoolKey = StringUtils.isEmpty((CharSequence)pgKey) ? new StringPolicy(false, "-1") : new StringPolicy(true, "-1");
            portConfigSpecs.add(spec);
            if (portConfigSpecs.size() < 200 && it.hasNext()) continue;
            DvsReconfigurePortsCommandSpec portCommandSpec = new DvsReconfigurePortsCommandSpec();
            portCommandSpec.mor = this._dvsRef;
            portCommandSpec.configSpecs = portConfigSpecs.toArray(new DistributedVirtualPort.ConfigSpec[portConfigSpecs.size()]);
            portCommandSpecs.add(portCommandSpec);
            portConfigSpecs.clear();
        }
        return portCommandSpecs;
    }

    private String[] extractUserDefinedResourcePoolKeys() {
        ArrayList<String> poolKeys = new ArrayList<String>();
        if (this._pools != null) {
            for (NetworkResourcePool pool : this._pools) {
                if (DvsUtil.isSystemNetworkResourcePool(pool.key)) continue;
                poolKeys.add(pool.key);
            }
        }
        return poolKeys.toArray(new String[poolKeys.size()]);
    }

    private Collection<VmReconfigureCommandSpec> createMigrateNrpSharesSpecs() throws Exception {
        Map<Object, Map<String, Object>> vmProps = this.retrieveHardwareForVmsAssociatedWithNrp();
        if (vmProps.size() == 0) {
            return Collections.emptyList();
        }
        Map<String, SharesInfo> nrpKeyToSharesMap = this.createNrpKeyToSharesMap();
        Map<String, String> pgKeyToNrpKeyMap = this.createPortGroupKeyToNrpKeyMap();
        Map<String, String> portKeyToNrpKeyMap = this.createPortKeyToNrpKeyMap();
        Map<String, SharesInfo> pgKeyToSharesMap = this.createObjectKeyToSharesMap(nrpKeyToSharesMap, pgKeyToNrpKeyMap);
        Map<String, SharesInfo> portKeyToSharesMap = this.createObjectKeyToSharesMap(nrpKeyToSharesMap, portKeyToNrpKeyMap);
        Map<ManagedObjectReference, List<VirtualDeviceSpec>> deviceChanges = this.createDeviceChangesList(this._dvsUuid, vmProps, pgKeyToSharesMap, portKeyToSharesMap);
        List<VmReconfigureCommandSpec> commands = this.createVmCommands(vmProps, deviceChanges);
        return commands;
    }

    private Map<ManagedObjectReference, List<VirtualDeviceSpec>> createDeviceChangesList(String switchUuid, Map<Object, Map<String, Object>> vmProps, Map<String, SharesInfo> pgKeyToSharesMap, Map<String, SharesInfo> portKeyToSharesMap) {
        HashMap<ManagedObjectReference, List<VirtualDeviceSpec>> deviceChanges = new HashMap<ManagedObjectReference, List<VirtualDeviceSpec>>();
        for (Map.Entry<Object, Map<String, Object>> ri : vmProps.entrySet()) {
            ManagedObjectReference vmRef = (ManagedObjectReference)ri.getKey();
            VirtualDevice[] devices = (VirtualDevice[])ri.getValue().get(PROP_VM_DEVICES);
            if (devices == null) continue;
            for (VirtualDevice vd : devices) {
                ArrayList<VirtualDeviceSpec> dcList;
                boolean hasDefaultShares;
                if (!(vd instanceof VirtualEthernetCard) || !(vd.backing instanceof VirtualEthernetCard.DistributedVirtualPortBackingInfo) || vd.backing == null) continue;
                VirtualEthernetCard card = (VirtualEthernetCard)vd;
                VirtualEthernetCard.DistributedVirtualPortBackingInfo backing = (VirtualEthernetCard.DistributedVirtualPortBackingInfo)vd.backing;
                if (backing.port == null || !switchUuid.equals(backing.port.switchUuid)) continue;
                boolean bl = hasDefaultShares = card.resourceAllocation == null || card.resourceAllocation.share == null || card.resourceAllocation.share.level == SharesInfo.Level.normal;
                if (backing.port.portKey != null && this._defaultNrpPortKeys.contains(backing.port.portKey) && hasDefaultShares) continue;
                SharesInfo shares = null;
                if (backing.port.portKey != null) {
                    if (this._defaultNrpPortKeys.contains(backing.port.portKey)) {
                        shares = new SharesInfo();
                        shares.level = SharesInfo.Level.normal;
                    } else {
                        shares = portKeyToSharesMap.get(backing.port.portKey);
                    }
                }
                if (shares == null && backing.port.portgroupKey != null) {
                    shares = pgKeyToSharesMap.get(backing.port.portgroupKey);
                }
                if (shares == null || shares.level == SharesInfo.Level.normal) {
                    if (hasDefaultShares) continue;
                    if (shares == null) {
                        shares = new SharesInfo();
                        shares.level = SharesInfo.Level.normal;
                    }
                }
                if ((dcList = (ArrayList<VirtualDeviceSpec>)deviceChanges.get(vmRef)) == null) {
                    dcList = new ArrayList<VirtualDeviceSpec>();
                    deviceChanges.put(vmRef, dcList);
                }
                dcList.add(this.createDeviceChange((VirtualEthernetCard)vd, shares));
            }
        }
        return deviceChanges;
    }

    private VirtualDeviceSpec createDeviceChange(VirtualEthernetCard nic, SharesInfo shares) {
        if (nic.resourceAllocation == null) {
            nic.resourceAllocation = new VirtualEthernetCard.ResourceAllocation();
        }
        nic.resourceAllocation.share = shares;
        VirtualDeviceSpec deviceChange = new VirtualDeviceSpec();
        deviceChange.operation = VirtualDeviceSpec.Operation.edit;
        deviceChange.device = nic;
        return deviceChange;
    }

    private List<VmReconfigureCommandSpec> createVmCommands(Map<Object, Map<String, Object>> vmProps, Map<ManagedObjectReference, List<VirtualDeviceSpec>> deviceChanges) {
        ArrayList<VmReconfigureCommandSpec> commands = new ArrayList<VmReconfigureCommandSpec>();
        for (Map.Entry<Object, Map<String, Object>> ri : vmProps.entrySet()) {
            ManagedObjectReference vmRef = (ManagedObjectReference)ri.getKey();
            String vmChangeVersion = (String)ri.getValue().get(PROP_VM_CHANGE_VERSION);
            VmReconfigureCommandSpec spec = new VmReconfigureCommandSpec();
            spec.mor = vmRef;
            spec.configSpec = new ConfigSpec();
            spec.configSpec.changeVersion = vmChangeVersion;
            List<VirtualDeviceSpec> dcList = deviceChanges.get(vmRef);
            if (dcList == null) continue;
            spec.configSpec.deviceChange = dcList.toArray(new VirtualDeviceSpec[dcList.size()]);
            commands.add(spec);
        }
        return commands;
    }

    private Map<String, SharesInfo> createObjectKeyToSharesMap(Map<String, SharesInfo> nrpKeyToSharesMap, Map<String, String> objKeyToNrpKeyMap) {
        HashMap<String, SharesInfo> map = new HashMap<String, SharesInfo>();
        for (Map.Entry<String, String> pgEntry : objKeyToNrpKeyMap.entrySet()) {
            map.put(pgEntry.getKey(), nrpKeyToSharesMap.get(pgEntry.getValue()));
        }
        return map;
    }

    private Map<String, String> createPortGroupKeyToNrpKeyMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        if (this._pgProps != null) {
            for (Map<String, Object> ri : this._pgProps.values()) {
                String pgKey = (String)ri.get("key");
                String nrpKey = (String)ri.get(PROP_PORT_GROUP_NRP_KEY);
                if (pgKey == null) continue;
                map.put(pgKey, nrpKey);
            }
        }
        return map;
    }

    private Map<String, String> createPortKeyToNrpKeyMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map<String, Object> ri : this._portProps.values()) {
            String portKey = (String)ri.get("key");
            StringPolicy policy = (StringPolicy)ri.get(PROP_PORT_NRP_POLICY);
            map.put(portKey, policy.value);
        }
        return map;
    }

    private Map<String, SharesInfo> createNrpKeyToSharesMap() {
        HashMap<String, SharesInfo> map = new HashMap<String, SharesInfo>();
        if (this._pools != null) {
            for (NetworkResourcePool pool : this._pools) {
                SharesInfo shares = pool == null || pool.allocationInfo == null ? null : pool.allocationInfo.shares;
                map.put(pool.key, shares);
            }
        }
        return map;
    }

    private Map<Object, Map<String, Object>> retrieveHardwareForVmsAssociatedWithNrp() throws Exception {
        RelationalConstraint constraint = QueryUtil.createRelationalConstraint((String)RELATION_PORT_GROUP_VMS, (Constraint)DvsUtil.createPortGroupsWithNrpConstraint(this._dvsRef), (Boolean)true, (String)VirtualMachine.class.getSimpleName());
        String[] vmPropertyNames = new String[]{PROP_VM_CHANGE_VERSION, PROP_VM_DEVICES, PROP_FT_ROLE_PROPERTY, PROP_TEMPLATE};
        QuerySpec query = QueryUtil.buildQuerySpec((Constraint)constraint, (String[])vmPropertyNames);
        Map<Object, Map<String, Object>> vmProps = Util.resultSetToMap(Util.validateResultSet("query-vm-props", QueryUtil.getData((DataService)this._dataService, (QuerySpec)query)));
        ArrayList<ManagedObjectReference> vms = new ArrayList<ManagedObjectReference>();
        for (Map<String, Object> map : this._portProps.values()) {
            ManagedObjectReference managedObjectReference = (ManagedObjectReference)map.get(PROP_PORT_CONNECTED_ENTITY);
            boolean isConflictPort = (Boolean)map.get(PROP_PORT_CONFLICT);
            if (managedObjectReference == null || !ManagedObjectUtil.isOfType((ManagedObjectReference)managedObjectReference, VirtualMachine.class) || vmProps.containsKey(managedObjectReference) || isConflictPort) continue;
            vms.add(managedObjectReference);
        }
        if (vms.size() > 0) {
            Map<Object, Map<String, Object>> portOverrideVmProps = DvsUtil.queryProperties(this._dataService, vms, vmPropertyNames);
            for (Map.Entry<Object, Map<String, Object>> entry : portOverrideVmProps.entrySet()) {
                vmProps.put(entry.getKey(), entry.getValue());
            }
        }
        Iterator<Map.Entry<Object, Map<String, Object>>> iter = vmProps.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Object, Map<String, Object>> entry = iter.next();
            Integer n = (Integer)entry.getValue().get(PROP_FT_ROLE_PROPERTY);
            Boolean isTemplate = (Boolean)entry.getValue().get(PROP_TEMPLATE);
            if (!Boolean.TRUE.equals(isTemplate) && (n == null || n <= 1)) continue;
            iter.remove();
        }
        return vmProps;
    }
}

