/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.network.host.iscsi.impl;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.mutation.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.common.compositecommand.CommandExecutionEngine;
import com.vmware.vsphere.client.common.compositecommand.CommandFactory;
import com.vmware.vsphere.client.common.compositecommand.api.spec.BaseCommandSpec;
import com.vmware.vsphere.client.common.compositecommand.api.spec.DummyCommandSpec;
import com.vmware.vsphere.client.common.compositecommand.network.NetworkCommandFactory;
import com.vmware.vsphere.client.network.host.iscsi.specs.BindVnicCommandSpec;
import com.vmware.vsphere.client.network.host.iscsi.specs.IscsiPortBindingAddSpec;
import com.vmware.vsphere.client.network.host.iscsi.specs.IscsiPortBindingParams;
import com.vmware.vsphere.client.network.host.iscsi.specs.IscsiPortBindingRemoveSpec;
import com.vmware.vsphere.client.network.host.iscsi.specs.UnbindVnicCommandSpec;
import com.vmware.vsphere.client.networking.util.Util;
import java.util.ArrayList;

public class IscsiPortInfoMutationProvider
implements MutationProvider {
    private final DataService _dataService;

    public IscsiPortInfoMutationProvider(DataService dataService) {
        this._dataService = dataService;
    }

    public OperationResult apply(ManagedObjectReference entity, IscsiPortBindingAddSpec spec) throws Exception {
        if (spec.params == null) {
            String errorMessage = Util.getLocalizedString("iscsi.invalidPortBindingSpecParamsError");
            OperationResult result = new OperationResult();
            result.entity = entity;
            result.error = MixedUtil.getRuntimeFault((String)errorMessage);
            return result;
        }
        ArrayList<BindVnicCommandSpec> bindVnicCommandsSpecs = new ArrayList<BindVnicCommandSpec>();
        for (IscsiPortBindingParams bindingParams : spec.params) {
            BindVnicCommandSpec bindVnicCommandSpec = new BindVnicCommandSpec();
            bindVnicCommandSpec.iscsiHbaName = bindingParams.iscsiHbaName;
            bindVnicCommandSpec.vnicDevice = bindingParams.vnicDevice;
            bindVnicCommandsSpecs.add(bindVnicCommandSpec);
        }
        DummyCommandSpec rootCommandSpec = new DummyCommandSpec();
        rootCommandSpec.mor = entity;
        rootCommandSpec.dependentSpecs = bindVnicCommandsSpecs.toArray(new BaseCommandSpec[0]);
        NetworkCommandFactory factory = new NetworkCommandFactory();
        CommandExecutionEngine engine = new CommandExecutionEngine((BaseCommandSpec)rootCommandSpec, this._dataService, (CommandFactory)factory);
        engine.execute();
        OperationResult result = engine.getResult();
        result.effect.isDelayed = true;
        return result;
    }

    public OperationResult apply(ManagedObjectReference entity, IscsiPortBindingRemoveSpec spec) throws Exception {
        if (spec.params == null) {
            String errorMessage = Util.getLocalizedString("iscsi.invalidPortBindingSpecParamsError");
            OperationResult result = new OperationResult();
            result.entity = entity;
            result.error = MixedUtil.getRuntimeFault((String)errorMessage);
            return result;
        }
        ArrayList<UnbindVnicCommandSpec> unbindVnicCommandsSpecs = new ArrayList<UnbindVnicCommandSpec>();
        for (IscsiPortBindingParams bindingParams : spec.params) {
            UnbindVnicCommandSpec unbindVnicCommandSpec = new UnbindVnicCommandSpec();
            unbindVnicCommandSpec.iscsiHbaName = bindingParams.iscsiHbaName;
            unbindVnicCommandSpec.vnicDevice = bindingParams.vnicDevice;
            unbindVnicCommandSpec.forceRemoval = bindingParams.forceRemoval;
            unbindVnicCommandsSpecs.add(unbindVnicCommandSpec);
        }
        DummyCommandSpec rootCommandSpec = new DummyCommandSpec();
        rootCommandSpec.mor = entity;
        rootCommandSpec.dependentSpecs = unbindVnicCommandsSpecs.toArray(new BaseCommandSpec[0]);
        NetworkCommandFactory factory = new NetworkCommandFactory();
        CommandExecutionEngine engine = new CommandExecutionEngine((BaseCommandSpec)rootCommandSpec, this._dataService, (CommandFactory)factory);
        engine.execute();
        OperationResult result = engine.getResult();
        result.effect.isDelayed = true;
        return result;
    }
}

